/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.modeling.app.jsf.generation;

import org.eclipse.stardust.ide.wst.modeling.app.jsf.JSF_Messages;

public class MappedType {
    public static final int NORMAL = 0;
    public static final int ALTERNATE_1 = 1;
    public static final int ALTERNATE_2 = 2;
    public static final int FIELD_CONTROL_TYPE = 0;
    public static final int COMBOBOX_CONTROL_TYPE = 1;
    public static final int BUTTON_CONTROL_TYPE = 2;
    public static final int CHECKBOX_CONTROL_TYPE = 3;
    public static final int TEXT_CONTROL_TYPE = 4;
    private Class<?> mappedType;
    private int controlType;

    public MappedType(Class<?> mappedType, int controlType) {
        this.mappedType = mappedType;
        this.controlType = controlType;
    }

    public boolean hasControlType(int type) {
        boolean result = true;
        switch (type) {
            case 1: {
                result = Integer.class.equals(this.mappedType) || String.class.equals(this.mappedType) || Boolean.class.equals(this.mappedType);
                break;
            }
            case 2: {
                result = String.class.equals(this.mappedType);
            }
        }
        return result;
    }

    public String getControlLabel(int type) {
        String controlLabel = "";
        switch (type) {
            case 0: {
                if (Boolean.class.equals(this.mappedType)) {
                    controlLabel = JSF_Messages.LB_CheckBox;
                    break;
                }
                controlLabel = JSF_Messages.LB_Field;
                break;
            }
            case 1: {
                if (Integer.class.equals(this.mappedType) || String.class.equals(this.mappedType)) {
                    controlLabel = JSF_Messages.LB_ComboBox;
                    break;
                }
                if (!Boolean.class.equals(this.mappedType)) break;
                controlLabel = JSF_Messages.LB_Btn;
                break;
            }
            case 2: {
                if (!String.class.equals(this.mappedType)) break;
                controlLabel = JSF_Messages.LB_Txt;
            }
        }
        return controlLabel;
    }

    public void setControlType(int controlType) {
        this.controlType = controlType;
    }

    public Class<?> getMappedType() {
        return this.mappedType;
    }

    public int getControlType() {
        return this.controlType;
    }
}

