/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.modeling.app.jsf.generation;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataXPathUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.JSF_Messages;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.GenericDataMapping;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.JSFPanelGenerator;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;

public class StructuredDataPanelGenerator {
    private static final String DECIMAL_XSD_TYPE = "decimal";
    public static final String DURATION_REG_EXP_PATTERN = "^[0-9]{0,3}:([0-9]|10|11):(([3][0-6][0-5])|([3][0-5][0-9])|([0-2]{0,1}[0-9]{0,2})):(([2][0-3])|([0-1]{0,1}[0-9]{0,1})):([0-5]{0,1}[0-9]{0,1}):([0-5]{0,1}[0-9]{0,1})$";
    private String wrapperVariableName;
    private String variableName;
    private String startXPath;
    private boolean readOnly;
    private IXPathMap xPathMap;
    private String indent;
    private Stack<String> ids = new Stack();

    public StructuredDataPanelGenerator(String indent, GenericDataMapping mapping, String wrapperVariableName, boolean readOnly) {
        this.indent = indent;
        this.wrapperVariableName = wrapperVariableName;
        this.variableName = String.valueOf(wrapperVariableName) + ".complexType";
        this.startXPath = mapping.getDataMapping().getDataPath();
        this.readOnly = readOnly;
        DataType data = mapping.getDataMapping().getData();
        this.xPathMap = StructuredTypeUtils.getXPathMap((DataType)data);
        this.ids.push(this.validateId(mapping.getId()));
    }

    public void createPanel(StringBuffer xml) {
        TypedXPath typedXPath = this.xPathMap.getXPath(StructuredDataXPathUtils.getXPathWithoutIndexes((String)this.startXPath));
        LinkedList path = CollectionUtils.newLinkedList();
        if (StructuredDataXPathUtils.canReturnList((String)this.startXPath, (IXPathMap)this.xPathMap)) {
            this.createTable(this.indent, xml, typedXPath, "", path);
        } else {
            this.createComplexTypeGui(this.indent, xml, path, typedXPath, "");
        }
    }

    private void createComplexTypeGui(String indent, StringBuffer xml, List<String> path, TypedXPath typedXPath, String parentTableExpression) {
        String panelId = "panel_" + this.makeId();
        xml.append(indent).append("<ice:panelCollapsible expanded=\"true\">").append(JSFPanelGenerator.SEP);
        String xsdTypeName = typedXPath.getXsdTypeName();
        xml.append(indent).append("  <f:facet name=\"header\"><ice:outputText value=\"").append(xsdTypeName == null ? "&lt;anonymous&gt;" : xsdTypeName).append("\"/></f:facet>").append(JSFPanelGenerator.SEP);
        xml.append(indent).append("  <h:panelGrid id=\"").append(panelId).append("\" columns=\"2\" styleClass=\"table-form\" columnClasses=\"table-label-column,table-component-column\">").append(JSFPanelGenerator.SEP);
        String innerIndent = String.valueOf(indent) + "    ";
        if (typedXPath.getType() != -1) {
            xml.append(String.valueOf(innerIndent) + "<h:outputText value=\"Content:\"/>").append(JSFPanelGenerator.SEP);
            this.ids.push(this.createId(typedXPath));
            this.createValueCell(innerIndent, xml, path, typedXPath, parentTableExpression, true);
            this.ids.pop();
        }
        this.addCompositorRows(innerIndent, xml, path, parentTableExpression, typedXPath.getChildXPaths());
        xml.append(indent).append("  </h:panelGrid>").append(JSFPanelGenerator.SEP);
        xml.append(indent).append("</ice:panelCollapsible>").append(JSFPanelGenerator.SEP);
    }

    private String makeId() {
        StringBuffer sb = new StringBuffer();
        for (String id : this.ids) {
            if (sb.length() > 0) {
                sb.append('_');
            }
            sb.append(id);
        }
        return sb.toString();
    }

    private void addCompositorRows(String indent, StringBuffer xml, List<String> guiPath, String parentTableExpression, List<TypedXPath> childXPaths) {
        for (TypedXPath typedXPath : childXPaths) {
            this.createTableRow(indent, xml, guiPath, typedXPath, parentTableExpression);
        }
    }

    private void createTableRow(String indent, StringBuffer xml, List<String> path, TypedXPath typedXPath, String parentTableExpression) {
        this.ids.push(this.createId(typedXPath));
        xml.append(String.valueOf(indent) + "<h:outputText value=\"" + this.getLabel(typedXPath) + ":\"/>").append(JSFPanelGenerator.SEP);
        if (typedXPath.getType() == -1 || typedXPath.getType() != -1 && typedXPath.isList() || typedXPath.getChildXPaths().size() > 0) {
            if (typedXPath.isList()) {
                this.createTable(indent, xml, typedXPath, parentTableExpression, path);
            } else {
                this.createValueCell(indent, xml, path, typedXPath, parentTableExpression, false);
            }
        } else {
            this.createValueCell(indent, xml, path, typedXPath, parentTableExpression, false);
        }
        this.ids.pop();
    }

    private String getLabel(TypedXPath typedXPath) {
        String label = StructuredDataXPathUtils.getLastXPathPart((String)typedXPath.getXPath());
        if (StringUtils.isEmpty((String)label) && StringUtils.isEmpty((String)(label = typedXPath.getXsdElementName()))) {
            label = typedXPath.getXsdTypeName();
        }
        return label;
    }

    private String createId(TypedXPath typedXPath) {
        return this.validateId(this.getEscapedLastPart(typedXPath));
    }

    private String validateId(String rawId) {
        StringBuffer id = new StringBuffer(rawId);
        int i = 0;
        while (i < id.length()) {
            boolean valid = true;
            char c = rawId.charAt(i);
            if (i == 0) {
                valid = Character.isLetter(c) && c != '_';
            } else {
                boolean bl = valid = Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_';
            }
            if (!valid) {
                id.setCharAt(i, '_');
            }
            ++i;
        }
        return id.toString();
    }

    private String getEscapedLastPart(TypedXPath typedXPath) {
        String lastPart = StructuredDataXPathUtils.getLastXPathPart((String)typedXPath.getXPath());
        return lastPart.replace('@', '_');
    }

    private void createValueCell(String indent, StringBuffer xml, List<String> path, TypedXPath typedXPath, String parentTableExpression, boolean elementContentOnly) {
        String variableName = typedXPath.getType() != -1 && typedXPath.getChildXPaths().size() == 0 && typedXPath.isList() ? "#{" + this.variableName + ".value" + "}" : (elementContentOnly ? "#{" + this.composeVariableName(path) + "['@']}" : "#{" + this.composeVariableName(path) + "['" + StructuredDataXPathUtils.getLastXPathPart((String)typedXPath.getXPath()) + "']}");
        String xsdType = typedXPath.getXsdTypeName();
        String valueComponentId = this.makeId();
        if (typedXPath.getChildXPaths().size() > 0 && !elementContentOnly) {
            LinkedList<String> childPath = new LinkedList<String>(path);
            childPath.add(StructuredDataXPathUtils.getLastXPathPart((String)typedXPath.getXPath()));
            this.createComplexTypeGui(indent, xml, childPath, typedXPath, parentTableExpression);
        } else if (typedXPath.isEnumeration()) {
            xml.append(indent).append("<ice:selectOneMenu disabled=\"").append(this.readOnly).append("\" id=\"").append(valueComponentId).append("\" value=\"").append(variableName).append("\">").append(JSFPanelGenerator.SEP);
            xml.append(indent).append("  <f:selectItem itemLabel=\"\" itemValue=\"\"/>").append(JSFPanelGenerator.SEP);
            List enumerationValues = typedXPath.getEnumerationValues();
            for (Object value : enumerationValues) {
                xml.append(indent).append("  <f:selectItem itemLabel=\"").append(value.toString()).append("\" itemValue=\"").append(value.toString()).append("\"/>").append(JSFPanelGenerator.SEP);
            }
            xml.append(indent).append("</ice:selectOneMenu>").append(JSFPanelGenerator.SEP);
        } else if (typedXPath.getType() == 8 && !DECIMAL_XSD_TYPE.equals(xsdType)) {
            xml.append(indent).append("<ice:inputText id=\"").append(valueComponentId).append("\" disabled=\"").append(this.readOnly).append("\" value=\"").append(variableName).append("\"/>").append(JSFPanelGenerator.SEP);
        } else if (typedXPath.getType() == 0) {
            xml.append(indent).append("<ice:selectBooleanCheckbox id=\"").append(valueComponentId).append("\" disabled=\"").append(this.readOnly).append("\" value=\"").append(variableName).append("\"/>").append(JSFPanelGenerator.SEP);
        } else if (typedXPath.getType() == 4 || typedXPath.getType() == 5 || typedXPath.getType() == 3 || typedXPath.getType() == 2 || typedXPath.getType() == 7 || typedXPath.getType() == 6 || DECIMAL_XSD_TYPE.equals(xsdType)) {
            xml.append(indent).append("<ice:inputText id=\"").append(valueComponentId).append("\" disabled=\"").append(this.readOnly).append("\" value=\"").append(variableName).append("\" validator=\"").append(this.createValidator(typedXPath)).append("\"/>").append(JSFPanelGenerator.SEP);
        } else if ("dateTime".equals(xsdType)) {
            xml.append(indent).append("<ice:inputText id=\"").append(valueComponentId).append("\" disabled=\"").append(this.readOnly).append("\" value=\"").append(variableName).append("\"><f:convertDateTime locale=\"en\" type=\"both\"/></ice:inputText>").append(JSFPanelGenerator.SEP);
        } else if ("date".equals(xsdType)) {
            xml.append(indent).append("<ice:inputText id=\"").append(valueComponentId).append("\" disabled=\"").append(this.readOnly).append("\" value=\"").append(variableName).append("\"><f:convertDateTime locale=\"en\" type=\"date\"/></ice:inputText>").append(JSFPanelGenerator.SEP);
        } else if ("time".equals(xsdType)) {
            xml.append(indent).append("<ice:inputText id=\"").append(valueComponentId).append("\" disabled=\"").append(this.readOnly).append("\" value=\"").append(variableName).append("\"><f:convertDateTime locale=\"en\" type=\"time\" pattern=\"HH:mm:ss\"/></ice:inputText>").append(JSFPanelGenerator.SEP);
        } else if ("duration".equals(xsdType)) {
            xml.append(indent).append("<ice:inputText id=\"").append(valueComponentId).append("\" disabled=\"").append(this.readOnly).append("\" value=\"").append(variableName).append("\"><f:validateRegex pattern=\"").append(DURATION_REG_EXP_PATTERN).append("\"/></ice:inputText>").append(JSFPanelGenerator.SEP);
        } else {
            xml.append(indent).append("<ice:inputText id=\"").append(valueComponentId).append("\" disabled=\"").append(this.readOnly).append("\" value=\"").append(variableName).append("\"/>").append(JSFPanelGenerator.SEP);
        }
    }

    private void createTable(String indent, StringBuffer xml, TypedXPath typedXPath, String parentTableExpression, List<String> path) {
        String lastXPathPart = StructuredDataXPathUtils.getLastXPathPart((String)typedXPath.getXPath());
        String tmp = this.variableName;
        this.variableName = String.valueOf(lastXPathPart) + "Row";
        String tableId = "table_" + this.makeId();
        String tableModelExpression = this.getTableModelExpression(parentTableExpression, path, typedXPath);
        String addLinkId = String.valueOf(tableId) + "_add";
        String deleteLinkId = String.valueOf(tableId) + "_delete";
        xml.append(indent).append("<ice:panelCollapsible expanded=\"true\">").append(JSFPanelGenerator.SEP);
        String xsdTypeName = typedXPath.getXsdTypeName();
        xml.append(indent).append("  <f:facet name=\"header\"><ice:outputText value=\"List of ").append(xsdTypeName == null ? "&lt;anonymous&gt;" : xsdTypeName).append("\"/></f:facet>").append(JSFPanelGenerator.SEP);
        xml.append(indent).append("  <h:dataTable id=\"").append(tableId).append("\" var=\"").append(this.variableName).append("\" value=\"#{").append(tableModelExpression).append("}\">").append(JSFPanelGenerator.SEP);
        parentTableExpression = String.valueOf(tableModelExpression) + "[" + this.variableName + "]";
        String innerIndent = String.valueOf(indent) + "    ";
        this.createNumberColumn(innerIndent, xml, tableModelExpression);
        this.createSummaryColumn(innerIndent, xml, typedXPath, parentTableExpression);
        this.createDeletionColumn(innerIndent, xml, tableModelExpression, deleteLinkId);
        xml.append(innerIndent).append("<f:facet name=\"footer\">").append(JSFPanelGenerator.SEP);
        xml.append(innerIndent).append("  <ice:commandLink id=\"").append(addLinkId).append("\" partialSubmit=\"true\" rendered=\"").append(!this.readOnly).append("\" actionListener=\"#{").append(tableModelExpression).append("['new()'].create}\">").append(JSFPanelGenerator.SEP);
        xml.append(innerIndent).append("    <ice:graphicImage style=\"border: none;\" value=\"/plugins/processportal/images/add.png\"/>").append(JSFPanelGenerator.SEP);
        boolean primitiveType = true;
        if (typedXPath.getType() == -1 || typedXPath.getChildXPaths().size() > 0) {
            xml.append(innerIndent).append("    <f:attribute name=\"createCollections\" value=\"").append(this.getChildCollectionsString("", typedXPath)).append("\"/>").append(JSFPanelGenerator.SEP);
            primitiveType = false;
        }
        xml.append(innerIndent).append("    <f:attribute name=\"primitiveType\" value=\"").append(Boolean.toString(primitiveType)).append("\"/>").append(JSFPanelGenerator.SEP);
        xml.append(innerIndent).append("  </ice:commandLink>").append(JSFPanelGenerator.SEP);
        xml.append(innerIndent).append("</f:facet>").append(JSFPanelGenerator.SEP);
        xml.append(indent).append("  </h:dataTable>").append(JSFPanelGenerator.SEP);
        xml.append(indent).append("</ice:panelCollapsible>").append(JSFPanelGenerator.SEP);
        this.variableName = tmp;
    }

    private Object getChildCollectionsString(String namePrefix, TypedXPath typedXPath) {
        StringBuffer result = new StringBuffer();
        this.getCompositorCollectionsString(namePrefix, result, typedXPath.getChildXPaths());
        return result.toString();
    }

    private void getCompositorCollectionsString(String namePrefix, StringBuffer result, List<TypedXPath> childXPaths) {
        for (TypedXPath typedXPath : childXPaths) {
            String lastXPathPart = StructuredDataXPathUtils.getLastXPathPart((String)typedXPath.getXPath());
            if (typedXPath.isList()) {
                result.append(namePrefix).append(lastXPathPart).append("=List,");
                continue;
            }
            if (typedXPath.getType() != -1 && typedXPath.getChildXPaths().size() <= 0) continue;
            result.append(namePrefix).append(lastXPathPart).append("=Map,");
            result.append(this.getChildCollectionsString(String.valueOf(lastXPathPart) + "/", typedXPath));
        }
    }

    private void createDeletionColumn(String indent, StringBuffer xml, String tableModelExpression, String linkId) {
        xml.append(indent).append("<ice:column style=\"width: 5%; align: right;\">").append(JSFPanelGenerator.SEP);
        xml.append(indent).append("  <ice:commandLink id=\"").append(linkId).append("\" partialSubmit=\"true\" rendered=\"").append(!this.readOnly).append("\" action=\"#{").append(tableModelExpression).append("['remove()'][").append(this.variableName).append("].remove}\">").append(JSFPanelGenerator.SEP);
        xml.append(indent).append("    <ice:graphicImage style=\"border: none;\" value=\"/plugins/processportal/images/delete.png\"/>").append(JSFPanelGenerator.SEP);
        xml.append(indent).append("  </ice:commandLink>").append(JSFPanelGenerator.SEP);
        xml.append(indent).append("</ice:column>").append(JSFPanelGenerator.SEP);
    }

    private void createSummaryColumn(String indent, StringBuffer xml, TypedXPath typedXPath, String parentTableExpression) {
        xml.append(indent).append("<ice:column style=\"width: 75%; align: left;\">").append(JSFPanelGenerator.SEP);
        String innerIndent = String.valueOf(indent) + "  ";
        if (typedXPath.getType() == -1 || typedXPath.getChildXPaths().size() > 0) {
            this.createComplexTypeGui(innerIndent, xml, new LinkedList<String>(), typedXPath, parentTableExpression);
        } else {
            this.createValueCell(innerIndent, xml, new LinkedList<String>(), typedXPath, parentTableExpression, false);
        }
        xml.append(indent).append("</ice:column>").append(JSFPanelGenerator.SEP);
    }

    private void createNumberColumn(String indent, StringBuffer xml, String tableModelExpression) {
        xml.append(indent).append("<ice:column style=\"width: 10%; align: left;\">").append(JSFPanelGenerator.SEP);
        xml.append(indent).append("  <h:outputText value=\"#{").append(tableModelExpression).append("['rowIndex()']}\"/>").append(JSFPanelGenerator.SEP);
        xml.append(indent).append("</ice:column>").append(JSFPanelGenerator.SEP);
    }

    private String getTableModelExpression(String parentTableExpression, List<String> path, TypedXPath typedXPath) {
        if (typedXPath.getXPath().equals(this.startXPath)) {
            return String.valueOf(this.wrapperVariableName) + ".tableModels['']";
        }
        String subTable = "";
        Iterator<String> i = path.iterator();
        while (i.hasNext()) {
            subTable = String.valueOf(subTable) + i.next() + ".";
        }
        subTable = String.valueOf(subTable) + StructuredDataXPathUtils.getLastXPathPart((String)typedXPath.getXPath());
        if (StringUtils.isEmpty((String)parentTableExpression)) {
            return String.valueOf(this.wrapperVariableName) + ".tableModels['" + subTable + "']";
        }
        return String.valueOf(parentTableExpression) + "['" + subTable + "']";
    }

    private String composeVariableName(List<String> path) {
        String result = this.variableName;
        Iterator<String> i = path.iterator();
        while (i.hasNext()) {
            result = String.valueOf(result) + "['" + i.next() + "']";
        }
        return result;
    }

    private String createValidator(TypedXPath xPath) {
        int type = xPath.getType();
        String validator = null;
        if (type == 5) {
            validator = "#{structuredDataValidator.validateLong}";
        } else if (type == 4) {
            validator = "#{structuredDataValidator.validateInt}";
        } else if (type == 3) {
            validator = "#{structuredDataValidator.validateShort}";
        } else if (type == 2) {
            validator = "#{structuredDataValidator.validateByte}";
        } else if (type == 7) {
            validator = "#{structuredDataValidator.validateDouble}";
        } else if (type == 6) {
            validator = "#{structuredDataValidator.validateFloat}";
        } else if (xPath.getXsdTypeName().equals(DECIMAL_XSD_TYPE)) {
            validator = "#{structuredDataValidator.validateDecimal}";
        } else {
            throw new PublicException(MessageFormat.format(JSF_Messages.Could_not_create_validator_for_XSD_type, xPath.getXsdTypeName()));
        }
        return validator;
    }
}

