/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.modeling.app.jsf.wizard;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.JSF_Messages;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.GenericDataMapping;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.JSFPanelGenerator;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.ManualActivityToJsfConverter;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.ui.common.form.preferences.FormGenerationPreferences;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;

public class JSFGuiGenerationWizardPage1
extends WizardPage
implements IWizardPage,
SelectionListener,
Listener {
    private static final String BEAN_SCOPE = "session";
    private static final String JAVAX_FACES_CONFIG_FILES = "javax.faces.CONFIG_FILES";
    private static final String DEFAULT_PANEL_NAME_POSTFIX = "Panel";
    private static final String DEFAULT_ADAPTER_NAME_POSTFIX = "Bean";
    private static final String DEFAULT_WEB_ROOT = "WebContent";
    private static final String DEFAULT_GUI_DIRECTORY = "/xhtml";
    private ActivityType activityType;
    private Text applicationNameField;
    private Text webRootField;
    private Button webRootBrowseButton;
    private Text panelLocationField;
    private Button panelLocationBrowseButton;
    private Text panelNameField;
    private Text adapterNameField;
    private Text adapterLocationNameField;
    private Button adapterLocationBrowseButton;
    private IPackageFragment fragment;
    protected boolean packageExists = false;
    private String createResourceFlag;

    protected JSFGuiGenerationWizardPage1(String pageName, ActivityType activityType) {
        super(pageName);
        this.activityType = activityType;
    }

    public void createControl(Composite parent) {
        Composite generateGuiGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.verticalAlignment = 2;
        data.horizontalAlignment = 32;
        generateGuiGroup.setLayout((Layout)layout);
        generateGuiGroup.setLayoutData((Object)data);
        FormBuilder.createLabel((Composite)generateGuiGroup, (String)JSF_Messages.LB_AppName);
        this.applicationNameField = FormBuilder.createText((Composite)generateGuiGroup, (int)2);
        this.applicationNameField.addListener(24, (Listener)this);
        FormBuilder.createLabel((Composite)generateGuiGroup, (String)JSF_Messages.JSFGuiGenerationWizardPage1_0);
        this.webRootField = FormBuilder.createText((Composite)generateGuiGroup);
        this.webRootField.addListener(24, (Listener)this);
        this.webRootBrowseButton = FormBuilder.createButton((Composite)generateGuiGroup, (String)JSF_Messages.BTN_Browse, (SelectionListener)this);
        FormBuilder.createLabel((Composite)generateGuiGroup, (String)JSF_Messages.LB_PanelLocation);
        this.panelLocationField = FormBuilder.createText((Composite)generateGuiGroup);
        this.panelLocationField.addListener(24, (Listener)this);
        this.panelLocationBrowseButton = FormBuilder.createButton((Composite)generateGuiGroup, (String)JSF_Messages.BTN_Browse, (SelectionListener)this);
        FormBuilder.createLabel((Composite)generateGuiGroup, (String)JSF_Messages.LB_PanelName);
        this.panelNameField = FormBuilder.createText((Composite)generateGuiGroup, (int)2);
        this.panelNameField.addListener(24, (Listener)this);
        FormBuilder.createLabel((Composite)generateGuiGroup, (String)JSF_Messages.LB_AdapterLocation);
        this.adapterLocationNameField = FormBuilder.createText((Composite)generateGuiGroup);
        this.adapterLocationNameField.addListener(24, (Listener)this);
        this.adapterLocationBrowseButton = FormBuilder.createButton((Composite)generateGuiGroup, (String)JSF_Messages.BTN_Browse, (SelectionListener)this);
        FormBuilder.createLabel((Composite)generateGuiGroup, (String)JSF_Messages.LB_AdapterName);
        this.adapterNameField = FormBuilder.createText((Composite)generateGuiGroup, (int)2);
        this.adapterNameField.addListener(24, (Listener)this);
        this.setDefaultInput();
        this.setTitle(JSF_Messages.JSF_Automatic_GuiGenerationWizard_Title);
        this.setDescription(JSF_Messages.JSFGuiGenerationWizard_ChooseAdapterLocation);
        this.setControl((Control)generateGuiGroup);
    }

    public void widgetSelected(SelectionEvent event) {
        this.widgetDefaultSelected(event);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        Widget source = event.widget;
        if (source == this.webRootBrowseButton) {
            this.browseWebRoot();
        } else if (source == this.panelLocationBrowseButton) {
            this.browsePanelLocation();
        } else if (source == this.adapterLocationBrowseButton) {
            this.browseBeanPackage();
        }
    }

    public void handleEvent(Event event) {
        if (((WizardDialog)this.getWizard().getContainer()).getCurrentPage() != null) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    public void createResources(List<GenericDataMapping> genericDataMappings, FormGenerationPreferences genPrefs) throws CoreException {
        this.createJsfPanelResource(this.activityType, genericDataMappings, genPrefs);
        this.createManagedBeanResource(genericDataMappings);
        this.createFacesConfig();
    }

    public String getPageUrl() {
        return String.valueOf(this.panelLocationField.getText()) + '/' + this.panelNameField.getText() + '.' + JSFPanelGenerator.getUrlType();
    }

    public String getAdapterClass() {
        return String.valueOf(this.adapterLocationNameField.getText()) + "." + this.adapterNameField.getText();
    }

    public String getApplicationName() {
        return this.applicationNameField.getText();
    }

    private IProject getCurrentProject() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        FileEditorInput editorInput = (FileEditorInput)page.getActiveEditor().getEditorInput();
        IProject project = editorInput.getFile().getProject();
        return project;
    }

    private void setDefaultInput() {
        IProject project = this.getCurrentProject();
        String javaClassCompatibleActivityId = this.generateJavaClassName(this.activityType.getId());
        this.applicationNameField.setText(String.valueOf(javaClassCompatibleActivityId) + "App");
        IPath path = project.getFullPath();
        path = path.append(DEFAULT_WEB_ROOT);
        this.webRootField.setText(path.toString());
        String projectName = this.generateJavaName(project.getName());
        String modelName = this.generateJavaName(((ModelType)this.activityType.eContainer().eContainer()).getId());
        String processName = this.generateJavaName(((ProcessDefinitionType)this.activityType.eContainer()).getId());
        String sep = "/";
        this.panelLocationField.setText(DEFAULT_GUI_DIRECTORY + sep + projectName + sep + modelName + sep + processName);
        this.panelNameField.setText(String.valueOf(javaClassCompatibleActivityId) + DEFAULT_PANEL_NAME_POSTFIX);
        this.adapterNameField.setText(String.valueOf(javaClassCompatibleActivityId) + DEFAULT_ADAPTER_NAME_POSTFIX);
        String prefix = "org.eclipse.stardust";
        String suffix = "web.jsf.beans";
        this.adapterLocationNameField.setText(String.valueOf(prefix) + '.' + projectName + '.' + suffix + '.' + modelName + '.' + processName);
    }

    private String generateJavaName(String projectName) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < projectName.length()) {
            char c = Character.toLowerCase(projectName.charAt(i));
            if (i == 0 && Character.isJavaIdentifierStart(c) || i > 0 && Character.isJavaIdentifierPart(c)) {
                sb.append(c);
            } else {
                sb.append('_');
            }
            ++i;
        }
        return sb.toString();
    }

    private String generateJavaClassName(String name) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (i == 0 && Character.isJavaIdentifierStart(c) || i > 0 && Character.isJavaIdentifierPart(c)) {
                sb.append(c);
            } else {
                sb.append('_');
            }
            ++i;
        }
        return sb.toString();
    }

    private void browseBeanPackage() {
        Object[] result;
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        int style = 7;
        PackageSelectionDialog dialog = new PackageSelectionDialog(this.getShell(), (IRunnableContext)context, style, scope);
        dialog.setTitle(JSF_Messages.TITLE_PckgSelection);
        dialog.setMessage(JSF_Messages.MSG_PckgToFilter);
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.fragment = (IPackageFragment)result[0];
            String name = this.fragment.getElementName();
            this.adapterLocationNameField.setText(name);
        }
    }

    private void browseWebRoot() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, JSF_Messages.BTN_Browse);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.webRootField.setText(((Path)result[0]).toString());
        }
    }

    private void browsePanelLocation() {
        Object[] result;
        ContainerSelectionDialog dialog;
        IFolder folder = null;
        try {
            folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(this.getWebRootPath());
        }
        catch (IllegalArgumentException ex) {
            MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 40);
            messageBox.setMessage(ex.getLocalizedMessage());
            messageBox.open();
        }
        if (folder != null && (dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)folder, false, JSF_Messages.BTN_Browse)).open() == 0 && (result = dialog.getResult()).length == 1) {
            String path = ((Path)result[0]).toString();
            this.panelLocationField.setText(path.substring(this.webRootField.getText().trim().length()));
        }
    }

    private String getAdapterLocation() {
        String packageString = this.adapterLocationNameField.getText();
        IPath path = null;
        try {
            IPackageFragmentRoot initRoot = null;
            IJavaProject project = JavaCore.create((IProject)this.getCurrentProject());
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1) {
                    initRoot = roots[i];
                    break;
                }
                ++i;
            }
            path = initRoot.getPath();
        }
        catch (Exception exception) {}
        if (packageString != null) {
            StringTokenizer strTok = new StringTokenizer(packageString, ".");
            while (strTok.hasMoreElements()) {
                String element = (String)strTok.nextElement();
                path = path.append(element);
            }
        }
        return path.toString();
    }

    private String getBeanClassName() {
        String packageName = this.adapterLocationNameField.getText();
        String typeName = this.adapterNameField.getText();
        StringBuffer buffer = new StringBuffer();
        buffer.append(packageName);
        buffer.append(".");
        buffer.append(typeName);
        return buffer.toString();
    }

    private void createFolders(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String[] pathSegments = path.segments();
        int i = 1;
        while (i < pathSegments.length) {
            Path newPath = new Path(pathSegments[0]);
            int j = 1;
            while (j <= i) {
                newPath = newPath.append(pathSegments[j]);
                ++j;
            }
            IFolder folder = root.getFolder((IPath)newPath);
            if (!folder.exists()) {
                try {
                    folder.create(true, true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private void createResource(String xmlString, String path, String name) throws CoreException {
        this.createFolders((IPath)new Path(path));
        IFile iFile = this.getFile(path, name);
        JSFGuiGenerationWizardPage1.createResource(xmlString, iFile, this.createResourceFlag);
    }

    private IFile getFile(String path, String name) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile iFile = root.getFile(new Path(path).append(name));
        return iFile;
    }

    public static void createResource(String xmlString, IFile iFile, String resourceLabel) throws CoreException {
        ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes());
        if (iFile.exists()) {
            if (resourceLabel != null) {
                WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                Shell shell = editor.getSite().getShell();
                StringBuffer message = new StringBuffer();
                message.append(resourceLabel);
                message.append(" already exists.\nOverwrite?");
                boolean answer = MessageDialog.openQuestion((Shell)shell, (String)"Title", (String)message.toString());
                if (!answer) {
                    throw new CoreException((IStatus)new Status(8, "org.eclipse.stardust.ide.wst.modeling.app.jsf", 0, JSF_Messages.JSFGuiGenerationWizardPage1_4, null));
                }
            }
            iFile.setContents((InputStream)in, true, true, null);
        } else {
            iFile.create((InputStream)in, true, null);
        }
    }

    public void createFacesConfig() throws CoreException {
        JSFGuiGenerationWizardPage1.createOrUpdateFacesConfig(this.getWebRootPath(), this.getBeanName(), this.getBeanClassName(), this.createResourceFlag);
    }

    public static void createOrUpdateFacesConfig(IPath webRoot, String beanName, String beanClassName, String resourceLabel) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(webRoot.segment(0));
        String fileName = String.valueOf(project.getName()) + "-jsf-faces-config.xml";
        String configFile = "/WEB-INF/" + fileName;
        IFolder webContent = (IFolder)project.findMember(webRoot.removeFirstSegments(1));
        if (!webContent.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.ide.wst.modeling.app.jsf", 0, MessageFormat.format(JSF_Messages.Resource_not_found_in_project, webContent, project.getName()), null));
        }
        IFolder webInf = (IFolder)webContent.findMember("WEB-INF");
        if (webInf == null || !webInf.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.ide.wst.modeling.app.jsf", 0, MessageFormat.format(JSF_Messages.Resource_not_found_in_project, webContent.getProjectRelativePath().append("WEB-INF"), project.getName()), null));
        }
        String xhtmlString = null;
        IFile file = webInf.getFile(fileName);
        if (!file.exists()) {
            xhtmlString = JSFPanelGenerator.generateXMLForFaces(beanName, beanClassName, BEAN_SCOPE);
        } else {
            try {
                StringBuffer sb = new StringBuffer();
                InputStream stream = file.getContents();
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
                xhtmlString = JSFPanelGenerator.updateXMLForFaces(sb, beanName, beanClassName, BEAN_SCOPE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JSFGuiGenerationWizardPage1.createResource(xhtmlString, file, resourceLabel);
        WebArtifactEdit artifact = null;
        try {
            artifact = WebArtifactEdit.getWebArtifactEditForWrite((IProject)project);
        }
        catch (Throwable throwable) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.ide.wst.modeling.app.jsf", 0, MessageFormat.format(JSF_Messages.Project_is_not_a_web_project, project.getName()), null));
        }
        try {
            WebApp root = artifact.getWebApp();
            ParamValue value = null;
            EList contextParams = root.getContextParams();
            for (ParamValue param : contextParams) {
                if (!CompareHelper.areEqual((Object)JAVAX_FACES_CONFIG_FILES, (Object)param.getName())) continue;
                value = param;
                break;
            }
            if (value == null) {
                value = CommonFactory.eINSTANCE.createParamValue();
                value.setName(JAVAX_FACES_CONFIG_FILES);
                value.setValue(configFile);
                contextParams.add(value);
            } else {
                boolean found = false;
                StringTokenizer st = new StringTokenizer(value.getValue(), ",");
                while (st.hasMoreTokens()) {
                    String ctx = st.nextToken().trim();
                    if (!configFile.equals(ctx)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    value.setValue(String.valueOf(value.getValue()) + "," + configFile);
                }
            }
            artifact.saveIfNecessary(null);
        }
        finally {
            artifact.dispose();
        }
    }

    private IPath getWebRootPath() {
        return Path.fromOSString((String)this.webRootField.getText().trim());
    }

    private void createJsfPanelResource(ActivityType activityType, List<GenericDataMapping> dataMappings, FormGenerationPreferences genPrefs) throws CoreException {
        String xhtmlString = ManualActivityToJsfConverter.generateXHTMLForJsfActivity(dataMappings, this.getBeanName(), genPrefs);
        this.createResourceFlag = "The Panel " + this.panelNameField.getText();
        this.createResource(xhtmlString, String.valueOf(this.webRootField.getText()) + this.panelLocationField.getText(), String.valueOf(this.panelNameField.getText()) + '.' + JSFPanelGenerator.getResourceType());
        this.createResourceFlag = null;
    }

    private void createManagedBeanResource(List<GenericDataMapping> genericDataMappings) throws CoreException {
        String javaString = ManualActivityToJsfConverter.generateBeanForJsfActivity(genericDataMappings, this.adapterLocationNameField.getText(), this.adapterNameField.getText());
        String adapterLocation = this.getAdapterLocation();
        this.createResourceFlag = "The Adapter " + this.adapterNameField.getText();
        this.createResource(javaString, adapterLocation, String.valueOf(this.adapterNameField.getText()) + ".java");
        this.createResourceFlag = null;
    }

    private boolean validatePage() {
        this.setErrorMessage(null);
        boolean packageNameIsValid = true;
        try {
            AST.newAST((int)3).newName(this.adapterLocationNameField.getText());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            packageNameIsValid = false;
            this.setErrorMessage(JSF_Messages.MSG_IllegalPckgName);
        }
        return packageNameIsValid;
    }

    public boolean isPageComplete() {
        boolean pageIsComplete = super.isPageComplete();
        if (!this.validatePage()) {
            pageIsComplete = false;
        }
        if (this.applicationNameField == null || StringUtils.isEmpty((String)this.applicationNameField.getText())) {
            pageIsComplete = false;
        }
        if (this.webRootField == null || StringUtils.isEmpty((String)this.webRootField.getText())) {
            pageIsComplete = false;
        }
        if (this.panelNameField == null || StringUtils.isEmpty((String)this.panelNameField.getText())) {
            pageIsComplete = false;
        }
        if (this.adapterLocationNameField == null || StringUtils.isEmpty((String)this.adapterLocationNameField.getText())) {
            pageIsComplete = false;
        }
        if (this.adapterNameField == null || StringUtils.isEmpty((String)this.adapterNameField.getText())) {
            pageIsComplete = false;
        }
        return pageIsComplete;
    }

    public String getBeanName() {
        return this.adapterNameField.getText();
    }
}

