/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util.connectionhandler;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IdRef;
import org.eclipse.stardust.model.xpdl.carnot.IdRefOwner;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.connectionhandler.EObjectReference;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;

public class IdRefHandler
implements EObjectReference,
Adapter {
    private static final String CARNOT_CONNECTION_UUID = "carnot:connection:uuid";
    private static final String CARNOT_MODEL_UUID = "carnot:model:uuid";
    private IIdentifiableModelElement owner;
    private EObject target;

    private IdRefHandler(IIdentifiableModelElement owner) {
        this.owner = owner;
    }

    public void notifyChanged(Notification event) {
        Object newValue = event.getNewValue();
        if (newValue != null) {
            Object feature = event.getFeature();
            if (CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id().equals(feature) || XpdlPackage.eINSTANCE.getTypeDeclarationType_Id().equals(feature)) {
                this.updateIdRef(event.getNewValue().toString());
            }
        }
    }

    private void updateIdRef(String newId) {
        if (this.owner instanceof IdRefOwner) {
            ((IdRefOwner)((Object)this.owner)).getExternalRef().setRef(newId);
        } else if (this.owner instanceof DataType) {
            ((DataType)this.owner).getExternalReference().setXref(newId);
        }
    }

    public Notifier getTarget() {
        return this.target;
    }

    public void setTarget(Notifier target) {
        this.target = (EObject)target;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public static void adapt(IIdentifiableModelElement owner) {
        EObject other;
        EObject idRef = IdRefHandler.getIdRef(owner);
        if (idRef != null && (other = IdRefHandler.findReferencedObject(owner, idRef)) != null) {
            other.eAdapters().add((Object)new IdRefHandler(owner));
        }
    }

    private static EObject getIdRef(IIdentifiableModelElement owner) {
        return owner instanceof IdRefOwner ? ((IdRefOwner)((Object)owner)).getExternalRef() : (owner instanceof DataType ? ((DataType)owner).getExternalReference() : null);
    }

    private static EObject findReferencedObject(IIdentifiableModelElement owner, EObject idRef) {
        ModelType model;
        String referencedUuid;
        EObject other = IdRefHandler.getReferencedObject(owner, idRef);
        if (!(!(owner instanceof IExtensibleElement) || StringUtils.isEmpty((String)(referencedUuid = IdRefHandler.getConnectionUUID(owner))) || other != null && referencedUuid.equals(IdRefHandler.getModelElementUUID(other)) || (model = IdRefHandler.getReferencedModel(owner, idRef)) == null)) {
            List<? extends EObject> domain = IdRefHandler.getDomain(owner, model);
            for (EObject eObject : domain) {
                if (eObject == other || !referencedUuid.equals(IdRefHandler.getModelElementUUID(eObject))) continue;
                return eObject;
            }
        }
        return other;
    }

    private static List<? extends EObject> getDomain(IIdentifiableModelElement owner, ModelType model) {
        if (owner instanceof DataType) {
            TypeDeclarationsType typeDeclarations = model.getTypeDeclarations();
            return typeDeclarations == null ? Collections.emptyList() : typeDeclarations.getTypeDeclaration();
        }
        return IdRefHandler.getReferencedClass((IdRefOwner)((Object)owner)) == ApplicationType.class ? model.getApplication() : model.getProcessDefinition();
    }

    private static ModelType getReferencedModel(IIdentifiableModelElement owner, EObject idRef) {
        ModelType model = ModelUtils.findContainingModel(owner);
        if (model != null) {
            if (idRef instanceof IdRef) {
                IdRef ref = (IdRef)idRef;
                if (ref.getPackageRef() != null) {
                    IConnectionManager manager = model.getConnectionManager();
                    model = manager == null ? null : manager.find(ref.getPackageRef());
                }
            } else if (idRef instanceof ExternalReferenceType) {
                ExternalReferenceType extRef = (ExternalReferenceType)idRef;
                return StructuredTypeUtils.getExternalModel(model, extRef.getLocation());
            }
        }
        return model;
    }

    private static String getModelElementUUID(EObject other) {
        return other instanceof IExtensibleElement ? AttributeUtil.getAttributeValue((IExtensibleElement)other, CARNOT_MODEL_UUID) : ExtendedAttributeUtil.getAttributeValue((Extensible)other, CARNOT_MODEL_UUID);
    }

    private static String getConnectionUUID(IIdentifiableModelElement owner) {
        return owner instanceof DataType ? ((DataType)owner).getExternalReference().getUuid() : AttributeUtil.getAttributeValue(owner, CARNOT_CONNECTION_UUID);
    }

    private static EObject getReferencedObject(IIdentifiableModelElement owner, EObject idRef) {
        ModelType model;
        if (idRef instanceof IdRef) {
            Class<? extends EObject> referencedClass = IdRefHandler.getReferencedClass((IdRefOwner)((Object)owner));
            return ((IdRef)idRef).get(referencedClass);
        }
        if (idRef instanceof ExternalReferenceType && (model = ModelUtils.findContainingModel(idRef)) != null) {
            ExternalReferenceType extRef = (ExternalReferenceType)idRef;
            return StructuredTypeUtils.getTypeDeclaration(model, extRef.getLocation(), extRef.getXref());
        }
        return null;
    }

    private static Class<? extends EObject> getReferencedClass(IdRefOwner owner) {
        if (owner instanceof ActivityType && ActivityImplementationType.APPLICATION_LITERAL == ((ActivityType)owner).getImplementation()) {
            return ApplicationType.class;
        }
        return ProcessDefinitionType.class;
    }

    @Override
    public EObject getSelf() {
        return this.owner;
    }

    public static void cleanup(IIdentifiableModelElement owner) {
        EObject other;
        EObject idRef = IdRefHandler.getIdRef(owner);
        if (idRef != null && (other = IdRefHandler.findReferencedObject(owner, idRef)) != null) {
            for (Adapter adapter : other.eAdapters()) {
                if (!(adapter instanceof IdRefHandler) || ((IdRefHandler)adapter).owner != owner) continue;
                other.eAdapters().remove((Object)adapter);
                break;
            }
        }
    }
}

