/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.jface;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.stardust.modeling.common.ui.jface.IImageManager;
import org.eclipse.stardust.modeling.common.ui.jface.IconWithOverlays;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageManager
implements IImageManager {
    private final String bundleId;
    private final Plugin plugin;
    private ImageRegistry imageRegistry;
    private ImageRegistry plainImages = new ImageRegistry();
    private ImageRegistry warningImages = new ImageRegistry();
    private ImageRegistry errorImages = new ImageRegistry();
    private ImageRegistry linkImages = new ImageRegistry();
    private ImageRegistry refImages = new ImageRegistry();
    private ImageRegistry ovrIfPlainImages = new ImageRegistry();
    private ImageRegistry ovrIfWarningImages = new ImageRegistry();
    private ImageRegistry ovrIfErrorImages = new ImageRegistry();
    private ImageRegistry ovrIfLinkImages = new ImageRegistry();
    private ImageRegistry ovrIfRefImages = new ImageRegistry();
    private ImageRegistry ovrPrivatePlainImages = new ImageRegistry();
    private ImageRegistry ovrPrivateWarningImages = new ImageRegistry();
    private ImageRegistry ovrPrivateErrorImages = new ImageRegistry();
    private ImageRegistry ovrPrivateLinkImages = new ImageRegistry();
    private ImageRegistry ovrPrivateRefImages = new ImageRegistry();

    public ImageManager(String bundleId) {
        this.bundleId = bundleId;
        this.plugin = null;
    }

    public ImageManager(AbstractUIPlugin plugin) {
        this.bundleId = null;
        this.plugin = plugin;
    }

    @Override
    public ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor descriptor = this.getImageRegistry().getDescriptor(path);
        if (descriptor == null && path != null) {
            try {
                descriptor = this.loadImage(path);
            }
            catch (Exception exception) {}
        }
        return descriptor;
    }

    @Override
    public Image getImage(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image == null) {
            ImageDescriptor descriptor = this.getImageDescriptor(path);
            if (descriptor != null) {
                try {
                    image = descriptor.createImage();
                }
                catch (Exception exception) {}
            }
            if (image != null) {
                this.getImageRegistry().put(path, image);
            }
        }
        return image;
    }

    @Override
    public Image getPlainIcon(String iconLocator) {
        return this.getIcon(iconLocator, 1);
    }

    @Override
    public Image getIconWithWarnings(String iconLocator) {
        return this.getIcon(iconLocator, 3);
    }

    @Override
    public Image getIconWithErrors(String iconLocator) {
        return this.getIcon(iconLocator, 4);
    }

    public Image getIconWithLink(String iconLocator) {
        return this.getIcon(iconLocator, 100);
    }

    public Image getIconWithRef(String iconLocator) {
        return this.getIcon(iconLocator, 101);
    }

    @Override
    public Image getIcon(String iconLocator, int style) {
        ImageRegistry registry = null;
        switch (style) {
            case 1: {
                registry = this.plainImages;
                break;
            }
            case 3: {
                registry = this.warningImages;
                break;
            }
            case 4: {
                registry = this.errorImages;
                break;
            }
            case 100: {
                registry = this.linkImages;
                break;
            }
            case 101: {
                registry = this.refImages;
            }
        }
        return registry == null ? null : this.getIcon(iconLocator, registry, style);
    }

    @Override
    public ImageDescriptor getIconDescriptor(String iconLocator, int style) {
        Object result;
        if (1 == style) {
            result = this.plainImages.getDescriptor(iconLocator);
            if (result == null && (result = this.getImageDescriptor(iconLocator)) != null) {
                this.plainImages.put(iconLocator, result);
            }
        } else if (3 == style) {
            ImageDescriptor plainIcon;
            result = this.warningImages.getDescriptor(iconLocator);
            if (result == null && (plainIcon = this.getIconDescriptor(iconLocator, 1)) != null) {
                result = new IconWithOverlays(plainIcon, IconWithOverlays.OVR_WARNINGS);
                this.warningImages.put(iconLocator, result);
            }
        } else if (4 == style) {
            ImageDescriptor plainIcon;
            result = this.errorImages.getDescriptor(iconLocator);
            if (result == null && (plainIcon = this.getIconDescriptor(iconLocator, 1)) != null) {
                result = new IconWithOverlays(plainIcon, IconWithOverlays.OVR_ERRORS);
                this.errorImages.put(iconLocator, result);
            }
        } else if (100 == style) {
            ImageDescriptor plainIcon;
            result = this.linkImages.getDescriptor(iconLocator);
            if (result == null && (plainIcon = this.getIconDescriptor(iconLocator, 1)) != null) {
                result = new IconWithOverlays(plainIcon, IconWithOverlays.OVR_LINK);
                this.linkImages.put(iconLocator, result);
            }
        } else if (101 == style) {
            ImageDescriptor plainIcon;
            result = this.refImages.getDescriptor(iconLocator);
            if (result == null && (plainIcon = this.getIconDescriptor(iconLocator, 1)) != null) {
                result = new IconWithOverlays(plainIcon, IconWithOverlays.OVR_REF);
                this.refImages.put(iconLocator, result);
            }
        } else {
            result = null;
        }
        return result;
    }

    private ImageRegistry getImageRegistry() {
        if (this.plugin instanceof AbstractUIPlugin) {
            return ((AbstractUIPlugin)this.plugin).getImageRegistry();
        }
        if (this.imageRegistry == null) {
            this.imageRegistry = new ImageRegistry();
        }
        return this.imageRegistry;
    }

    private ImageDescriptor loadImage(String path) {
        try {
            URL url = new URL(path);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)(this.plugin != null ? this.plugin.getBundle().getSymbolicName() : this.bundleId), (String)path);
        }
    }

    private Image getIcon(String iconLocator, ImageRegistry registry, int style) {
        ImageDescriptor iconDescriptor;
        Image result = registry.get(iconLocator);
        if (result == null && (iconDescriptor = this.getIconDescriptor(iconLocator, style)) != null && (result = registry.get(iconLocator)) == null) {
            result = iconDescriptor.createImage();
            registry.put(iconLocator, result);
        }
        return result;
    }

    @Override
    public void registerImage(String path, Image image) {
        this.getImageRegistry().put(path, image);
    }

    @Override
    public void registerImage(String path, Image image, int style, boolean isOvrIF) {
        ImageRegistry registry = this.getRegistry(style, isOvrIF);
        if (registry != null) {
            registry.put(path, image);
        }
    }

    @Override
    public Image getImage(String path, int style, boolean isOvrIF) {
        Image image = null;
        ImageRegistry registry = this.getRegistry(style, isOvrIF);
        if (registry != null) {
            image = registry.get(path);
        }
        return image;
    }

    private ImageRegistry getRegistry(int style, boolean isOvrIF) {
        ImageRegistry registry = null;
        switch (style) {
            case 1: {
                registry = isOvrIF ? this.ovrIfPlainImages : this.ovrPrivatePlainImages;
                break;
            }
            case 3: {
                registry = isOvrIF ? this.ovrIfWarningImages : this.ovrPrivateWarningImages;
                break;
            }
            case 4: {
                registry = isOvrIF ? this.ovrIfErrorImages : this.ovrPrivateErrorImages;
                break;
            }
            case 100: {
                registry = isOvrIF ? this.ovrIfLinkImages : this.ovrPrivateLinkImages;
                break;
            }
            case 101: {
                registry = isOvrIF ? this.ovrIfRefImages : this.ovrPrivateRefImages;
            }
        }
        return registry;
    }
}

