/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.jface.databinding;

import org.eclipse.stardust.modeling.common.ui.jface.databinding.IBindingMediator;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtWidgetAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Widget;

public class SwtComboAdapter
extends SwtWidgetAdapter {
    private SelectionListener listener;

    public SwtComboAdapter(Combo control) {
        super((Widget)control);
    }

    @Override
    public void bind(IBindingMediator manager) {
        super.bind(manager);
        final Combo combo = (Combo)this.getWidget();
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SwtComboAdapter.this.updateModel(combo.getText());
            }
        });
        this.listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)SwtComboAdapter.this.getWidget();
                int selection = combo.getSelectionIndex();
                SwtComboAdapter.this.updateModel(selection < 0 ? combo.getText() : combo.getItem(combo.getSelectionIndex()));
            }
        };
        combo.addSelectionListener(this.listener);
    }

    @Override
    public void unbind() {
        if (this.listener != null) {
            if (!this.getWidget().isDisposed()) {
                ((Combo)this.getWidget()).removeSelectionListener(this.listener);
            }
            this.listener = null;
        }
        super.unbind();
    }

    @Override
    public void updateControl(Object value) {
        int index;
        Combo combo = (Combo)this.getWidget();
        if (value == null) {
            value = "";
        }
        if ((index = combo.indexOf(value.toString())) != combo.getSelectionIndex()) {
            combo.select(index);
        }
        if (index == -1 && (combo.getStyle() & 8) == 0) {
            combo.setText(value.toString());
        }
    }
}

