/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.internal.CompareDialog;
import org.eclipse.compare.internal.NullViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.compare.ComparableModelElementNode;
import org.eclipse.stardust.modeling.core.compare.ComparableModelElementStructureCreator;
import org.eclipse.stardust.modeling.core.compare.CopyUtil;
import org.eclipse.stardust.modeling.core.compare.ModelDiffViewer;
import org.eclipse.stardust.modeling.core.compare.ModelElementMergeViewer;
import org.eclipse.stardust.modeling.core.compare.ModelElementOidRegistration;
import org.eclipse.stardust.modeling.core.editors.parts.IconFactory;
import org.eclipse.swt.widgets.Composite;

public class ComparableEditorInput
extends CompareEditorInput {
    private static final String BUNDLE_NAME = "org.eclipse.stardust.modeling.core.compare.ModelElementMergeViewerResources";
    private ModelDiffViewer modelDiffViewer;
    private DiffNode input;
    private boolean threeWay = false;
    private ListenerList listenerList = new ListenerList();

    public ComparableEditorInput(CompareConfiguration configuration) {
        super(configuration);
        ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        this.setTitle(bundle.getString("title"));
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Differencer d = new Differencer();
        Object difference = d.findDifferences(this.threeWay, monitor, null, (Object)this.input.getAncestor(), (Object)this.input.getLeft(), (Object)this.input.getRight());
        return difference;
    }

    public void setInput(DiffNode input) {
        this.input = input;
        if (this.input.getAncestor() != null) {
            this.threeWay = true;
        }
        this.initializeCompareConfiguration();
    }

    public Viewer createDiffViewer(Composite parent) {
        this.modelDiffViewer = new ModelDiffViewer(parent, this.getCompareConfiguration());
        this.modelDiffViewer.setStructureCreator(new ComparableModelElementStructureCreator());
        return this.modelDiffViewer;
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Object newViewer = null;
        if (oldViewer instanceof NullViewer) {
            newViewer = new ModelElementMergeViewer(parent, 0, this.getCompareConfiguration(), input, (Viewer)this.modelDiffViewer);
            this.modelDiffViewer.addSelectionChangedListener((ISelectionChangedListener)newViewer);
        } else {
            newViewer = oldViewer;
        }
        return newViewer;
    }

    void initializeCompareConfiguration() {
        if (this.input.getAncestor() != null) {
            Object ancestorNode = ((ComparableModelElementNode)this.input.getAncestor()).getChildren()[0];
            String ancestorLabel = ((ComparableModelElementNode)((Object)ancestorNode)).getName();
            EObject ancestorElement = ((ComparableModelElementNode)((Object)ancestorNode)).getEObject();
            this.getCompareConfiguration().setAncestorLabel(ancestorLabel);
            if (ancestorElement != null) {
                this.getCompareConfiguration().setAncestorImage(DiagramPlugin.getImage(IconFactory.getDefault().getIconFor(ancestorElement)));
            }
        }
        CopyUtil.reset();
        EObject leftElement = null;
        if (this.input.getLeft() != null) {
            Object leftNode = ((ComparableModelElementNode)this.input.getLeft()).getChildren()[0];
            String leftLabel = ((ComparableModelElementNode)((Object)leftNode)).getName();
            leftElement = ((ComparableModelElementNode)((Object)leftNode)).getEObject();
            this.getCompareConfiguration().setLeftLabel(leftLabel);
            if (leftElement != null) {
                this.getCompareConfiguration().setLeftImage(DiagramPlugin.getImage(IconFactory.getDefault().getIconFor(leftElement)));
            }
        }
        if (this.input.getRight() != null) {
            Object rightNode = ((ComparableModelElementNode)this.input.getRight()).getChildren()[0];
            String rightLabel = ((ComparableModelElementNode)((Object)rightNode)).getName();
            EObject rightElement = ((ComparableModelElementNode)((Object)rightNode)).getEObject();
            this.getCompareConfiguration().setRightLabel(rightLabel);
            if (rightElement != null) {
                this.getCompareConfiguration().setRightImage(DiagramPlugin.getImage(IconFactory.getDefault().getIconFor(rightElement)));
                if (leftElement instanceof ModelType && rightElement instanceof ModelType) {
                    ModelElementOidRegistration.replaceDuplicateOids((ModelType)rightElement, (ModelType)leftElement);
                }
            }
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        if (listener instanceof CompareDialog) {
            this.listenerList.add((Object)listener);
        }
    }
}

