/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.compare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.compare.ComparableModelElementNode;
import org.eclipse.stardust.modeling.core.compare.ImportSelectionRegistration;
import org.eclipse.stardust.modeling.core.compare.ModelViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;

public class ModelDiffViewer
extends StructureDiffViewer {
    private static final String BUNDLE_NAME = "org.eclipse.stardust.modeling.core.compare.ModelElementMergeViewerResources";
    private IStructureComparator left;
    private IStructureComparator right;
    private Action fCopyRightToLeftAction;
    private Action fNextAction;
    private Action fPreviousAction;
    private Action fAdditionFilterAction;
    private Action fDeletionFilterAction;
    private Action fChangeFilterAction;
    private Action fAllFilterAction;
    private boolean notifyChangeListner;
    protected boolean allFilter = true;
    protected boolean additionFilter = false;
    protected boolean deletionFilter = false;
    protected boolean changeFilter = false;
    protected HashMap leftModelElementOidMap;
    protected HashMap rightModelElementOidMap;
    private ResourceBundle bundle = null;

    public ModelDiffViewer(Composite parent, CompareConfiguration configuration, IWizardContainer container) {
        super(parent, configuration);
        this.setContentProvider((IContentProvider)new ModelDiffViewerContentProvider());
        this.setSorter(new ModelViewerSorter());
        this.leftModelElementOidMap = new HashMap();
        this.rightModelElementOidMap = new HashMap();
    }

    public ModelDiffViewer(Composite parent, CompareConfiguration configuration) {
        this(parent, configuration, null);
    }

    public String getTitle() {
        return this.getBundle().getString("subtitle1");
    }

    protected void createToolItems(ToolBarManager toolbarManager) {
        toolbarManager.add((IContributionItem)new Separator("filter"));
        this.fAllFilterAction = new Action(){

            public void run() {
                ModelDiffViewer.this.allFilter = true;
                ModelDiffViewer.this.additionFilter = false;
                ModelDiffViewer.this.deletionFilter = false;
                ModelDiffViewer.this.changeFilter = false;
                ModelDiffViewer.this.refresh();
            }
        };
        this.fAllFilterAction.setText(this.getBundle().getString("action.allFilter.label"));
        this.fAllFilterAction.setToolTipText(this.getBundle().getString("action.allFilter.tooltip"));
        this.fAllFilterAction.setImageDescriptor(DiagramPlugin.getImageDescriptor("/icons/full/obj16/" + this.getBundle().getString("action.allFilter.image")));
        toolbarManager.appendToGroup("filter", (IAction)this.fAllFilterAction);
        this.fAdditionFilterAction = new Action(){

            public void run() {
                ModelDiffViewer.this.allFilter = false;
                ModelDiffViewer.this.additionFilter = true;
                ModelDiffViewer.this.deletionFilter = false;
                ModelDiffViewer.this.changeFilter = false;
                ModelDiffViewer.this.refresh();
            }
        };
        this.fAdditionFilterAction.setText(this.bundle.getString("action.AdditionFilter.label"));
        this.fAdditionFilterAction.setToolTipText(this.bundle.getString("action.AdditionFilter.tooltip"));
        this.fAdditionFilterAction.setImageDescriptor(DiagramPlugin.getImageDescriptor("/icons/full/obj16/" + this.getBundle().getString("action.AdditionFilter.image")));
        toolbarManager.appendToGroup("filter", (IAction)this.fAdditionFilterAction);
        this.fDeletionFilterAction = new Action(){

            public void run() {
                ModelDiffViewer.this.allFilter = false;
                ModelDiffViewer.this.additionFilter = false;
                ModelDiffViewer.this.deletionFilter = true;
                ModelDiffViewer.this.changeFilter = false;
                ModelDiffViewer.this.refresh();
            }
        };
        this.fDeletionFilterAction.setText(this.getBundle().getString("action.DeletionFilter.label"));
        this.fDeletionFilterAction.setToolTipText(this.getBundle().getString("action.DeletionFilter.tooltip"));
        this.fDeletionFilterAction.setImageDescriptor(DiagramPlugin.getImageDescriptor("/icons/full/obj16/" + this.getBundle().getString("action.DeletionFilter.image")));
        toolbarManager.appendToGroup("filter", (IAction)this.fDeletionFilterAction);
        this.fChangeFilterAction = new Action(){

            public void run() {
                ModelDiffViewer.this.allFilter = false;
                ModelDiffViewer.this.additionFilter = false;
                ModelDiffViewer.this.deletionFilter = false;
                ModelDiffViewer.this.changeFilter = true;
                ModelDiffViewer.this.refresh();
            }
        };
        this.fChangeFilterAction.setText(this.getBundle().getString("action.ChangeFilter.label"));
        this.fChangeFilterAction.setToolTipText(this.getBundle().getString("action.ChangeFilter.tooltip"));
        this.fChangeFilterAction.setImageDescriptor(DiagramPlugin.getImageDescriptor("/icons/full/obj16/" + this.getBundle().getString("action.ChangeFilter.image")));
        toolbarManager.appendToGroup("filter", (IAction)this.fChangeFilterAction);
        this.fCopyRightToLeftAction = new Action(){

            public void run() {
                ModelDiffViewer.this.getTree().setVisible(false);
                ModelDiffViewer.this.getTree().setRedraw(false);
                ModelDiffViewer.this.expandAll();
                ModelDiffViewer.this.copySelected(false);
                ModelDiffViewer.this.getTree().setRedraw(true);
                ModelDiffViewer.this.getTree().setVisible(true);
            }
        };
        Utilities.initAction((IAction)this.fCopyRightToLeftAction, (ResourceBundle)super.getBundle(), (String)"action.TakeRight.");
        toolbarManager.appendToGroup("merge", (IAction)this.fCopyRightToLeftAction);
        this.fNextAction = new Action(){

            public void run() {
                ModelDiffViewer.this.navigate(true);
            }
        };
        Utilities.initAction((IAction)this.fNextAction, (ResourceBundle)super.getBundle(), (String)"action.NextDiff.");
        toolbarManager.appendToGroup("navigation", (IAction)this.fNextAction);
        this.fPreviousAction = new Action(){

            public void run() {
                ModelDiffViewer.this.navigate(false);
            }
        };
        Utilities.initAction((IAction)this.fPreviousAction, (ResourceBundle)super.getBundle(), (String)"action.PrevDiff.");
        toolbarManager.appendToGroup("navigation", (IAction)this.fPreviousAction);
    }

    protected void preDiffHook(IStructureComparator ancestor, IStructureComparator left, IStructureComparator right) {
        this.left = left;
        this.right = right;
    }

    protected void copySelected(boolean leftToRight) {
        ComparableModelElementNode lNode = (ComparableModelElementNode)this.left;
        ComparableModelElementNode rNode = (ComparableModelElementNode)this.right;
        if (lNode != null && rNode != null && (lNode.getETypedElement() == null || rNode.getETypedElement() == null)) {
            ArrayList nodes = new ArrayList();
            ISelection selection = this.getSelection();
            if (selection instanceof StructuredSelection) {
                if (((StructuredSelection)selection).size() > 1) {
                    Iterator _iterator = ((StructuredSelection)selection).iterator();
                    while (_iterator.hasNext()) {
                        Item item = (Item)this.findItem(_iterator.next());
                        this.getItemsRecursive(item, nodes);
                    }
                } else if (((StructuredSelection)selection).size() == 1) {
                    DiffNode node = (DiffNode)((StructuredSelection)selection).getFirstElement();
                    this.getNodesRecursive(node, nodes);
                }
            }
            ImportSelectionRegistration.rigisterSelection(nodes, leftToRight);
            this.notifyChangeListner = false;
            int i = 0;
            while (i < nodes.size()) {
                DiffNode diffNode = (DiffNode)nodes.get(i);
                this.copyOne((ICompareInput)diffNode, leftToRight);
                if (i == nodes.size() - 1) {
                    this.notifyChangeListner = true;
                }
                if (this.getStructureCreator() != null) {
                    this.getStructureCreator().save(leftToRight ? this.right : this.left, (Object)(leftToRight ? this.right : this.left));
                }
                ++i;
            }
        } else {
            super.copySelected(leftToRight);
        }
    }

    private void getNodesRecursive(DiffNode node, List list) {
        if (node.hasChildren()) {
            IDiffElement[] elements = node.getChildren();
            int i = 0;
            while (i < elements.length) {
                DiffNode element = (DiffNode)elements[i];
                this.getNodesRecursive(element, list);
                ++i;
            }
        } else {
            list.add(node);
        }
    }

    private List getItemsRecursive(Item item, List list) {
        Item[] items = this.getItems(item);
        if (items.length > 0) {
            int i = 0;
            while (i < items.length) {
                list = this.getItemsRecursive(items[i], list);
                ++i;
            }
        } else {
            Object data = item.getData();
            if (data != null) {
                DiffNode node = (DiffNode)item.getData();
                this.getNodesRecursive(node, list);
            }
        }
        return list;
    }

    protected void contentChanged(IContentChangeNotifier changed) {
        if (this.notifyChangeListner) {
            super.contentChanged(changed);
        }
    }

    protected ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        }
        return this.bundle;
    }

    class ModelDiffViewerContentProvider
    implements ITreeContentProvider {
        ModelDiffViewerContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public void dispose() {
            this.inputChanged((Viewer)ModelDiffViewer.this, ModelDiffViewer.this.getInput(), null);
        }

        public Object getParent(Object element) {
            if (element instanceof IDiffElement) {
                return ((IDiffElement)element).getParent();
            }
            return null;
        }

        public final boolean hasChildren(Object element) {
            if (element instanceof IDiffContainer) {
                return this.getChildren(element).length > 0;
            }
            return false;
        }

        public final Object[] getChildren(Object element) {
            if (element instanceof IDiffContainer) {
                ArrayList<IDiffElement> filteredChildren = new ArrayList<IDiffElement>();
                IDiffElement[] children = ((IDiffContainer)element).getChildren();
                int i = 0;
                while (i < children.length) {
                    IDiffElement dElement = children[i];
                    if (dElement instanceof DiffNode) {
                        ComparableModelElementNode rightNode;
                        ComparableModelElementNode leftNode;
                        boolean isEmptyNode = false;
                        IDiffElement[] diffNodeChildren = ((DiffNode)dElement).getChildren();
                        if (diffNodeChildren.length == 1) {
                            leftNode = (ComparableModelElementNode)((DiffNode)diffNodeChildren[0]).getLeft();
                            rightNode = (ComparableModelElementNode)((DiffNode)diffNodeChildren[0]).getRight();
                            if (leftNode != null && StringUtils.isEmpty((String)leftNode.getName()) || rightNode != null && StringUtils.isEmpty((String)rightNode.getName())) {
                                isEmptyNode = true;
                            }
                        } else {
                            leftNode = (ComparableModelElementNode)((DiffNode)dElement).getLeft();
                            rightNode = (ComparableModelElementNode)((DiffNode)dElement).getRight();
                            if (leftNode != null && StringUtils.isEmpty((String)leftNode.getName()) || rightNode != null && StringUtils.isEmpty((String)rightNode.getName())) {
                                isEmptyNode = true;
                            }
                        }
                        if (!isEmptyNode) {
                            int kind = dElement.getKind();
                            if (ModelDiffViewer.this.additionFilter) {
                                if (kind == 1 || kind == 3 && diffNodeChildren.length > 0) {
                                    filteredChildren.add(dElement);
                                }
                            } else if (ModelDiffViewer.this.deletionFilter) {
                                if (kind == 2 || kind == 3 && diffNodeChildren.length > 0) {
                                    filteredChildren.add(dElement);
                                }
                            } else if (ModelDiffViewer.this.changeFilter) {
                                if (kind == 3) {
                                    filteredChildren.add(dElement);
                                }
                            } else if (ModelDiffViewer.this.allFilter) {
                                filteredChildren.add(dElement);
                            }
                        }
                    }
                    ++i;
                }
                return filteredChildren.toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }
    }
}

