/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.AbstractGraphicalEditorPage;
import org.eclipse.stardust.modeling.core.editors.AbstractMultiPageGraphicalEditor;
import org.eclipse.stardust.modeling.core.editors.DelegatingActionRegistry;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditorContextMenuProvider;
import org.eclipse.stardust.modeling.core.editors.dnd.ModelElementTransferDragSourceListener;
import org.eclipse.stardust.modeling.core.editors.parts.tree.OutlineTreeEditor;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;

public abstract class AbstractMultiPageGraphicalEditorOutlinePage
extends ContentOutlinePage
implements IAdaptable {
    protected static final int ID_OUTLINE = 0;
    protected static final int ID_OVERVIEW = 1;
    private final WorkflowModelEditor editor;
    protected PageBook pageBook;
    protected Control outline;
    protected LightweightSystem overviewLws;
    protected Canvas overview;
    protected Thumbnail thumbnail;
    protected IAction showOutlineAction;
    protected IAction showOverviewAction;
    protected DisposeListener disposeListener;
    private ActionRegistry actionRegistry;
    private ISelectionListener selectionListener;
    private OutlineTreeEditor outlineTreeEditor;

    AbstractMultiPageGraphicalEditorOutlinePage(WorkflowModelEditor editor, EditPartViewer viewer) {
        super(viewer);
        this.editor = editor;
    }

    protected abstract EditPartFactory createOutlineEditPartFactory();

    protected abstract void contributeToolBarActions(IToolBarManager var1);

    public void setOutlineContents(Object contents) {
        Tree tree;
        if (this.getViewer().getEditPartFactory() != null) {
            this.getViewer().setContents(contents);
        }
        if ((tree = (Tree)this.getViewer().getControl()) != null && tree.getItemCount() > 0) {
            tree.getItem(0).setExpanded(true);
        }
    }

    public void editorPageChanged() {
        this.initializeOverview();
    }

    public void init(IPageSite pageSite) {
        pageSite.setSelectionProvider((ISelectionProvider)this.getViewer());
        super.init(pageSite);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.getSelectionListener());
        this.createActions();
        ActionRegistry registry = this.getActionRegistry();
        IActionBars bars = pageSite.getActionBars();
        String id = ActionFactory.UNDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.REDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.DELETE.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.PRINT.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.COPY.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.PASTE.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.CUT.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        bars.updateActionBars();
    }

    protected abstract void createActions();

    protected abstract boolean canDelete(ISelection var1);

    protected ISelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                }
            };
        }
        return this.selectionListener;
    }

    public void createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.outline = this.getViewer().createControl((Composite)this.pageBook);
        this.overview = new Canvas((Composite)this.pageBook, 0);
        this.pageBook.showPage(this.outline);
        this.configureOutlineViewer();
        this.hookOutlineViewer();
        this.initializeOutlineViewer();
        this.addOutlineTreeEditor(parent);
    }

    private void addOutlineTreeEditor(Composite parent) {
        Tree tree = (Tree)this.getViewer().getControl();
        this.outlineTreeEditor = new OutlineTreeEditor(tree, this.getViewer());
    }

    public OutlineTreeEditor getOutlineTreeEditor() {
        return this.outlineTreeEditor;
    }

    public Control getControl() {
        return this.pageBook;
    }

    public void dispose() {
        this.editor.getSelectionSynchronizer().removeViewer(this.getViewer());
        if (this.disposeListener != null && this.getCanvas() != null && !this.getCanvas().isDisposed()) {
            this.getCanvas().removeDisposeListener(this.disposeListener);
        }
        this.editor.resetOutlinePage();
        super.dispose();
    }

    public Object getAdapter(Class type) {
        Object adapter = type == ZoomManager.class && this.editor.getCurrentPage() instanceof AbstractGraphicalEditorPage ? ((AbstractGraphicalEditorPage)this.editor.getCurrentPage()).getGraphicalViewer().getProperty(ZoomManager.class.toString()) : null;
        return adapter;
    }

    protected void showPage(int id) {
        if (id == 0) {
            this.showOutlineAction.setChecked(true);
            this.showOverviewAction.setChecked(false);
            this.pageBook.showPage(this.outline);
            if (this.thumbnail != null) {
                this.thumbnail.setVisible(false);
            }
        } else if (id == 1) {
            if (this.thumbnail == null) {
                this.initializeOverview();
            } else {
                this.updateOverview();
            }
            this.showOutlineAction.setChecked(false);
            this.showOverviewAction.setChecked(true);
            this.pageBook.showPage((Control)this.overview);
            if (this.thumbnail != null) {
                this.thumbnail.setVisible(true);
            }
        }
    }

    protected void initializeOutlineViewer() {
        EObject model = (EObject)this.editor.getModel();
        if (model != null && this.editor.checkUpgradeModel()) {
            this.setOutlineContents(model.eContainer());
        } else {
            this.setOutlineContents(null);
        }
    }

    protected void hookOutlineViewer() {
        this.editor.getSelectionSynchronizer().addViewer(this.getViewer());
    }

    protected void initializeOverview() {
        if (this.overviewLws == null) {
            this.overviewLws = new LightweightSystem(this.overview);
        }
        this.updateOverview();
    }

    protected void updateOverview() {
        RootEditPart rep;
        RootEditPart rootEditPart = rep = this.editor.getCurrentPage() instanceof AbstractGraphicalEditorPage ? ((AbstractGraphicalEditorPage)this.editor.getCurrentPage()).getGraphicalViewer().getRootEditPart() : null;
        if (rep instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
            ScrollableThumbnail thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
            thumbnail.setBorder((Border)new MarginBorder(3));
            thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
            this.overviewLws.setContents((IFigure)thumbnail);
            this.disposeListener = new DisposeListener((Thumbnail)thumbnail){
                private final /* synthetic */ Thumbnail val$thumbnail;
                {
                    this.val$thumbnail = thumbnail;
                }

                public void widgetDisposed(DisposeEvent e) {
                    this.val$thumbnail.deactivate();
                    if (AbstractMultiPageGraphicalEditorOutlinePage.this.thumbnail == this.val$thumbnail) {
                        AbstractMultiPageGraphicalEditorOutlinePage.this.thumbnail = null;
                    }
                }
            };
            this.getCanvas().addDisposeListener(this.disposeListener);
            this.thumbnail = thumbnail;
        } else {
            this.overviewLws.setContents((IFigure)new Figure());
        }
    }

    protected FigureCanvas getCanvas() {
        GraphicalViewer graphicalViewer;
        AbstractGraphicalEditorPage currentPage;
        FigureCanvas canvas = null;
        AbstractGraphicalEditorPage abstractGraphicalEditorPage = currentPage = this.editor.getCurrentPage() instanceof AbstractGraphicalEditorPage ? (AbstractGraphicalEditorPage)this.editor.getCurrentPage() : null;
        if (currentPage != null && (graphicalViewer = currentPage.getGraphicalViewer()) != null) {
            return (FigureCanvas)graphicalViewer.getControl();
        }
        return canvas;
    }

    protected void configureOutlineViewer() {
        this.getViewer().setEditDomain(this.editor.getEditDomain());
        this.getViewer().setEditPartFactory(this.createOutlineEditPartFactory());
        this.getViewer().setKeyHandler(this.editor.getSharedKeyHandler());
        this.getViewer().addDragSourceListener((TransferDragSourceListener)new ModelElementTransferDragSourceListener(this.getViewer()));
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        this.showOutlineAction = new Action(){

            public void run() {
                AbstractMultiPageGraphicalEditorOutlinePage.this.showPage(0);
            }
        };
        this.showOutlineAction.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/outline.gif"));
        this.showOutlineAction.setToolTipText(Diagram_Messages.ToolTip_Outline);
        tbm.add(this.showOutlineAction);
        this.showOverviewAction = new Action(){

            public void run() {
                AbstractMultiPageGraphicalEditorOutlinePage.this.showPage(1);
            }
        };
        this.showOverviewAction.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/overview.gif"));
        this.showOverviewAction.setToolTipText(Diagram_Messages.ToolTip_Graphical);
        tbm.add(this.showOverviewAction);
        this.contributeToolBarActions(tbm);
        WorkflowModelEditorContextMenuProvider provider = new WorkflowModelEditorContextMenuProvider(this.getViewer(), this.getActionRegistry(), this.editor);
        this.getViewer().setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.eclipse.stardust.modeling.core.outline.contextmenu", (MenuManager)provider, (ISelectionProvider)this.getViewer());
        this.outline.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                EditPart selection = AbstractMultiPageGraphicalEditorOutlinePage.this.getSelectedPart();
                if (selection != null) {
                    IAction action = null;
                    Object model = selection.getModel();
                    action = model instanceof DiagramType ? AbstractMultiPageGraphicalEditorOutlinePage.this.getActionRegistry().getAction((Object)"org.eclipse.stardust.modeling.core.open") : (model instanceof Connection ? AbstractMultiPageGraphicalEditorOutlinePage.this.getActionRegistry().getAction((Object)"org.eclipse.stardust.modeling.repository.common.select") : AbstractMultiPageGraphicalEditorOutlinePage.this.getActionRegistry().getAction((Object)ActionFactory.PROPERTIES.getId()));
                    if (action.isEnabled()) {
                        action.run();
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
                IWorkbenchPage activePage;
                IAction action;
                EditPart selection = AbstractMultiPageGraphicalEditorOutlinePage.this.getSelectedPart();
                IAction iAction = action = selection != null && selection.getModel() instanceof DiagramType ? AbstractMultiPageGraphicalEditorOutlinePage.this.getActionRegistry().getAction((Object)"org.eclipse.stardust.modeling.core.open") : null;
                if (action != null && action.isEnabled()) {
                    action.run();
                }
                if ((activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).getActivePart() instanceof ISearchResultViewPart) {
                    activePage.activate((IWorkbenchPart)activePage.findView("org.eclipse.ui.views.ContentOutline"));
                }
            }
        });
        this.showPage(0);
    }

    private EditPart getSelectedPart() {
        ISelection selection = this.getSelection();
        return selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 ? (EditPart)((IStructuredSelection)selection).getFirstElement() : null;
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new DelegatingActionRegistry(this.getEditor().getActionRegistry());
        }
        return this.actionRegistry;
    }

    public AbstractMultiPageGraphicalEditor getEditor() {
        return this.editor;
    }
}

