/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RelativeLocator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.modeling.core.decoration.DecorationUtils;
import org.eclipse.stardust.modeling.core.decoration.IDecoratablePart;
import org.eclipse.stardust.modeling.core.decoration.IDecorationProvider;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractSwimlaneFigure;
import org.eclipse.stardust.modeling.core.editors.figures.EditableFigure;
import org.eclipse.stardust.modeling.core.editors.figures.IFeedbackFigureFactory;
import org.eclipse.stardust.modeling.core.editors.figures.IGraphicalObjectFigure;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.IHighliteableGraphicalObject;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.MoveNodeSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.DragEditPartsTrackerWithExplicitBendpoints;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.NodeSymbolComponentEditPolicy;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.NodeSymbolGraphicalNodeEditPolicy;
import org.eclipse.stardust.modeling.core.editors.parts.properties.DefaultPropSheetCmdFactory;
import org.eclipse.stardust.modeling.core.editors.tools.SnapCenterToGrid;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.SnapGridUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractNodeSymbolEditPart
extends AbstractNodeEditPart
implements IHighliteableGraphicalObject,
IDecoratablePart,
IFeedbackFigureFactory {
    private boolean showingConnections = true;
    private Color highliteBorderColor;
    private Color highliteFillColor;
    private Map decorations = new HashMap();
    private ConnectionAnchor anchor;
    private DirectEditManager manager;
    protected HashSet decorators = new HashSet();

    public AbstractNodeSymbolEditPart(WorkflowModelEditor editor, INodeSymbol model) {
        super(editor, (EObject)model);
    }

    protected EStructuralFeature getDirectEditFeature() {
        return null;
    }

    public boolean isShowingConnections() {
        return this.showingConnections;
    }

    public void setShowingConnections(boolean showingConnections) {
        this.showingConnections = showingConnections;
        if (this.getParent() != null) {
            this.refreshSourceConnections();
            this.refreshTargetConnections();
        }
    }

    @Override
    public void setHighliteBorderColor(Color color) {
        this.highliteBorderColor = color;
        this.refreshVisuals();
    }

    @Override
    public void resetHighliteBorderColor() {
        this.setHighliteBorderColor(null);
    }

    @Override
    public void setHighliteFillColor(Color color) {
        this.highliteFillColor = color;
        this.refreshVisuals();
    }

    @Override
    public void resetHighliteFillColor() {
        this.setHighliteFillColor(null);
    }

    @Override
    public void applyDecoration(IDecorationProvider decoration) {
        IFigure decorationFigure = (IFigure)this.decorations.get(decoration.getId());
        if (decorationFigure != null) {
            if (decorationFigure.getParent() != null) {
                decorationFigure.getParent().remove(decorationFigure);
            }
            this.decorations.remove(decoration.getId());
        }
        if ((decorationFigure = decoration.createDecoration(this.getCastedModel())) != null) {
            this.decorations.put(decoration.getId(), decorationFigure);
            LayerManager manager = (LayerManager)this.getViewer().getEditPartRegistry().get(LayerManager.ID);
            IFigure decorationLayer = manager.getLayer((Object)"BPMN Decoration Layer");
            if (decorationLayer != null && this.getFigure() != null) {
                Locator locator = decoration.createDecorationLocator(this.getCastedModel(), this.getFigure(), decorationFigure);
                if (locator == null) {
                    locator = new RelativeLocator(this.getFigure(), 4);
                }
                decorationLayer.add(decorationFigure, (Object)locator);
                final IFigure theDecorationFigure = decorationFigure;
                this.getFigure().addFigureListener(new FigureListener(){

                    public void figureMoved(IFigure source) {
                        theDecorationFigure.revalidate();
                    }
                });
            }
        }
        DecorationUtils.applyDecoration(decoration, this.getChildren());
        DecorationUtils.applyDecoration(decoration, this.getSourceConnections());
        this.decorators.add(decoration);
    }

    @Override
    public void removeDecoration(IDecorationProvider decoration) {
        DecorationUtils.removeDecoration(decoration, this.getChildren());
        DecorationUtils.removeDecoration(decoration, this.getSourceConnections());
        IFigure decorationFigure = (IFigure)this.decorations.get(decoration.getId());
        if (decorationFigure != null) {
            if (decorationFigure.getParent() != null) {
                decorationFigure.getParent().remove(decorationFigure);
            }
            this.decorations.remove(decoration.getId());
            decoration.decorationRemoved(this.getCastedModel(), decorationFigure);
        }
        this.decorators.remove(decoration);
    }

    @Override
    public IFigure createFeedbackFigure() {
        IFigure figure = this.createFigure();
        this.refreshFigure(figure);
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new NodeSymbolComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new NodeSymbolGraphicalNodeEditPolicy(this.getEditor()));
        if (this.getDirectEditFeature() != null) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy(){

                protected Command getDirectEditCommand(DirectEditRequest request) {
                    MoveNodeSymbolCommand move = new MoveNodeSymbolCommand();
                    move.setPart(AbstractNodeSymbolEditPart.this.getCastedModel());
                    move.setBounds(AbstractNodeSymbolEditPart.this.getFigure().getBounds());
                    return DefaultPropSheetCmdFactory.INSTANCE.getSetCommand((EditPart)AbstractNodeSymbolEditPart.this, (EObject)AbstractNodeSymbolEditPart.this.getModel(), AbstractNodeSymbolEditPart.this.getDirectEditFeature(), request.getCellEditor().getValue().toString()).chain((Command)move);
                }

                protected void showCurrentEditValue(DirectEditRequest request) {
                    String value = (String)request.getCellEditor().getValue();
                    ((EditableFigure)AbstractNodeSymbolEditPart.this.getFigure()).setText(value);
                }
            });
        }
    }

    public void performRequest(Request req) {
        if (req.getType() == "direct edit" && this.getDirectEditFeature() != null && this.canDirectEdit(req)) {
            this.performDirectEdit();
            return;
        }
        super.performRequest(req);
    }

    private boolean canDirectEdit(Request req) {
        if (req instanceof DirectEditRequest) {
            return this.getEditingBounds().contains(((DirectEditRequest)req).getLocation());
        }
        return true;
    }

    private Rectangle getEditingBounds() {
        IFigure figure = this.getFigure();
        Rectangle bounds = new Rectangle(figure instanceof EditableFigure ? ((EditableFigure)this.getFigure()).getEditingBounds() : figure.getBounds());
        while (figure.getParent() instanceof AbstractSwimlaneFigure) {
            figure.getParent().translateToParent((Translatable)bounds);
            figure = figure.getParent();
        }
        ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)this.getRoot();
        Point viewLocation = root.getZoomManager().getViewport().getViewLocation();
        bounds.scale(root.getZoomManager().getZoom());
        bounds.translate(-viewLocation.x, -viewLocation.y);
        return bounds;
    }

    private double getZoom() {
        ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)this.getRoot();
        return root.getZoomManager().getZoom();
    }

    private void performDirectEdit() {
        if (this.manager == null) {
            CellEditorLocator locator = new CellEditorLocator(){

                public void relocate(CellEditor editor) {
                    Rectangle bounds = AbstractNodeSymbolEditPart.this.getEditingBounds();
                    org.eclipse.swt.graphics.Rectangle trim = ((Text)editor.getControl()).computeTrim(bounds.x, bounds.y, bounds.width, bounds.height);
                    editor.getControl().setBounds(trim.x, trim.y, trim.width, trim.height);
                }
            };
            this.manager = new DirectEditManager((GraphicalEditPart)this, TextCellEditor.class, locator){
                private boolean snapToGrid;
                private Rectangle symbolRect;
                private Dimension oldSize;
                private Point oldPos;
                private Font font;
                private Font defaultFont;
                {
                    this.snapToGrid = false;
                }

                protected CellEditor createCellEditorOn(Composite composite) {
                    EditableFigure figure = (EditableFigure)AbstractNodeSymbolEditPart.this.getFigure();
                    TextCellEditor editor = new TextCellEditor(composite, figure.getEditingStyle());
                    this.defaultFont = AbstractNodeSymbolEditPart.this.getFigure().getFont();
                    editor.getControl().addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            if (font != null) {
                                font.dispose();
                            }
                        }
                    });
                    this.symbolRect = GenericUtils.getSymbolRectangle((EditPart)this.getEditPart());
                    this.oldSize = this.symbolRect.getSize();
                    this.oldPos = this.symbolRect.getLocation();
                    if (SnapGridUtils.getSnapToHelper((AbstractGraphicalEditPart)this.getEditPart()) != null) {
                        this.snapToGrid = true;
                    }
                    return editor;
                }

                protected void initCellEditor() {
                    EditableFigure figure = (EditableFigure)AbstractNodeSymbolEditPart.this.getFigure();
                    this.getCellEditor().setValue((Object)figure.getText());
                    FontData data = this.defaultFont.getFontData()[0];
                    double zoom = AbstractNodeSymbolEditPart.this.getZoom();
                    if (zoom == 1.0) {
                        this.getCellEditor().getControl().setFont(this.defaultFont);
                    } else {
                        this.font = new Font(null, data.getName(), (int)((double)data.getHeight() * AbstractNodeSymbolEditPart.this.getZoom()), data.getStyle());
                        this.getCellEditor().getControl().setFont(this.font);
                    }
                    ((Text)this.getCellEditor().getControl()).selectAll();
                }

                public void showFeedback() {
                    Dimension size;
                    int deltaX;
                    super.showFeedback();
                    INodeSymbol symbol = AbstractNodeSymbolEditPart.this.getCastedModel();
                    Rectangle figureBounds = this.symbolRect.getCopy();
                    Dimension after = AbstractNodeSymbolEditPart.this.getFigure().getPreferredSize().getCopy();
                    if (after.width < figureBounds.width) {
                        after.width = figureBounds.width;
                    }
                    if ((deltaX = (after.width - this.oldSize.width) / 2) != 0) {
                        figureBounds.x = this.oldPos.x - deltaX;
                        figureBounds.width = after.width;
                    }
                    if (this.snapToGrid) {
                        size = SnapGridUtils.getSnapDimension(new Dimension(figureBounds.width, figureBounds.height), AbstractNodeSymbolEditPart.this, 2, false);
                        double difference = new Double(size.width - this.oldSize.width);
                        int widthDifference = (int)Math.round(difference / (double)SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE);
                        if (widthDifference != 0) {
                            widthDifference /= 2;
                            if (deltaX > 0) {
                                figureBounds.x = this.oldPos.x - SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE * widthDifference;
                            }
                        }
                    } else {
                        size = new Dimension(figureBounds.width, figureBounds.height);
                    }
                    size.height = symbol.getHeight() != -1 ? symbol.getHeight() : figureBounds.height;
                    Point newLocation = new Point(figureBounds.x, figureBounds.y);
                    Rectangle newBounds = new Rectangle(newLocation, size);
                    Point setLocation = SnapGridUtils.getSnapLocation(AbstractNodeSymbolEditPart.this, AbstractNodeSymbolEditPart.this, new PrecisionRectangle(newBounds), null, null);
                    if (deltaX != 0) {
                        AbstractNodeSymbolEditPart.this.getFigure().setBounds(new Rectangle(setLocation, size));
                        if (AbstractNodeSymbolEditPart.this.getParent() != null) {
                            ((GraphicalEditPart)AbstractNodeSymbolEditPart.this.getParent()).setLayoutConstraint((EditPart)AbstractNodeSymbolEditPart.this, AbstractNodeSymbolEditPart.this.getFigure(), (Object)new Rectangle(setLocation, size));
                        }
                    }
                }

                protected void eraseFeedback() {
                    super.eraseFeedback();
                }
            };
        }
        this.manager.show();
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTrackerWithExplicitBendpoints((EditPart)this){

            protected boolean handleButtonDown(int button) {
                if (button == 1 && this.getSourceEditPart().getSelected() != 0) {
                    DirectEditRequest request = new DirectEditRequest();
                    request.setLocation(this.getLocation());
                    AbstractNodeSymbolEditPart.this.performRequest((Request)request);
                }
                return super.handleButtonDown(button);
            }
        };
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    protected void refreshFigure(IFigure figure) {
        if (figure instanceof IGraphicalObjectFigure) {
            IGraphicalObjectFigure goFigure = (IGraphicalObjectFigure)figure;
            goFigure.setBorderColor(this.highliteBorderColor);
            goFigure.setFillColor(this.highliteFillColor);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        Point loc = new Point((double)this.getCastedModel().getXPos(), (double)this.getCastedModel().getYPos());
        Dimension dim = new Dimension(-1, -1);
        if (this.getCastedModel().isSetWidth()) {
            dim.width = this.getCastedModel().getWidth();
        }
        if (this.getCastedModel().isSetHeight()) {
            dim.height = this.getCastedModel().getHeight();
        }
        Rectangle r = new Rectangle(loc, dim);
        if (this.getParent() != null) {
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
        }
        this.refreshFigure(this.getFigure());
    }

    @Override
    public void handleNotification(Notification notification) {
        switch (notification.getFeatureID(INodeSymbol.class)) {
            case 5: {
                this.refreshSourceConnections();
                break;
            }
            case 4: {
                this.refreshTargetConnections();
            }
        }
        super.handleNotification(notification);
    }

    @Override
    public Object getAdapter(Class key) {
        if (INodeSymbol.class == key || IModelElement.class == key) {
            return this.getCastedModel();
        }
        return super.getAdapter(key);
    }

    protected ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            this.anchor = new ChopboxAnchor(this.getFigure());
        }
        return this.anchor;
    }

    private INodeSymbol getCastedModel() {
        return (INodeSymbol)this.getModel();
    }

    protected List getModelSourceConnections() {
        List result = this.isShowingConnections() ? this.getCastedModel().getReferingFromConnections() : Collections.EMPTY_LIST;
        return result;
    }

    protected List getModelTargetConnections() {
        List result = this.isShowingConnections() ? this.getCastedModel().getReferingToConnections() : Collections.EMPTY_LIST;
        return result;
    }
}

