/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CommandUtils;

public class MoveLaneCommand
extends Command {
    private boolean changingPools;
    private PoolSymbol pool;
    private ISwimlaneSymbol successor;
    private ISwimlaneSymbol parentLane;
    private ISwimlaneSymbol successorSibling;
    private LaneSymbol target;
    private CommandUtils.ContainmentState poolBackup;
    private CommandUtils.ContainmentState parentBackup;

    public void setTarget(LaneSymbol target) {
        this.target = target;
    }

    public void setPool(PoolSymbol pool) {
        this.setPool(pool, null);
    }

    public void setPool(PoolSymbol pool, LaneSymbol successor) {
        this.changingPools = true;
        this.pool = pool;
        this.successor = successor;
    }

    public void setParentLane(ISwimlaneSymbol parentLane) {
        this.setParentLane(parentLane, null);
    }

    public void setParentLane(ISwimlaneSymbol parentLane, ISwimlaneSymbol successor) {
        this.parentLane = parentLane;
        this.successorSibling = successor;
    }

    public void setContainer(ISwimlaneSymbol container) {
        if (container instanceof PoolSymbol) {
            this.setPool((PoolSymbol)container);
        } else if (container instanceof LaneSymbol) {
            this.setPool(((LaneSymbol)container).getParentPool());
        } else {
            throw new IllegalArgumentException(String.valueOf(Diagram_Messages.EX_FailedObtainingParentToll) + container);
        }
        this.setParentLane(container);
    }

    public void execute() {
        if (this.target.getParentLane() != null) {
            this.parentBackup = CommandUtils.backupContainment(this.target, (List)this.target.getParentLane().getChildLanes());
        }
        if (this.changingPools && this.target.getParentPool() != null) {
            this.poolBackup = CommandUtils.backupContainment(this.target, (List)this.target.getParentPool().getLanes());
        }
        this.redo();
    }

    public void redo() {
        ISwimlaneSymbol parent;
        CommandUtils.undoContainment(this.parentBackup);
        if (this.changingPools) {
            CommandUtils.undoContainment(this.poolBackup);
            if (this.pool != null) {
                int position;
                EList lanes = this.pool.getLanes();
                int n = position = this.successor != null ? lanes.indexOf(this.successor) : -1;
                if (-1 != position) {
                    lanes.add(position, this.target);
                } else {
                    lanes.add(this.target);
                }
            }
        }
        if ((parent = this.parentLane) == null) {
            parent = this.pool;
        }
        if (parent != null) {
            int position;
            EList lanes = parent.getChildLanes();
            int n = position = this.successorSibling != null ? lanes.indexOf(this.successorSibling) : -1;
            if (-1 != position) {
                lanes.add(position, this.target);
            } else {
                lanes.add(this.target);
            }
        }
    }

    public void undo() {
        ISwimlaneSymbol parent = this.parentLane;
        if (parent == null) {
            parent = this.pool;
        }
        if (parent != null) {
            parent.getChildLanes().remove((Object)this.target);
        }
        if (this.changingPools) {
            if (this.pool != null) {
                this.pool.getLanes().remove((Object)this.target);
            }
            CommandUtils.redoContainment(this.poolBackup);
        }
        CommandUtils.redoContainment(this.parentBackup);
    }
}

