/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.util.IObjectReference;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ReloadConnectionsAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegateCommand;
import org.eclipse.stardust.modeling.core.editors.parts.properties.ActivityCommandFactory;
import org.eclipse.stardust.modeling.core.editors.ui.IdentifiableLabelProvider;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.ReferencedModelSorter;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class ActivityApplicationPropertyPage
extends AbstractModelElementPropertyPage {
    private LabeledViewer labeledWidget;
    private ApplicationType originalApplication;
    private Button groupingCheckbox;
    private List<ApplicationType> applications;
    private ReferencedModelSorter refSorter = new ReferencedModelSorter();
    private IdentifiableLabelProvider labelProvider;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        ActivityType activity = (ActivityType)element;
        ModelType model = (ModelType)activity.eContainer().eContainer();
        TableViewer viewer = (TableViewer)this.labeledWidget.getViewer();
        viewer.getTable().removeAll();
        this.applications = this.collectApplications(model);
        this.labelProvider.setModel(model);
        viewer.add(this.applications.toArray());
        viewer.setSorter((ViewerSorter)this.refSorter);
        WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        wBndMgr.bind(this.labeledWidget, (EObject)element, (EStructuralFeature)PKG_CWM.getActivityType_Application());
        wBndMgr.getModelBindingManager().updateWidgets((Object)element);
        this.originalApplication = activity.getApplication();
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        DelegateCommand reloadCommand;
        ActivityType activity = (ActivityType)element;
        ApplicationType newApplication = activity.getApplication();
        CompoundCommand command = new CompoundCommand();
        ActivityCommandFactory.addSetApplicationCommands(command, activity, newApplication, this.originalApplication, true);
        if (this.originalApplication == null && newApplication != null && this.setReloadConnectionsCommand(reloadCommand = new DelegateCommand(), newApplication, this.getEditor())) {
            command.add((Command)reloadCommand);
        }
        command.execute();
    }

    private boolean setReloadConnectionsCommand(DelegateCommand compound, final ApplicationType application, final WorkflowModelEditor editor) {
        ReloadConnectionsAction reload = new ReloadConnectionsAction(editor){
            private List<EditPart> editParts;
            {
                super($anonymous0);
                this.editParts = null;
            }

            protected List<EditPart> getSelectedObjects() {
                if (this.editParts == null) {
                    this.editParts = CollectionUtils.newList();
                    for (INodeSymbol symbol : application.getSymbols()) {
                        this.editParts.add(editor.findEditPart(symbol));
                    }
                }
                return this.editParts;
            }
        };
        CompoundCommand command = reload.createReloadCommand();
        if (command != null && !command.isEmpty()) {
            compound.setDelegate((Command)command);
            return true;
        }
        return false;
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        LabelWithStatus label = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.LB_Applications);
        Table table = new Table(composite, 2048);
        table.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        TableViewer tableViewer = new TableViewer(table);
        this.labelProvider = new IdentifiableLabelProvider(this.getEditor());
        tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tableViewer.setSorter((ViewerSorter)this.refSorter);
        this.labeledWidget = new LabeledViewer((StructuredViewer)tableViewer, label);
        this.groupingCheckbox = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.LB_GroupModelElements);
        this.groupingCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ActivityApplicationPropertyPage.this.refSorter.setGrouped(ActivityApplicationPropertyPage.this.groupingCheckbox.getSelection());
                ActivityApplicationPropertyPage.this.labelProvider.setShowGroupInfo(ActivityApplicationPropertyPage.this.groupingCheckbox.getSelection());
                TableViewer viewer = (TableViewer)ActivityApplicationPropertyPage.this.labeledWidget.getViewer();
                ISelection selection = viewer.getSelection();
                viewer.getTable().removeAll();
                viewer.add(ActivityApplicationPropertyPage.this.applications.toArray());
                viewer.setSelection(selection);
            }
        });
        return composite;
    }

    private List<ApplicationType> collectApplications(ModelType model) {
        ExternalPackages packages;
        List applicationsList = CollectionUtils.newList();
        EList applicationTypes = model.getApplication();
        if (applicationTypes != null) {
            applicationsList.addAll(applicationTypes);
        }
        if ((packages = model.getExternalPackages()) != null) {
            for (ExternalPackage pkg : packages.getExternalPackage()) {
                EList externalDeclarations;
                IConnectionManager manager;
                String uri = ExtendedAttributeUtil.getAttributeValue((Extensible)pkg, (String)"carnot:connection:uri");
                if (StringUtils.isEmpty((String)uri) || (manager = model.getConnectionManager()) == null) continue;
                EObject externalModel = manager.find(uri);
                if (externalModel instanceof IObjectReference) {
                    externalModel = ((IObjectReference)externalModel).getEObject();
                }
                if (!(externalModel instanceof ModelType) || (externalDeclarations = ((ModelType)externalModel).getApplication()) == null) continue;
                for (ApplicationType application : externalDeclarations) {
                    AttributeType visibility = AttributeUtil.getAttribute((IExtensibleElement)application, (String)"carnot:engine:visibility");
                    if (visibility != null && !visibility.getValue().equalsIgnoreCase("Public")) continue;
                    applicationsList.add(application);
                }
            }
        }
        return applicationsList;
    }
}

