/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.dataTypes.plainXML;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.spi.dataTypes.plainXML.SchemaUtils;
import org.eclipse.stardust.modeling.validation.util.ProjectClassLoader;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class PlainXMLPropertyPage
extends AbstractModelElementPropertyPage
implements IDataPropertyPage {
    private static final String[][] SCHEMA_TYPES = new String[][]{{"none", Diagram_Messages.MSG_DIA_NONE}, {"xsd", Diagram_Messages.LBL_XSD}, {"wsdl", Diagram_Messages.LBL_WSDL_XSD_ENVELOPE}, {"dtd", Diagram_Messages.LBL_DTD}};
    private Combo schemaTypeCombo;
    private Text typeDeclarationURLText;
    private Text elementNameText;
    private Button elementNameButton;
    private Button volatileCheckBox;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        DataType dataType = (DataType)element;
        this.volatileCheckBox.setSelection(AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:volatile"));
        this.schemaTypeCombo.select(0);
        String schemaType = AttributeUtil.getAttributeValue((IExtensibleElement)dataType, (String)"carnot:engine:schemaType");
        int i = 0;
        while (i < SCHEMA_TYPES.length) {
            if (SCHEMA_TYPES[i][0].equals(schemaType)) {
                this.schemaTypeCombo.select(i);
            }
            ++i;
        }
        this.validationChanged();
        String schemaUrl = AttributeUtil.getAttributeValue((IExtensibleElement)dataType, (String)"carnot:engine:schemaURL");
        this.typeDeclarationURLText.setText(schemaUrl == null ? "" : schemaUrl);
        String elementName = AttributeUtil.getAttributeValue((IExtensibleElement)dataType, (String)"carnot:engine:typeId");
        this.elementNameText.setText(elementName == null ? "" : elementName);
        if (this.isPredefined(element)) {
            this.disableControls();
        }
    }

    private void disableControls() {
        this.typeDeclarationURLText.setEditable(false);
        this.elementNameText.setEditable(false);
        this.elementNameButton.setEnabled(false);
    }

    private boolean isPredefined(IModelElement element) {
        return ((DataType)element).isPredefined();
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        DataType dataType = (DataType)element;
        dataType.getAttribute().clear();
        if (this.volatileCheckBox.getSelection()) {
            AttributeUtil.setBooleanAttribute((IExtensibleElement)dataType, (String)"carnot:engine:volatile", (Boolean)true);
        }
        AttributeUtil.setAttribute((IExtensibleElement)dataType, (String)"carnot:engine:browsable", (String)"boolean", (String)"true");
        int selection = this.schemaTypeCombo.getSelectionIndex();
        if (selection < 0) {
            selection = 0;
        }
        AttributeUtil.setAttribute((IExtensibleElement)dataType, (String)"carnot:engine:schemaType", (String)SCHEMA_TYPES[selection][0]);
        if (selection > 0) {
            AttributeUtil.setAttribute((IExtensibleElement)dataType, (String)"carnot:engine:schemaURL", (String)this.typeDeclarationURLText.getText());
            AttributeUtil.setAttribute((IExtensibleElement)dataType, (String)"carnot:engine:typeId", (String)this.elementNameText.getText());
        }
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)3);
        this.volatileCheckBox = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.LBL_Volatile_Data, (int)3);
        this.volatileCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataType data = (DataType)PlainXMLPropertyPage.this.getModelElement();
                boolean selection = ((Button)e.widget).getSelection();
                if (selection) {
                    AttributeUtil.setBooleanAttribute((IExtensibleElement)data, (String)"carnot:engine:volatile", (Boolean)true);
                } else {
                    AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:volatile", null);
                }
            }
        });
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_SchemaType);
        this.schemaTypeCombo = FormBuilder.createCombo((Composite)composite, (int)2);
        int i = 0;
        while (i < SCHEMA_TYPES.length) {
            this.schemaTypeCombo.add(SCHEMA_TYPES[i][1]);
            ++i;
        }
        this.schemaTypeCombo.select(0);
        this.schemaTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlainXMLPropertyPage.this.validationChanged();
            }
        });
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_TypeDeclarationURL);
        this.typeDeclarationURLText = FormBuilder.createText((Composite)composite, (int)2);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_ElementName);
        this.elementNameText = FormBuilder.createText((Composite)composite);
        this.elementNameButton = FormBuilder.createButton((Composite)composite, (String)Diagram_Messages.B_Browse, null);
        this.elementNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlainXMLPropertyPage.this.selectElement();
            }
        });
        return composite;
    }

    private void validationChanged() {
        int selection = this.schemaTypeCombo.getSelectionIndex();
        this.typeDeclarationURLText.setEnabled(selection > 0);
        this.elementNameText.setEnabled(selection > 0);
        this.elementNameButton.setEnabled(selection > 0);
    }

    private void selectElement() {
        String typeDeclUri = this.typeDeclarationURLText.getText().trim();
        if (typeDeclUri.length() > 0) {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(null, (ILabelProvider)new LabelProvider());
            dialog.setMultipleSelection(false);
            Object[] declaredTypes = this.getDeclaredTypes();
            if (declaredTypes.length != 0) {
                Object[] result;
                dialog.setElements(declaredTypes);
                dialog.setInitialSelections(new Object[]{this.elementNameText.getText()});
                int resultx = dialog.open();
                if (resultx == 0 && (result = dialog.getResult()).length == 1) {
                    this.elementNameText.setText(result[0] == null ? "" : result[0].toString());
                }
            } else {
                dialog.close();
            }
        }
    }

    private Object[] getDeclaredTypes() {
        List types;
        block10: {
            types = Collections.EMPTY_LIST;
            ClassLoader cclBackup = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    IProject project = WorkspaceUtils.getProjectFromEObject((EObject)this.getModelElement());
                    String resource = this.typeDeclarationURLText.getText().trim();
                    Thread.currentThread().setContextClassLoader((ClassLoader)new ProjectClassLoader(XmlUtils.class.getClassLoader(), project, resource.startsWith("/") ? resource.substring(1) : resource));
                    String resolvedUri = XmlUtils.resolveResourceUri((String)resource);
                    switch (this.schemaTypeCombo.getSelectionIndex()) {
                        case 1: {
                            types = SchemaUtils.getXSDSchemaElements(resolvedUri);
                            break;
                        }
                        case 2: {
                            types = SchemaUtils.getWSDLSchemaElements(resolvedUri);
                            break;
                        }
                        case 3: {
                            types = SchemaUtils.getDTDSchemaElements(resolvedUri);
                        }
                    }
                }
                catch (Exception e) {
                    ErrorDialog.openError(null, (String)Diagram_Messages.ERR_Error, (String)Diagram_Messages.ERR_CannotRetrieveSchemaElement, (IStatus)new Status(2, "org.eclipse.stardust.modeling.core", 1, e.getMessage(), (Throwable)e));
                    Thread.currentThread().setContextClassLoader(cclBackup);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(cclBackup);
                throw throwable;
            }
            Thread.currentThread().setContextClassLoader(cclBackup);
        }
        return types.toArray();
    }
}

