/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;

public abstract class TableColumnSorter
extends ViewerComparator {
    public static final int ASC = 1;
    public static final int NONE = 0;
    public static final int DESC = -1;
    private int direction = 0;
    private TableColumn column;
    private TableViewer viewer;

    public TableColumnSorter(TableViewer viewer, TableColumn column) {
        this.column = column;
        this.viewer = viewer;
        this.column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TableColumnSorter.this.viewer.getComparator() != null) {
                    if (TableColumnSorter.this.viewer.getComparator() == TableColumnSorter.this) {
                        int tdirection = TableColumnSorter.this.direction;
                        if (tdirection == 1) {
                            TableColumnSorter.this.setSorter(TableColumnSorter.this, -1);
                        } else if (tdirection == -1) {
                            TableColumnSorter.this.setSorter(TableColumnSorter.this, 0);
                        }
                    } else {
                        TableColumnSorter.this.setSorter(TableColumnSorter.this, 1);
                    }
                } else {
                    TableColumnSorter.this.setSorter(TableColumnSorter.this, 1);
                }
            }
        });
    }

    public void setSorter(TableColumnSorter sorter, int direction) {
        if (direction == 0) {
            this.column.getParent().setSortColumn(null);
            this.column.getParent().setSortDirection(0);
            this.viewer.setComparator(null);
        } else {
            this.column.getParent().setSortColumn(this.column);
            sorter.direction = direction;
            if (direction == 1) {
                this.column.getParent().setSortDirection(1024);
            } else {
                this.column.getParent().setSortDirection(128);
            }
            if (this.viewer.getComparator() == sorter) {
                this.viewer.refresh();
            } else {
                this.viewer.setComparator((ViewerComparator)sorter);
            }
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.direction * this.doCompare(viewer, e1, e2);
    }

    protected abstract int doCompare(Viewer var1, Object var2, Object var3);
}

