/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.wizards;

import java.io.File;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.export.DiagramExporter;
import org.eclipse.stardust.modeling.core.wizards.ExportCarnotModelDiagramWizardPage;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportCarnotModelDiagramWizard
extends Wizard
implements IExportWizard {
    private ExportCarnotModelDiagramWizardPage page;
    private IWorkbench workbench;
    private IStructuredSelection selection;

    public ExportCarnotModelDiagramWizard() {
        this.setWindowTitle(Diagram_Messages.DESC_ExportDiagram);
    }

    public boolean canFinish() {
        boolean canFinish = super.canFinish();
        if (this.page.getDiagram() != null && this.page.getDiagram().size() > 1) {
            File diagramImgPath = new File(this.page.getFileName());
            canFinish = canFinish ? diagramImgPath.isDirectory() : canFinish;
        }
        return canFinish;
    }

    public boolean performFinish() {
        List diagrams = this.page.getDiagram();
        if (diagrams != null) {
            String imageFormat = this.page.getImageFormat();
            for (DiagramType diagram : diagrams) {
                DiagramExporter exporter = new DiagramExporter(diagram);
                File file = new File(diagrams.size() == 1 ? this.page.getFileName() : this.createFileName(diagram, this.page.getFileName()).getAbsolutePath());
                if (file == null) continue;
                String fileName = file.getName();
                int pointIdx = fileName.lastIndexOf(".");
                if (-1 == pointIdx) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + "." + imageFormat);
                }
                if ("png".equals(imageFormat)) {
                    exporter.dumpDiagramToPNGFile(file);
                    continue;
                }
                if ("jpeg".equals(imageFormat)) {
                    exporter.dumpDiagramToJPEGFile(file);
                    continue;
                }
                if (!"gif".equals(imageFormat)) continue;
                exporter.dumpDiagramToGIFFile(file);
            }
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.page = new ExportCarnotModelDiagramWizardPage(Diagram_Messages.WIZARD_ExportModel, this.selection, this.workbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor());
        this.addPage((IWizardPage)this.page);
    }

    private File createFileName(DiagramType diagram, String baseDir) {
        EObject rawContainer;
        StringBuffer buffer = new StringBuffer();
        if (baseDir != null) {
            buffer.append(baseDir).append(File.separatorChar);
        }
        if ((rawContainer = diagram.eContainer()) instanceof ModelType) {
            ModelType model = (ModelType)rawContainer;
            buffer.append(model.getId()).append("_");
        } else if (rawContainer instanceof ProcessDefinitionType) {
            ProcessDefinitionType processDefinition = (ProcessDefinitionType)rawContainer;
            ModelType model = (ModelType)processDefinition.eContainer();
            buffer.append(model.getId()).append("_");
            buffer.append(processDefinition.getId()).append("_");
        } else {
            return null;
        }
        buffer.append(diagram.getName());
        return new File(buffer.toString());
    }
}

