/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.properties;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.NameIdUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributesType;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class TypeDeclarationPropertyPage
extends AbstractModelElementPropertyPage {
    private static final XpdlPackage PKG_XPDL = XpdlPackage.eINSTANCE;
    private LabeledText txtId;
    private LabeledText txtName;
    private Label namespaceLabel;
    private Button autoNamespaceButton;
    private TypeDeclarationType declaration;
    private String savedId;
    private Button publicCheckBox;
    protected boolean publicType;
    private ModifyListener idListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (TypeDeclarationPropertyPage.this.autoNamespaceButton.getSelection() && !StringUtils.isEmpty((String)TypeDeclarationPropertyPage.this.declaration.getId())) {
                TypeDeclarationPropertyPage.this.namespaceLabel.setText(TypeDeclarationUtils.computeTargetNamespace((ModelType)ModelUtils.findContainingModel((EObject)TypeDeclarationPropertyPage.this.declaration), (String)TypeDeclarationPropertyPage.this.declaration.getId()));
            }
            TypeDeclarationPropertyPage.this.validateInput();
        }
    };
    private ModifyListener nameListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (GenericUtils.getAutoIdValue()) {
                String computedId = NameIdUtils.createIdFromName(null, (EObject)TypeDeclarationPropertyPage.this.declaration);
                TypeDeclarationPropertyPage.this.txtId.getText().setText(computedId);
            }
            TypeDeclarationPropertyPage.this.validateInput();
        }
    };

    public void elementChanged() {
        this.declaration = (TypeDeclarationType)this.getElement().getAdapter(EObject.class);
        this.setupVisibility();
        this.savedId = this.declaration.getId();
        this.txtName.getText().removeModifyListener(this.nameListener);
        this.txtId.getText().removeModifyListener(this.idListener);
        WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        wBndMgr.bind(this.txtId, (EObject)this.declaration, (EStructuralFeature)PKG_XPDL.getTypeDeclarationType_Id());
        wBndMgr.bind(this.txtName, (EObject)this.declaration, (EStructuralFeature)PKG_XPDL.getTypeDeclarationType_Name());
        XSDNamedComponent type = null;
        try {
            type = TypeDeclarationUtils.findElementOrTypeDeclaration((TypeDeclarationType)this.declaration);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        String namespace = type == null ? null : type.getTargetNamespace();
        this.namespaceLabel.setText(namespace == null ? "" : namespace);
        if (!TypeDeclarationUtils.isInternalSchema((TypeDeclarationType)this.declaration)) {
            this.autoNamespaceButton.setSelection(false);
            this.autoNamespaceButton.setEnabled(false);
        }
        wBndMgr.getModelBindingManager().updateWidgets((Object)this.declaration);
        this.txtName.getText().addModifyListener(this.nameListener);
        this.txtId.getText().addModifyListener(this.idListener);
        this.txtName.getText().selectAll();
        this.txtName.getText().setFocus();
        if (ExtendedAttributeUtil.getAttributeValue((Extensible)this.declaration, (String)"carnot:connection:uri") != null) {
            this.txtId.getText().setEnabled(false);
            this.txtName.getText().setEnabled(false);
        }
        this.validateInput();
    }

    public void apply() {
        ArrayList savedDirectives = new ArrayList();
        savedDirectives.addAll(this.declaration.getSchema().getReferencingDirectives());
        String id = this.declaration.getId();
        if (TypeDeclarationUtils.isInternalSchema((TypeDeclarationType)this.declaration)) {
            XSDTypeDefinition type;
            XSDElementDeclaration element;
            XSDSchema xsdSchema = this.declaration.getSchema();
            String oldTargetNamespace = xsdSchema.getTargetNamespace();
            if (!this.namespaceLabel.getText().equals(oldTargetNamespace == null ? "" : oldTargetNamespace)) {
                xsdSchema.setTargetNamespace(TypeDeclarationUtils.computeTargetNamespace((ModelType)ModelUtils.findContainingModel((EObject)this.declaration), (String)id));
            }
            String prefix = TypeDeclarationUtils.computePrefix((String)id, xsdSchema.getQNamePrefixToNamespaceMap().keySet());
            xsdSchema.getQNamePrefixToNamespaceMap().put(prefix, xsdSchema.getTargetNamespace());
            ArrayList<String> toRemove = new ArrayList<String>();
            Map prefixes = xsdSchema.getQNamePrefixToNamespaceMap();
            if (oldTargetNamespace != null) {
                for (Map.Entry entry : prefixes.entrySet()) {
                    if (prefix.equals(entry.getKey()) || !oldTargetNamespace.equals(entry.getValue())) continue;
                    toRemove.add((String)entry.getKey());
                }
                int j = 0;
                while (j < toRemove.size()) {
                    prefixes.remove(toRemove.get(j));
                    ++j;
                }
                xsdSchema.eSet((EStructuralFeature)XSDPackage.eINSTANCE.getXSDSchema_ReferencingDirectives(), savedDirectives);
                TypeDeclarationUtils.updateImports((XSDSchema)xsdSchema, (String)oldTargetNamespace, (String)this.savedId, (String)id);
            }
            xsdSchema.setSchemaLocation("urn:internal:" + id);
            xsdSchema.eSet((EStructuralFeature)XSDPackage.eINSTANCE.getXSDSchema_ReferencingDirectives(), savedDirectives);
            XSDNamedComponent component = TypeDeclarationUtils.findElementOrTypeDeclaration((TypeDeclarationType)this.declaration, (String)this.savedId);
            if (component != null) {
                component.setName(id);
            }
            if (component instanceof XSDElementDeclaration && !(element = (XSDElementDeclaration)component).isElementDeclarationReference() && element.getAnonymousTypeDefinition() == null && (type = element.getTypeDefinition()) != null && type.getSchema() == xsdSchema) {
                type.setName(id);
            }
        }
        HashSet elements = new HashSet();
        ModelType model = ModelUtils.findContainingModel((EObject)this.declaration);
        XSDTypeDefinition definition = TypeDeclarationUtils.getTypeDefinition((TypeDeclarationsType)model.getTypeDeclarations(), (String)id);
        for (TypeDeclarationType decl : ((TypeDeclarationsType)this.declaration.eContainer()).getTypeDeclaration()) {
            TypeDeclarationUtils.findElementsForType((TypeDeclarationType)decl, elements, (String)this.savedId);
        }
        for (XSDElementDeclaration elementDecl : elements) {
            elementDecl.setTypeDefinition(definition);
        }
        this.declaration.getSchema().eSet((EStructuralFeature)XSDPackage.eINSTANCE.getXSDSchema_ReferencingDirectives(), savedDirectives);
        this.savedId = id;
    }

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createLabeledControlsComposite((Composite)parent);
        this.txtName = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_Name);
        this.txtName.setTextLimit(80);
        this.txtId = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_ID);
        this.txtId.setTextLimit(80);
        boolean autoIdButtonValue = GenericUtils.getAutoIdValue();
        if (autoIdButtonValue) {
            this.txtId.getText().setEditable(false);
        }
        this.publicCheckBox = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.CHECKBOX_Visibility);
        this.publicCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean bl = TypeDeclarationPropertyPage.this.publicType = !TypeDeclarationPropertyPage.this.publicType;
                if (TypeDeclarationPropertyPage.this.publicType) {
                    ExtendedAttributeUtil.setAttribute((ExtendedAttributesType)TypeDeclarationPropertyPage.this.declaration.getExtendedAttributes(), (String)"carnot:engine:visibility", (String)"Public");
                } else {
                    ExtendedAttributeUtil.setAttribute((ExtendedAttributesType)TypeDeclarationPropertyPage.this.declaration.getExtendedAttributes(), (String)"carnot:engine:visibility", (String)"Private");
                }
            }
        });
        FormBuilder.createLabel((Composite)composite, (String)" ", (int)2);
        FormBuilder.createHorizontalSeparator((Composite)composite, (int)2);
        FormBuilder.createLabel((Composite)composite, (String)" ", (int)2);
        FormBuilder.createLabel((Composite)composite, (String)Structured_Messages.SimpleTypePropertyPage_NamespaceLabel);
        this.namespaceLabel = FormBuilder.createLabel((Composite)composite, (String)"");
        this.autoNamespaceButton = FormBuilder.createCheckBox((Composite)composite, (String)Structured_Messages.SYNCHRONIZE_NAMESPACE_AND_ID, (int)2);
        this.autoNamespaceButton.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoIdGeneration"));
        return composite;
    }

    private void validateInput() {
        ModelType model = (ModelType)this.declaration.eContainer().eContainer();
        if (this.txtName.getText().getText().length() == 0 || this.txtId.getText().getText().length() == 0) {
            this.setMessage(Structured_Messages.TypeDeclarationPropertyPage_EmptyValuesMessage, 3);
            this.setValid(false);
            return;
        }
        if (!ModelUtils.isValidId((String)this.txtId.getText().getText())) {
            this.setMessage(MessageFormat.format(Structured_Messages.ComplexTypePropertyPage_InvalidFieldIdentifierErrorMessage, this.txtId.getText().getText()), 3);
            this.setValid(false);
            return;
        }
        TypeDeclarationsType declarations = model.getTypeDeclarations();
        EList allDeclarations = declarations.getTypeDeclaration();
        for (TypeDeclarationType td : allDeclarations) {
            if (td.equals(this.declaration)) continue;
            if (td.getId().equals(this.txtId.getText().getText())) {
                this.setMessage(MessageFormat.format(Structured_Messages.TypeDeclarationPropertyPage_DuplicateValueMessage, this.txtId.getText().getText()), 3);
                this.setValid(false);
                return;
            }
            if (!td.getName().equals(this.txtName.getText().getText())) continue;
            this.setMessage(MessageFormat.format(Structured_Messages.TypeDeclarationPropertyPage_DuplicateValueMessage, this.txtName.getText().getText()), 3);
            this.setValid(false);
            return;
        }
        this.setMessage(null);
        this.setValid(true);
    }

    private void setupVisibility() {
        ExtendedAttributeType visibility = ExtendedAttributeUtil.getAttribute((ExtendedAttributesType)this.declaration.getExtendedAttributes(), (String)"carnot:engine:visibility");
        if (visibility == null) {
            String visibilityDefault = PlatformUI.getPreferenceStore().getString("multiPackageModelingVisibility");
            if (visibilityDefault == null || visibilityDefault == "" || visibilityDefault.equalsIgnoreCase("Public")) {
                ExtendedAttributeUtil.createAttribute((Extensible)this.declaration, (String)"carnot:engine:visibility").setValue("Public");
                this.publicType = true;
            }
        } else {
            this.publicType = visibility.getValue().equalsIgnoreCase("Public");
        }
        this.publicCheckBox.setSelection(this.publicType);
    }
}

