/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.wizards;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.data.structured.StructLabelProvider;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;

public class TypeDeclarationsSelectionPage
extends WizardPage {
    private static String[] COLUMNS = new String[]{Structured_Messages.TypeDependenciesColumnLabel};
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final TypeDeclarationType typeDeclaration;
    private TableViewer viewer;
    private Set<TypeDeclarationType> dependencies;
    private StructLabelProvider labelProvider = new StructLabelProvider();

    protected TypeDeclarationsSelectionPage(TypeDeclarationType typeDeclaration) {
        super("TypesPage");
        this.typeDeclaration = typeDeclaration;
        this.dependencies = this.getDependencies(typeDeclaration);
    }

    public void createControl(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)3);
        FormBuilder.createLabel((Composite)composite, (String)Structured_Messages.ExportedTypeLabel);
        FormBuilder.createLabel((Composite)composite, (String)"").setImage(this.labelProvider.getImage(this.typeDeclaration));
        FormBuilder.createLabel((Composite)composite, (String)this.labelProvider.getText(this.typeDeclaration));
        Table table = FormBuilder.createTable((Composite)composite, (int)2080, (String[])COLUMNS, (int[])new int[]{100}, (int)3);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setInput(this.dependencies);
        TableItem[] items = this.viewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(true);
            ++i;
        }
        this.setControl((Control)composite);
    }

    private Set<TypeDeclarationType> getDependencies(TypeDeclarationType typeDeclaration) {
        Set dependencies = CollectionUtils.newSet();
        Set missing = CollectionUtils.newSet();
        this.addDependencies(dependencies, missing, typeDeclaration);
        if (!missing.isEmpty()) {
            StringBuffer locations = new StringBuffer();
            locations.append(Structured_Messages.STRINGBUFFER_REFERENCED_SCHEMA_SPECIFIED_AT_THE_FOLLOWING_LOCATION_WERE_NOT_FOUND);
            locations.append(LINE_SEPARATOR);
            Iterator i = missing.iterator();
            while (i.hasNext()) {
                locations.append(LINE_SEPARATOR);
                locations.append((String)i.next());
            }
            MessageDialog.openWarning((Shell)this.getShell(), (String)Structured_Messages.DIA_MISSING_REFERENCES, (String)locations.toString());
        }
        return dependencies;
    }

    private void addDependencies(Set<TypeDeclarationType> dependencies, Set<String> missing, TypeDeclarationType typeDeclaration) {
        XSDSchema schema = typeDeclaration.getSchemaType().getSchema();
        EList contents = schema.getContents();
        int i = 0;
        while (i < contents.size()) {
            String location;
            TypeDeclarationType declaration;
            XSDSchemaContent item = (XSDSchemaContent)contents.get(i);
            if (item instanceof XSDImport && (declaration = this.getSchemaContainingTypeDeclaration(location = ((XSDImport)item).getSchemaLocation(), missing, typeDeclaration)) != null && !dependencies.contains(declaration)) {
                dependencies.add(declaration);
                this.addDependencies(dependencies, missing, declaration);
            }
            ++i;
        }
    }

    private TypeDeclarationType getSchemaContainingTypeDeclaration(String location, Set<String> missing, TypeDeclarationType typeDeclaration) {
        if (location != null && location.startsWith("urn:internal:")) {
            String typeId = location.substring("urn:internal:".length());
            TypeDeclarationsType typeDeclarations = (TypeDeclarationsType)typeDeclaration.eContainer();
            if (typeDeclarations != null) {
                TypeDeclarationType declaration = typeDeclarations.getTypeDeclaration(typeId);
                if (declaration == null && !missing.contains(location)) {
                    missing.add(location);
                } else {
                    if (declaration.getSchemaType() != null) {
                        return declaration;
                    }
                    if (declaration.getExternalReference() != null) {
                        return this.getSchemaContainingTypeDeclaration(declaration.getExternalReference().getLocation(), missing, typeDeclaration);
                    }
                }
            }
        }
        return null;
    }

    public List<TypeDeclarationType> getTypes2Save() {
        List selected = CollectionUtils.newList();
        selected.add(this.typeDeclaration);
        if (this.viewer == null) {
            selected.addAll(this.dependencies);
        } else {
            TableItem[] items = this.viewer.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                Object data;
                if (items[i].getChecked() && this.dependencies.contains(data = items[i].getData())) {
                    selected.add((TypeDeclarationType)data);
                }
                ++i;
            }
        }
        return selected;
    }
}

