/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.stardust.engine.core.runtime.beans.ActivityThread;
import org.eclipse.stardust.engine.core.runtime.beans.ActivityThreadContextAdapter;
import org.eclipse.stardust.engine.core.runtime.beans.IActivityInstance;
import org.eclipse.stardust.engine.core.runtime.beans.TransitionTokenBean;
import org.eclipse.stardust.modeling.debug.engine.WorkflowEventListener;

public class DebugActivityThreadContext
extends ActivityThreadContextAdapter {
    private List listeners = new ArrayList();
    private Set traversedItems = new HashSet();
    private Map activeItems = new HashMap();

    public void addToWorkflowEventListeners(WorkflowEventListener listener) {
        this.listeners.add(listener);
        this.addWorkflowEventListener(listener);
    }

    public boolean isStepMode() {
        return false;
    }

    public void suspendActivityThread(ActivityThread activityThread) {
    }

    public void enteringTransition(TransitionTokenBean transitionToken) {
        HashSet<TransitionTokenBean> instances = (HashSet<TransitionTokenBean>)this.activeItems.get(transitionToken.getTransition());
        if (instances == null) {
            instances = new HashSet<TransitionTokenBean>();
            this.activeItems.put(transitionToken.getTransition(), instances);
        }
        instances.add(transitionToken);
        for (WorkflowEventListener listener : this.listeners) {
            listener.performedTransition(transitionToken);
        }
    }

    public void completingTransition(TransitionTokenBean transitionToken) {
        this.traversedItems.add(transitionToken.getTransition());
        Set instances = (Set)this.activeItems.get(transitionToken.getTransition());
        if (instances != null) {
            instances.remove(transitionToken);
            if (instances.isEmpty()) {
                this.activeItems.remove(transitionToken.getTransition());
            }
        }
        for (WorkflowEventListener listener : this.listeners) {
            listener.performedTransition(transitionToken);
        }
    }

    public void enteringActivity(IActivityInstance activityInstance) {
        HashSet<IActivityInstance> instances = (HashSet<IActivityInstance>)this.activeItems.get(activityInstance.getActivity());
        if (instances == null) {
            instances = new HashSet<IActivityInstance>();
            this.activeItems.put(activityInstance.getActivity(), instances);
        }
        instances.add(activityInstance);
        this.fireActivityStarted(activityInstance);
    }

    public void completingActivity(IActivityInstance activityInstance) {
        this.traversedItems.add(activityInstance.getActivity());
        Set instances = (Set)this.activeItems.get(activityInstance.getActivity());
        if (instances != null) {
            instances.remove(activityInstance);
            if (instances.isEmpty()) {
                this.activeItems.remove(activityInstance.getActivity());
            }
        }
        this.fireActivityCompleted(activityInstance);
    }

    public void handleWorklistItem(IActivityInstance activityInstance) {
        this.fireAppendedToWorklist(activityInstance);
    }

    public boolean allowsForceAssignmentToHuman() {
        return false;
    }

    public boolean isActiveItem(Object item) {
        return this.activeItems.containsKey(item);
    }

    public boolean isTraversedItem(Object item) {
        return this.traversedItems.contains(item);
    }

    protected void fireAppendedToWorklist(IActivityInstance ai) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            int i = 0;
            while (i < this.listeners.size()) {
                WorkflowEventListener tmp = (WorkflowEventListener)this.listeners.get(i);
                tmp.appendedToWorklist(ai);
                ++i;
            }
        }
    }
}

