/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.model;

import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.debugger.types.ActivityInstanceDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.DataMappingDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.DataValueDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.ProcessInstanceDigest;
import org.eclipse.stardust.modeling.debug.model.CWMDebugElement;
import org.eclipse.stardust.modeling.debug.model.CWMDebugTarget;
import org.eclipse.stardust.modeling.debug.model.CWMThread;
import org.eclipse.stardust.modeling.debug.model.JavaVariableDecorator;

public class CWMStackFrame
extends CWMDebugElement
implements IStackFrame {
    private CWMThread thread;
    private ActivityInstanceDigest activityInstance;
    private ProcessInstanceDigest processInstance;
    private IJavaVariable[] variables;
    private IStackFrame javaStackFrame;

    public CWMStackFrame(CWMThread thread, ActivityInstanceDigest activityInstance, IStackFrame javaStackFrame) {
        this(thread, activityInstance, activityInstance.getProcessInstance(), javaStackFrame);
    }

    public CWMStackFrame(CWMThread thread, ProcessInstanceDigest processInstance, IStackFrame javaStackFrame) {
        this(thread, null, processInstance, javaStackFrame);
    }

    private CWMStackFrame(CWMThread thread, ActivityInstanceDigest activityInstance, ProcessInstanceDigest processInstance, IStackFrame javaStackFrame) {
        super((CWMDebugTarget)thread.getDebugTarget());
        this.thread = thread;
        this.activityInstance = activityInstance;
        this.processInstance = processInstance;
        this.javaStackFrame = javaStackFrame;
        this.initVariables();
    }

    public IStackFrame getJavaStackFrame() {
        return this.javaStackFrame;
    }

    public ActivityInstanceDigest getActivityInstance() {
        return this.activityInstance;
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.variables;
    }

    public boolean hasVariables() throws DebugException {
        return this.variables.length > 0;
    }

    public int getLineNumber() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        String name = null;
        name = this.activityInstance != null ? MessageFormat.format(Debug_Messages.CWMStack_MSG_ActivityInstanceOID, this.activityInstance.getOid(), this.activityInstance.getActivityId(), this.activityInstance.getProcessDefinitionId()) : (this.processInstance != null ? MessageFormat.format(Debug_Messages.MSG_ProcessOID, this.processInstance.getOid()) : Debug_Messages.CWMStack_ActivityInstanceUnknown);
        return name;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IJavaStackFrame.class.equals((Object)adapter)) {
            return this.javaStackFrame;
        }
        return super.getAdapter(adapter);
    }

    private void initVariables() {
        DataMappingDigest[] dataMappings = null;
        DataValueDigest[] dataValues = null;
        if (this.activityInstance != null) {
            dataMappings = this.activityInstance.getDataMappings();
        }
        if (this.processInstance != null) {
            dataValues = this.processInstance.getDataValues();
        }
        if (dataMappings == null) {
            dataMappings = new DataMappingDigest[]{};
        }
        if (dataValues == null) {
            dataValues = new DataValueDigest[]{};
        }
        this.variables = new IJavaVariable[dataMappings.length + dataValues.length];
        int i = 0;
        while (i < dataMappings.length) {
            this.variables[i] = (IJavaVariable)dataMappings[i].getDataField().getWritebackVariable();
            if (this.variables[i] instanceof JavaVariableDecorator) {
                JavaVariableDecorator decorator = (JavaVariableDecorator)this.variables[i];
                decorator.setSupportsModification(dataMappings[i].supportsValueModification());
            }
            ++i;
        }
        int offset = dataMappings.length;
        int i2 = 0;
        while (i2 < dataValues.length) {
            this.variables[offset + i2] = (IJavaVariable)dataValues[i2].getDataField().getWritebackVariable();
            if (this.variables[i2] instanceof JavaVariableDecorator) {
                JavaVariableDecorator decorator = (JavaVariableDecorator)this.variables[i2];
                decorator.setSupportsModification(dataValues[i2].supportsValueModification());
            }
            ++i2;
        }
    }
}

