/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.deploy;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.deploy.Deploy_Messages;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class LoginDialog
extends Dialog {
    private LabeledText idEntry;
    private LabeledText passwordField;
    private LabeledText partitionEntry;
    private LabeledText domainEntry;
    private LabeledText realmEntry;
    private String id;
    private String password;
    private String partition;
    private String domain;
    private String realm;

    protected LoginDialog(Shell parent) {
        super(parent);
    }

    public String getId() {
        return this.id;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPartitionId() {
        return this.partition;
    }

    public String getDomainId() {
        return this.domain;
    }

    public String getRealmId() {
        return this.realm;
    }

    protected Control createDialogArea(Composite parent) {
        Button cancelButton;
        Button okButton;
        Composite panel = (Composite)super.createDialogArea(parent);
        ((GridLayout)panel.getLayout()).numColumns = 2;
        KeyAdapter listener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000011 && e.stateMask == 131072) {
                    String up = new String(new char[]{'m', 'o', 't', 'u'});
                    LoginDialog.this.idEntry.getText().setText(up);
                    LoginDialog.this.passwordField.getText().setText(up);
                    if (LoginDialog.this.checkCanClose()) {
                        LoginDialog.this.okPressed();
                    }
                }
            }
        };
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean canClose = LoginDialog.this.checkCanClose();
                Button okButton = LoginDialog.this.getButton(32);
                if (okButton != null) {
                    okButton.setEnabled(canClose);
                }
            }
        };
        this.idEntry = FormBuilder.createLabeledText((Composite)panel, (String)Deploy_Messages.getString("LBL_ID"));
        this.idEntry.getText().addKeyListener((KeyListener)listener);
        this.idEntry.getText().addModifyListener(modifyListener);
        this.passwordField = FormBuilder.createLabeledText((Composite)panel, (String)Deploy_Messages.getString("LBL_PASSWORD"), (boolean)true);
        this.passwordField.getText().addKeyListener((KeyListener)listener);
        if (Parameters.instance().getBoolean("Security.PromptPartition", false)) {
            this.partitionEntry = FormBuilder.createLabeledText((Composite)panel, (String)Deploy_Messages.getString("LBL_PARTITION"));
            this.partitionEntry.getText().addKeyListener((KeyListener)listener);
        }
        if (Parameters.instance().getBoolean("Security.PromptDomain", false)) {
            this.domainEntry = FormBuilder.createLabeledText((Composite)panel, (String)Deploy_Messages.getString("LBL_DOMAIN"));
            this.domainEntry.getText().addKeyListener((KeyListener)listener);
        }
        if (Parameters.instance().getBoolean("Security.PromptRealm", false)) {
            this.realmEntry = FormBuilder.createLabeledText((Composite)panel, (String)Deploy_Messages.getString("LBL_REALM"));
            this.realmEntry.getText().addKeyListener((KeyListener)listener);
        }
        if ((okButton = this.getButton(32)) != null) {
            okButton.addKeyListener((KeyListener)listener);
        }
        if ((cancelButton = this.getButton(256)) != null) {
            cancelButton.addKeyListener((KeyListener)listener);
        }
        return panel;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Deploy_Messages.getString("TITLE_LOGIN"));
    }

    protected boolean checkCanClose() {
        boolean canClose = true;
        canClose &= LoginDialog.checkMandatory(this.idEntry);
        canClose &= LoginDialog.checkMandatory(this.passwordField);
        canClose &= LoginDialog.checkMandatory(this.partitionEntry);
        canClose &= LoginDialog.checkMandatory(this.domainEntry);
        return canClose &= LoginDialog.checkMandatory(this.realmEntry);
    }

    protected void okPressed() {
        this.id = this.idEntry.getText().getText();
        this.password = this.passwordField.getText().getText();
        if (this.partitionEntry != null) {
            this.partition = this.partitionEntry.getText().getText();
        }
        if (this.domainEntry != null) {
            this.domain = this.domainEntry.getText().getText();
        }
        if (this.realmEntry != null) {
            this.realm = this.realmEntry.getText().getText();
        }
        super.okPressed();
    }

    private static boolean checkMandatory(LabeledText entry) {
        boolean result;
        if (entry != null) {
            if (StringUtils.isEmpty((String)entry.getText().getText())) {
                entry.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
                entry.getLabel().setToolTipText(Deploy_Messages.getString("MSG_FIELD_NOT_EMPTY"));
                result = false;
            } else {
                entry.getLabel().setValidationStatus(IQuickValidationStatus.OK);
                entry.getLabel().setToolTipText("");
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }
}

