/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.properties.ReferencedModelSorter;
import org.eclipse.stardust.modeling.javascript.editor.EditorUtils;
import org.eclipse.stardust.modeling.javascript.editor.JSCompilationUnitEditor;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.MessageTransformationModelingPlugin;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.IMessageTransformationApplicationView;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.ErrorFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.ExpressionFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.NoExpressionFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.SourceHighlightFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.TargetHighlightFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.TextFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.ClearMappingExpressionAction;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.ClearMappingStatementAction;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.DelegatingMessageTypeLabelProvider;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.DeleteSourceMessageAction;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.DeleteTargetMessageAction;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.ExternalClassesConfigurationDialog;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.IndexConfigurationDialog;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MTATreeViewer;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MappingConfiguration;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MessageAdditionDialog;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MessageTypeComparer;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MessagingJavaCodeScanner;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MultipleAccessPathBrowserContentProvider;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.RenameMessageAction;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.ToggleMappingBreakpointAction;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.AbstractJavaScanner;

public class MessageTransformationApplicationControlsManager
implements IMessageTransformationApplicationView,
KeyListener,
IAnnotationModelListener {
    private MTATreeViewer sourceMessageTreeViewer;
    private MTATreeViewer targetMessageTreeViewer;
    private Tree sourceMessageTree;
    private Tree targetMessageTree;
    private JSCompilationUnitEditor expressionsEditor;
    private GridData svcData;
    protected Composite statementViewerComposite;
    private IProject project;
    private IFile tempFileResource;
    private String sourceFieldText;
    private Composite sourceFilterComposite;
    private Composite sourceFilterButtonComposite;
    private Composite targetFilterComposite;
    private Composite targetFilterButtonComposite;
    protected boolean targetNoExpression;
    private Button targetExpressionFilter;
    protected boolean targetExpression;
    private Button targetNoExpressionFilter;
    protected boolean targetHighlight;
    private Button targetHighlightedFilter;
    protected boolean sourceHighlight;
    protected boolean targetError;
    private ExpressionFilter targetExpressionViewerFilter;
    private NoExpressionFilter targetNoExpressionViewerFilter;
    private TargetHighlightFilter targetHighlightViewerFilter;
    private TextFilter targetTextViewerFilter;
    private Text targetFilterText;
    protected String targetFilterTextText;
    private TextFilter sourceTextViewerFilter;
    private Text sourceFilterText;
    private Button sourceHighlightedFilter;
    private MessageTransformationController controller = new MessageTransformationController();
    private DelegatingMessageTypeLabelProvider sourceLabelProvider = new DelegatingMessageTypeLabelProvider(this.controller);
    private DelegatingMessageTypeLabelProvider targetLabelProvider = new DelegatingMessageTypeLabelProvider(this.controller);
    private ReferencedModelSorter refModelSorter = new ReferencedModelSorter();
    private SourceHighlightFilter sourceHighlightViewerFilter;
    private ErrorFilter targetErrorViewerFilter;
    private Button btnToggleMappingStyle;
    private Label lblExpressionPrefix;
    private ModelType model;
    private boolean simpleMode;
    private boolean withSerializable;
    private boolean externalReference;
    private Group sourceComposite;
    private Group targetComposite;
    private Group expressionComposite;
    private GridLayout mainLayout;
    private SashForm sashForm;
    private Button btnAddExternalClass;
    private Button groupingCheckbox;
    private static final Image errorImage = JavaPluginImages.get((String)"org.eclipse.wst.jsdt.ui.quickfix_error_obj.gif");

    public Control create(Composite parent, IModelElement modelElement) {
        return this.create(parent, modelElement, true);
    }

    public Control create(Composite parent, IModelElement modelElement, boolean enableEditing) {
        return this.create(parent, modelElement, enableEditing && !this.externalReference, false);
    }

    public Control create(Composite parent, IModelElement modelElement, boolean enableEditing, boolean simpleMode, boolean withSerializable) {
        this.withSerializable = withSerializable;
        return this.create(parent, modelElement, enableEditing, simpleMode);
    }

    public Control create(Composite parent, IModelElement modelElement, boolean enableEditing, boolean simpleMode) {
        try {
            parent.setSize(20, 20);
            this.simpleMode = simpleMode;
            this.controller.setSimpleMode(simpleMode);
            this.controller.setWithSerializable(this.withSerializable);
            this.model = ModelUtils.findContainingModel((EObject)modelElement);
            this.project = WorkspaceUtils.getProjectFromEObject((EObject)modelElement);
            FillLayout parentLayout = new FillLayout();
            parent.setLayout((Layout)parentLayout);
            this.sashForm = new SashForm(parent, 512){

                public void setLayoutData(Object layoutData) {
                    if (!(layoutData instanceof GridData)) {
                        super.setLayoutData(layoutData);
                    }
                }
            };
            this.sashForm.setLayoutData(null);
            this.mainLayout = new GridLayout();
            this.mainLayout.numColumns = 2;
            GridData mainData = new GridData();
            mainData.grabExcessHorizontalSpace = true;
            mainData.grabExcessVerticalSpace = true;
            mainData.horizontalAlignment = 4;
            mainData.verticalAlignment = 4;
            this.createInputOutputSection(modelElement, enableEditing);
            if (!simpleMode) {
                this.createEditorComposite(modelElement, enableEditing);
            }
            if (enableEditing) {
                Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
                DropTarget target = new DropTarget(this.targetMessageTreeViewer.getControl(), 19);
                target.setTransfer(types);
                target.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void dragEnter(DropTargetEvent event) {
                        if (event.detail == 16) {
                            event.detail = (event.operations & 1) != 0 ? 1 : 0;
                        }
                        int i = 0;
                        int n = event.dataTypes.length;
                        while (i < n) {
                            if (TextTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                                event.currentDataType = event.dataTypes[i];
                            }
                            ++i;
                        }
                    }

                    public void dragOver(DropTargetEvent event) {
                        event.feedback = 9;
                    }

                    public void drop(DropTargetEvent event) {
                        TreeItem item;
                        if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && (item = (TreeItem)event.item) != null) {
                            Object mapTarget = item.getData();
                            if (MessageTransformationApplicationControlsManager.this.controller.hasMappingExpression(mapTarget)) {
                                MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 296);
                                messageBox.setText(Modeling_Messages.TXT_WR_LEER);
                                messageBox.setMessage(String.valueOf(Modeling_Messages.MSG_TARGET_FIELD_ALREADY_CONTAINS_EXPR) + "\n\n" + Modeling_Messages.MSG_WANT_OVERWRITE_SEL_MSG);
                                if (messageBox.open() == 32) {
                                    MessageTransformationApplicationControlsManager.this.performDropMapping((AccessPointType)mapTarget);
                                    MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.refreshVisibleItems();
                                    MessageTransformationApplicationControlsManager.this.refreshDocument();
                                }
                            } else {
                                MessageTransformationApplicationControlsManager.this.performDropMapping((AccessPointType)mapTarget);
                                MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.refreshVisibleItems();
                                MessageTransformationApplicationControlsManager.this.refreshDocument();
                            }
                        }
                    }
                });
            }
            this.sashForm.layout();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return this.sashForm;
    }

    private void performDropMapping(AccessPointType mapTarget) {
        AccessPointType st = this.controller.getSelectedSourceField();
        AccessPointType tt = mapTarget;
        MappingConfiguration config = null;
        IndexConfigurationDialog dialog = null;
        if (this.controller.isEqualOrSimilar(st, tt, true) && this.controller.isIndexingRequired(st, tt)) {
            MultipleAccessPathBrowserContentProvider saveSourceAPB = this.controller.getSourceAPB();
            MultipleAccessPathBrowserContentProvider saveTargetAPB = this.controller.getTargetAPB();
            config = new MappingConfiguration(this.controller, st, tt);
            dialog = new IndexConfigurationDialog(Display.getCurrent().getActiveShell(), this.controller, config);
            dialog.open();
            config.setIndexMap(dialog.getIndexMap());
            this.controller.setSourceAPB(saveSourceAPB);
            this.controller.setTargetAPB(saveTargetAPB);
        }
        if (dialog == null || !dialog.isCanceled()) {
            this.controller.performDropMapping(mapTarget, config);
        }
    }

    private void createInputOutputSection(final IModelElement modelElement, final boolean enableEditing) {
        Composite ioComposite = new Composite((Composite)this.sashForm, 0){

            public void setEnabled(boolean enabled) {
                super.setEnabled(true);
            }
        };
        GridLayout ioLayout = new GridLayout();
        ioLayout.numColumns = 2;
        GridData ioData = new GridData();
        ioData.grabExcessHorizontalSpace = true;
        ioData.grabExcessVerticalSpace = true;
        ioData.horizontalAlignment = 4;
        ioComposite.setLayout((Layout)ioLayout);
        ioComposite.setLayoutData((Object)ioData);
        this.sourceComposite = new Group(ioComposite, 0){

            protected void checkSubclass() {
            }

            public void setEnabled(boolean enabled) {
                super.setEnabled(true);
            }
        };
        new GridLayout();
        this.mainLayout.numColumns = 2;
        this.sourceComposite.setLayout((Layout)this.mainLayout);
        GridData messageData = new GridData();
        messageData.grabExcessHorizontalSpace = true;
        messageData.grabExcessVerticalSpace = true;
        messageData.horizontalAlignment = 4;
        messageData.verticalAlignment = 4;
        this.sourceComposite.setLayoutData((Object)messageData);
        this.sourceComposite.setText(MessageFormat.format(Modeling_Messages.TXT_SR, this.controller.getNameString()));
        this.targetComposite = new Group(ioComposite, 0){

            protected void checkSubclass() {
            }

            public void setEnabled(boolean enabled) {
                super.setEnabled(true);
            }
        };
        this.targetComposite.setLayout((Layout)this.mainLayout);
        this.targetComposite.setLayoutData((Object)messageData);
        this.targetComposite.setText(MessageFormat.format(Modeling_Messages.TXT_TARGET, this.controller.getNameString()));
        GridData treeData = new GridData();
        treeData.grabExcessHorizontalSpace = true;
        treeData.grabExcessVerticalSpace = true;
        treeData.horizontalAlignment = 4;
        treeData.verticalAlignment = 4;
        treeData.horizontalSpan = 2;
        GridData addButtonData = new GridData();
        addButtonData.horizontalSpan = 2;
        Button addSourceTypeButton = new Button((Composite)this.sourceComposite, 0);
        addSourceTypeButton.setLayoutData((Object)addButtonData);
        Button addTargetTypeButton = new Button((Composite)this.targetComposite, 0);
        addTargetTypeButton.setLayoutData((Object)addButtonData);
        addSourceTypeButton.setText(Modeling_Messages.TXT_ADD_IP);
        addTargetTypeButton.setText(Modeling_Messages.TXT_ADD_OP);
        addSourceTypeButton.setEnabled(enableEditing);
        addTargetTypeButton.setEnabled(enableEditing);
        addSourceTypeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (MessageTransformationApplicationControlsManager.this.controller.getAvailableMessageTypes().isEmpty()) {
                    MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 264);
                    messageBox.setText(Modeling_Messages.TXT_WR_LEER);
                    messageBox.setMessage(Modeling_Messages.MSG_FIRST_NEED_DEFINE_STR_DATA_MD);
                    messageBox.open();
                } else {
                    MessageAdditionDialog dialog = new MessageAdditionDialog(Display.getCurrent().getActiveShell(), MessageTransformationApplicationControlsManager.this.controller, MessageTransformationApplicationControlsManager.this.controller.getSourceMessageTypes(), "", DirectionType.IN_LITERAL);
                    if (dialog.open() == 0) {
                        MessageTransformationApplicationControlsManager.this.controller.addSourceMessageType(dialog.getMessageType(), dialog.getMessageName());
                        MessageTransformationApplicationControlsManager.this.refreshModel();
                        MessageTransformationApplicationControlsManager.this.controller.initializeMappings(modelElement);
                    }
                }
            }
        });
        addTargetTypeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (MessageTransformationApplicationControlsManager.this.controller.getAvailableMessageTypes().isEmpty()) {
                    MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 264);
                    messageBox.setText(Modeling_Messages.TXT_WR_LEER);
                    messageBox.setMessage(Modeling_Messages.MSG_FIRST_NEED_DEFINE_STR_DATA_MD);
                    messageBox.open();
                } else {
                    MessageAdditionDialog dialog = new MessageAdditionDialog(Display.getCurrent().getActiveShell(), MessageTransformationApplicationControlsManager.this.controller, MessageTransformationApplicationControlsManager.this.controller.getTargetMessageTypes(), "Out", DirectionType.OUT_LITERAL);
                    if (dialog.open() == 0) {
                        MessageTransformationApplicationControlsManager.this.controller.addTargetMessageType(dialog.getMessageType(), dialog.getMessageName());
                        MessageTransformationApplicationControlsManager.this.refreshModel();
                        MessageTransformationApplicationControlsManager.this.controller.initializeMappings(modelElement);
                    }
                }
            }
        });
        this.createFilterComposites();
        this.sourceMessageTree = new Tree((Composite)this.sourceComposite, 67586){

            public void setEnabled(boolean enabled) {
                super.setEnabled(true);
            }

            protected void checkSubclass() {
            }
        };
        GridData treeGridData = new GridData();
        treeGridData.grabExcessVerticalSpace = true;
        treeGridData.verticalAlignment = 4;
        this.sourceMessageTree.setLayoutData((Object)treeGridData);
        this.sourceMessageTree.setHeaderVisible(true);
        this.sourceMessageTreeViewer = new MTATreeViewer(this.sourceMessageTree);
        String[] sourceColumns = new String[]{Modeling_Messages.COL_NAME, Modeling_Messages.COL_TYPE};
        String[] targetColumns = null;
        targetColumns = !this.simpleMode ? new String[]{Modeling_Messages.COL_NAME, Modeling_Messages.COL_TYPE, Modeling_Messages.COL_MAPPING, Modeling_Messages.COL_PROBLEMS} : new String[]{Modeling_Messages.COL_NAME, Modeling_Messages.COL_TYPE};
        int i = 0;
        while (i < sourceColumns.length) {
            TreeColumn column = new TreeColumn(this.sourceMessageTree, 16384);
            column.setText(sourceColumns[i]);
            if (i == 0) {
                column.setWidth(180);
            } else {
                column.setWidth(100);
            }
            ++i;
        }
        this.sourceHighlightViewerFilter = new SourceHighlightFilter(this.controller);
        this.sourceTextViewerFilter = new TextFilter(this.controller);
        this.sourceMessageTreeViewer.addFilter(this.sourceTextViewerFilter);
        this.sourceMessageTreeViewer.addFilter(this.sourceHighlightViewerFilter);
        this.sourceMessageTreeViewer.setUseHashlookup(true);
        this.sourceMessageTreeViewer.getTree().setLayoutData((Object)treeData);
        MenuManager menuMgr = new MenuManager();
        Tree tree = this.sourceMessageTreeViewer.getTree();
        Menu menu = menuMgr.createContextMenu((Control)tree);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (enableEditing && MessageTransformationApplicationControlsManager.this.controller.isDeleteSourceMessageAvailable()) {
                    DeleteSourceMessageAction deleteMessageAction = new DeleteSourceMessageAction(MessageTransformationApplicationControlsManager.this, MessageTransformationApplicationControlsManager.this.controller);
                    manager.add((IAction)deleteMessageAction);
                }
                if (MessageTransformationApplicationControlsManager.this.controller.isSimpleMode() && !MessageTransformationApplicationControlsManager.this.controller.isSerializable(MessageTransformationApplicationControlsManager.this.controller.getSelectedSourceField())) {
                    RenameMessageAction renameMessageAction = new RenameMessageAction(MessageTransformationApplicationControlsManager.this, MessageTransformationApplicationControlsManager.this.controller, true);
                    manager.add((IAction)renameMessageAction);
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
        this.sourceMessageTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                MessageTransformationApplicationControlsManager.this.controller.sourceMessageFieldSelected(selection);
                if (!MessageTransformationApplicationControlsManager.this.controller.isSimpleMode()) {
                    MessageTransformationApplicationControlsManager.this.sourceFieldText = MessageTransformationApplicationControlsManager.this.controller.getDraggedText();
                    MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.refreshVisibleItems();
                }
            }
        });
        this.sourceMessageTreeViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 && MessageTransformationApplicationControlsManager.this.controller.isRoot(MessageTransformationApplicationControlsManager.this.controller.getSelectedSourceField())) {
                    DeleteSourceMessageAction deleteMessageAction = new DeleteSourceMessageAction(MessageTransformationApplicationControlsManager.this, MessageTransformationApplicationControlsManager.this.controller);
                    deleteMessageAction.run();
                }
            }
        });
        this.targetMessageTree = new Tree((Composite)this.targetComposite, 67584){

            public void setEnabled(boolean enabled) {
                super.setEnabled(true);
            }

            protected void checkSubclass() {
            }
        };
        this.targetMessageTree.setLayoutData((Object)treeGridData);
        this.targetMessageTree.setHeaderVisible(true);
        this.targetMessageTreeViewer = new MTATreeViewer(this.targetMessageTree);
        int i2 = 0;
        while (i2 < targetColumns.length) {
            TreeColumn column = new TreeColumn(this.targetMessageTree, 16384);
            column.setText(targetColumns[i2]);
            if (i2 == 0) {
                column.setWidth(180);
            } else {
                column.setWidth(100);
            }
            ++i2;
        }
        this.targetMessageTreeViewer.setUseHashlookup(true);
        this.targetMessageTreeViewer.setColumnProperties(targetColumns);
        this.targetMessageTreeViewer.getTree().setLayoutData((Object)treeData);
        this.targetExpressionViewerFilter = new ExpressionFilter(this.controller);
        this.targetNoExpressionViewerFilter = new NoExpressionFilter(this.controller);
        this.targetHighlightViewerFilter = new TargetHighlightFilter(this.controller);
        this.targetTextViewerFilter = new TextFilter(this.controller);
        this.targetErrorViewerFilter = new ErrorFilter(this.controller);
        this.targetMessageTreeViewer.addFilter(this.targetExpressionViewerFilter);
        this.targetMessageTreeViewer.addFilter(this.targetNoExpressionViewerFilter);
        this.targetMessageTreeViewer.addFilter(this.targetHighlightViewerFilter);
        this.targetMessageTreeViewer.addFilter(this.targetTextViewerFilter);
        this.targetMessageTreeViewer.addFilter(this.targetErrorViewerFilter);
        this.targetMessageTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MessageTransformationApplicationControlsManager.this.controller.ignoreUpcomingAnnotationChanges();
                TreeSelection selection = (TreeSelection)event.getSelection();
                boolean refreshDocument = MessageTransformationApplicationControlsManager.this.controller.targetMessageFieldSelected(selection);
                if (!MessageTransformationApplicationControlsManager.this.controller.isSimpleMode()) {
                    if (MessageTransformationApplicationControlsManager.this.controller.getSelectedTargetField() != null) {
                        MessageTransformationApplicationControlsManager.this.expressionsEditor.getAdaptedSourceViewer().setEditable(!MessageTransformationApplicationControlsManager.this.controller.isRoot(MessageTransformationApplicationControlsManager.this.controller.getSelectedTargetField()) || MessageTransformationApplicationControlsManager.this.controller.isPrimitive(MessageTransformationApplicationControlsManager.this.controller.getSelectedTargetField()));
                        String targetXPath = MessageTransformationApplicationControlsManager.this.controller.getXPathFor(MessageTransformationApplicationControlsManager.this.controller.getSelectedTargetField());
                        if (targetXPath != null) {
                            MessageTransformationApplicationControlsManager.this.lblExpressionPrefix.setText(String.valueOf(targetXPath.replaceAll("/", ".")) + " =");
                        } else {
                            MessageTransformationApplicationControlsManager.this.lblExpressionPrefix.setText("");
                        }
                    } else {
                        MessageTransformationApplicationControlsManager.this.expressionsEditor.getAdaptedSourceViewer().setEditable(false);
                    }
                    MessageTransformationApplicationControlsManager.this.updateMappingHeaderSection();
                    if (refreshDocument) {
                        MessageTransformationApplicationControlsManager.this.refreshDocument();
                    }
                    MessageTransformationApplicationControlsManager.this.sourceMessageTreeViewer.refreshVisibleItems();
                }
            }
        });
        this.targetMessageTreeViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 && MessageTransformationApplicationControlsManager.this.controller.isRoot(MessageTransformationApplicationControlsManager.this.controller.getSelectedTargetField())) {
                    DeleteTargetMessageAction deleteMessageAction = new DeleteTargetMessageAction(MessageTransformationApplicationControlsManager.this, MessageTransformationApplicationControlsManager.this.controller);
                    deleteMessageAction.run();
                }
            }
        });
        menuMgr = new MenuManager();
        tree = this.targetMessageTreeViewer.getTree();
        menu = menuMgr.createContextMenu((Control)tree);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MessageTransformationApplicationControlsManager.this.controller.getSelectedTargetField();
                if (MessageTransformationApplicationControlsManager.this.controller.isToggleBreakpointAvailable() && !MessageTransformationApplicationControlsManager.this.controller.isDeleteTargetMessageAvailable()) {
                    ToggleMappingBreakpointAction action = new ToggleMappingBreakpointAction(MessageTransformationApplicationControlsManager.this, MessageTransformationApplicationControlsManager.this.controller);
                    manager.add((IAction)action);
                }
                if (enableEditing) {
                    if (MessageTransformationApplicationControlsManager.this.controller.isDeleteTargetMessageAvailable()) {
                        DeleteTargetMessageAction deleteMessageAction = new DeleteTargetMessageAction(MessageTransformationApplicationControlsManager.this, MessageTransformationApplicationControlsManager.this.controller);
                        manager.add((IAction)deleteMessageAction);
                    }
                    if (MessageTransformationApplicationControlsManager.this.controller.isClearMappingExpressionAvailable()) {
                        ClearMappingExpressionAction deleteMappingExpressionAction = new ClearMappingExpressionAction(MessageTransformationApplicationControlsManager.this, MessageTransformationApplicationControlsManager.this.controller);
                        manager.add((IAction)deleteMappingExpressionAction);
                    }
                    if (MessageTransformationApplicationControlsManager.this.controller.isClearMappingStatementAvailable()) {
                        ClearMappingStatementAction deleteMappingStatementAction = new ClearMappingStatementAction(MessageTransformationApplicationControlsManager.this, MessageTransformationApplicationControlsManager.this.controller);
                        manager.add((IAction)deleteMappingStatementAction);
                    }
                }
                if (MessageTransformationApplicationControlsManager.this.controller.isSimpleMode() && !MessageTransformationApplicationControlsManager.this.controller.isSerializable(MessageTransformationApplicationControlsManager.this.controller.getSelectedTargetField())) {
                    RenameMessageAction renameMessageAction = new RenameMessageAction(MessageTransformationApplicationControlsManager.this, MessageTransformationApplicationControlsManager.this.controller, false);
                    manager.add((IAction)renameMessageAction);
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
        this.groupingCheckbox = FormBuilder.createCheckBox((Composite)ioComposite, (String)Diagram_Messages.LB_GroupModelElements);
        this.groupingCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MessageTransformationApplicationControlsManager.this.sourceLabelProvider.setShowGroupInfo(MessageTransformationApplicationControlsManager.this.groupingCheckbox.getSelection());
                MessageTransformationApplicationControlsManager.this.targetLabelProvider.setShowGroupInfo(MessageTransformationApplicationControlsManager.this.groupingCheckbox.getSelection());
                MessageTransformationApplicationControlsManager.this.refModelSorter.setGrouped(MessageTransformationApplicationControlsManager.this.groupingCheckbox.getSelection());
                if (MessageTransformationApplicationControlsManager.this.groupingCheckbox.getSelection()) {
                    MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.setSorter((ViewerSorter)MessageTransformationApplicationControlsManager.this.refModelSorter);
                    MessageTransformationApplicationControlsManager.this.sourceMessageTreeViewer.setSorter((ViewerSorter)MessageTransformationApplicationControlsManager.this.refModelSorter);
                } else {
                    MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.setSorter(null);
                    MessageTransformationApplicationControlsManager.this.sourceMessageTreeViewer.setSorter(null);
                }
                MessageTransformationApplicationControlsManager.this.sourceMessageTreeViewer.refresh();
                MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.refresh();
                MessageTransformationApplicationControlsManager.this.refreshDocument();
            }
        });
    }

    private void createEditorComposite(final IModelElement modelElement, boolean enableEditing) {
        this.expressionComposite = new Group((Composite)this.sashForm, 0);
        GridLayout expressionLayout = new GridLayout();
        expressionLayout.numColumns = 2;
        this.expressionComposite.setLayout((Layout)expressionLayout);
        GridData expressionData = new GridData();
        expressionData.grabExcessHorizontalSpace = true;
        expressionData.grabExcessVerticalSpace = true;
        expressionData.horizontalAlignment = 4;
        expressionData.verticalAlignment = 4;
        expressionData.horizontalSpan = 2;
        this.expressionComposite.setLayoutData((Object)expressionData);
        this.expressionComposite.setText(Modeling_Messages.TXT_MAPPING_EXP);
        Composite buttonComposite = new Composite((Composite)this.expressionComposite, 0);
        GridLayout bcLayout = new GridLayout();
        bcLayout.numColumns = 2;
        bcLayout.marginHeight = 0;
        bcLayout.marginBottom = 0;
        bcLayout.marginTop = 5;
        bcLayout.marginLeft = 5;
        bcLayout.verticalSpacing = 0;
        buttonComposite.setLayout((Layout)bcLayout);
        GridData bcData = new GridData();
        bcData.grabExcessHorizontalSpace = true;
        bcData.horizontalAlignment = 4;
        bcData.horizontalSpan = 2;
        buttonComposite.setLayoutData((Object)bcData);
        this.btnToggleMappingStyle = new Button(buttonComposite, 32);
        this.btnToggleMappingStyle.setText(Modeling_Messages.TXT_ADVANCED_MAPPING);
        this.btnAddExternalClass = new Button(buttonComposite, 8);
        this.btnAddExternalClass.setText(Modeling_Messages.TXT_EXTERNAL_CL);
        this.btnAddExternalClass.setEnabled(enableEditing);
        GridData gData = FormBuilder.createDefaultButtonGridData();
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        gData.horizontalAlignment = 4;
        gData.verticalAlignment = 4;
        gData = FormBuilder.createDefaultButtonGridData();
        this.btnAddExternalClass.setLayoutData((Object)gData);
        gData.grabExcessVerticalSpace = true;
        gData.verticalAlignment = 4;
        gData.minimumHeight = 22;
        this.btnToggleMappingStyle.setLayoutData((Object)gData);
        this.lblExpressionPrefix = FormBuilder.createLabel((Composite)this.expressionComposite, (String)"", (int)1);
        this.btnAddExternalClass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalClassesConfigurationDialog dialog = new ExternalClassesConfigurationDialog(Display.getCurrent().getActiveShell(), MessageTransformationApplicationControlsManager.this.controller, MessageTransformationApplicationControlsManager.this.controller.getExternalClassTypes(), "", DirectionType.IN_LITERAL);
                if (dialog.open() == 0) {
                    MessageTransformationApplicationControlsManager.this.refreshModel();
                    MessageTransformationApplicationControlsManager.this.refreshDocument();
                    MessageTransformationApplicationControlsManager.this.controller.refreshJavaScriptContext();
                    MessageTransformationApplicationControlsManager.this.controller.initializeMappings(modelElement);
                }
            }
        });
        this.btnToggleMappingStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageTransformationApplicationControlsManager.this.controller.isBasicTargetFieldMapping()) {
                    MessageTransformationApplicationControlsManager.this.controller.setBasicTargetFieldMapping(false);
                } else {
                    MessageTransformationApplicationControlsManager.this.controller.setBasicTargetFieldMapping(true);
                }
                MessageTransformationApplicationControlsManager.this.updateMappingHeaderSection();
            }
        });
        this.btnToggleMappingStyle.setEnabled(enableEditing);
        this.updateMappingHeaderSection();
        WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IEditorSite editorSite = editor.getEditorSite();
        EditorUtils.deleteFileStructure((IProject)this.project, (ModelType)this.model);
        try {
            EditorUtils.addJSSupport((IProject)this.project, (ModelType)this.model);
        }
        catch (CoreException coreException) {}
        this.expressionsEditor = new JSCompilationUnitEditor();
        MessagingJavaCodeScanner codeScanner = new MessagingJavaCodeScanner(this.expressionsEditor.getUsableColorManager(), this.expressionsEditor.getUsablePreferenceStore(), this.controller);
        this.expressionsEditor = new JSCompilationUnitEditor((AbstractJavaScanner)codeScanner);
        this.expressionsEditor.setTheSite((IWorkbenchPartSite)editorSite);
        if (this.project != null) {
            this.controller.initilizeValidator(this.project);
            this.tempFileResource = EditorUtils.createFileStructure((IProject)this.project, (ModelType)this.model, (String)"expressions.js");
            this.expressionsEditor.setInput((IEditorInput)new FileEditorInput(this.tempFileResource));
        } else {
            this.expressionsEditor.setInput(new IEditorInput(){

                public boolean exists() {
                    return false;
                }

                public ImageDescriptor getImageDescriptor() {
                    return null;
                }

                public String getName() {
                    return null;
                }

                public IPersistableElement getPersistable() {
                    return null;
                }

                public String getToolTipText() {
                    return null;
                }

                public Object getAdapter(Class adapter) {
                    return null;
                }
            });
        }
        Composite sourceViewerComposite = new Composite((Composite)this.expressionComposite, 0);
        this.svcData = new GridData();
        this.svcData.grabExcessHorizontalSpace = true;
        this.svcData.grabExcessVerticalSpace = true;
        this.svcData.horizontalSpan = 2;
        this.svcData.horizontalAlignment = 4;
        this.svcData.verticalAlignment = 4;
        sourceViewerComposite.setLayout((Layout)new FillLayout());
        sourceViewerComposite.setLayoutData((Object)this.svcData);
        this.expressionsEditor.createPartControl(sourceViewerComposite);
        this.expressionsEditor.getAdaptedSourceViewer().getTextWidget().setText("");
        this.expressionsEditor.getAdaptedSourceViewer().getTextWidget().addKeyListener((KeyListener)this);
        this.expressionsEditor.getAdaptedSourceViewer().setEditable(enableEditing);
        this.expressionsEditor.getAdaptedSourceViewer().getAnnotationModel().addAnnotationModelListener((IAnnotationModelListener)this);
        this.expressionsEditor.getAdaptedSourceViewer().addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (MessageTransformationApplicationControlsManager.this.controller.getDraggedText() != null && event.getText() != null && event.getText().equalsIgnoreCase(MessageTransformationApplicationControlsManager.this.controller.getDraggedText())) {
                    MessageTransformationApplicationControlsManager.this.controller.updateExpressions(MessageTransformationApplicationControlsManager.this.expressionsEditor.getAdaptedSourceViewer().getTextWidget().getText());
                    MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.refreshVisibleItems();
                }
            }
        });
        if (enableEditing) {
            int operations = 3;
            DragSource sourceDragSource = new DragSource(this.sourceMessageTreeViewer.getControl(), operations);
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            sourceDragSource.setTransfer(types);
            sourceDragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

                public void dragSetData(DragSourceEvent event) {
                    try {
                        event.data = MessageTransformationApplicationControlsManager.this.controller.getDraggedText();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
            DropTarget editorTarget = new DropTarget((Control)this.expressionsEditor.getAdaptedSourceViewer().getTextWidget(), 19);
            editorTarget.setTransfer(types);
            editorTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                public void dragEnter(DropTargetEvent event) {
                    if (event.detail == 16) {
                        event.detail = (event.operations & 1) != 0 ? 1 : 0;
                    }
                    int i = 0;
                    int n = event.dataTypes.length;
                    while (i < n) {
                        if (TextTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                            event.currentDataType = event.dataTypes[i];
                        }
                        ++i;
                    }
                }

                public void dragOver(DropTargetEvent event) {
                    event.feedback = 9;
                }

                public void drop(DropTargetEvent event) {
                    AccessPointType selectedTarget;
                    if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && event.data != null && (selectedTarget = MessageTransformationApplicationControlsManager.this.controller.getSelectedTargetField()) != null && !MessageTransformationApplicationControlsManager.this.controller.isRoot(selectedTarget)) {
                        String textToDrop = event.data.toString();
                        MessageTransformationApplicationControlsManager.this.expressionsEditor.getAdaptedSourceViewer().getTextWidget().insert(" " + textToDrop + " ");
                        MessageTransformationApplicationControlsManager.this.controller.updateExpressions(MessageTransformationApplicationControlsManager.this.expressionsEditor.getAdaptedSourceViewer().getTextWidget().getText());
                        MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.refreshVisibleItems();
                    }
                }
            });
        }
    }

    public JSCompilationUnitEditor getExpressionsEditor() {
        return this.expressionsEditor;
    }

    public TreeViewer getSourceMessageTreeViewer() {
        return this.sourceMessageTreeViewer;
    }

    public TreeViewer getTargetMessageTreeViewer() {
        return this.targetMessageTreeViewer;
    }

    public MessageTransformationController getController() {
        return this.controller;
    }

    @Override
    public IFile getWorkingResource() {
        URI eUri;
        Resource eResource;
        if (this.model != null && (eResource = this.model.eResource()) != null && (eUri = eResource.getURI()).segmentCount() > 1) {
            String[] segments = new String[eUri.segmentCount() - 1];
            System.arraycopy(eUri.segments(), 1, segments, 0, segments.length);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(StringUtils.join(Arrays.asList(segments).iterator(), (String)"/"));
            if (resource instanceof IFile) {
                return (IFile)resource;
            }
        }
        return null;
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent arg0) {
        if (arg0.getSource().equals(this.expressionsEditor.getAdaptedSourceViewer().getTextWidget())) {
            this.controller.updateExpressions(this.expressionsEditor.getAdaptedSourceViewer().getTextWidget().getText());
            this.targetMessageTreeViewer.refreshVisibleItems();
        }
    }

    protected void buttonEnablement() {
        this.targetNoExpressionFilter.setSelection(this.targetNoExpression);
        this.targetExpressionFilter.setSelection(this.targetExpression);
        this.targetHighlightedFilter.setSelection(this.targetHighlight);
        this.sourceHighlightedFilter.setSelection(this.sourceHighlight);
        if (this.targetHighlight) {
            this.targetHighlightedFilter.setImage(MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/bulp_on.PNG").createImage());
        } else {
            this.targetHighlightedFilter.setImage(MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/bulp_off.PNG").createImage());
        }
        if (this.sourceHighlight) {
            this.sourceHighlightedFilter.setImage(MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/bulp_on.PNG").createImage());
        } else {
            this.sourceHighlightedFilter.setImage(MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/bulp_off.PNG").createImage());
        }
        this.targetHighlightedFilter.redraw();
        this.targetNoExpressionViewerFilter.setActive(this.targetNoExpression && !this.targetExpression);
        this.targetExpressionViewerFilter.setActive(!this.targetNoExpression && this.targetExpression);
        this.targetHighlightViewerFilter.setActive(this.targetHighlight);
        this.sourceHighlightViewerFilter.setActive(this.sourceHighlight);
        this.targetErrorViewerFilter.setActive(this.targetError);
        this.targetMessageTreeViewer.refresh();
        this.sourceMessageTreeViewer.refresh();
        if (this.targetNoExpression || this.targetExpression || this.targetHighlight || this.targetError) {
            this.targetMessageTreeViewer.expandAll();
        }
        if (this.sourceHighlight) {
            this.sourceMessageTreeViewer.expandAll();
        }
    }

    @Override
    public void refreshModel() {
        MultipleAccessPathBrowserContentProvider provider = new MultipleAccessPathBrowserContentProvider(DirectionType.INOUT_LITERAL, this.controller);
        this.sourceMessageTreeViewer.setContentProvider((IContentProvider)provider);
        this.sourceMessageTreeViewer.setLabelProvider((IBaseLabelProvider)this.sourceLabelProvider);
        this.sourceMessageTreeViewer.setComparer(new MessageTypeComparer());
        this.refModelSorter.setModel(this.model);
        this.sourceMessageTreeViewer.setInput(this.controller.getSourceMessageTypes());
        this.controller.setSourceAPB(provider);
        provider = new MultipleAccessPathBrowserContentProvider(DirectionType.INOUT_LITERAL, this.controller);
        this.targetMessageTreeViewer.setContentProvider((IContentProvider)provider);
        this.targetMessageTreeViewer.setLabelProvider((IBaseLabelProvider)this.targetLabelProvider);
        this.targetMessageTreeViewer.setComparer(new MessageTypeComparer());
        this.targetMessageTreeViewer.setInput(this.controller.getTargetMessageTypes());
        this.controller.setTargetAPB(provider);
        this.sourceMessageTreeViewer.refreshVisibleItems();
        this.targetMessageTreeViewer.refreshVisibleItems();
    }

    public TreeItem getRootTreeItem(TreeItem treeItem) {
        if (treeItem.getParentItem() != null) {
            return this.getRootTreeItem(treeItem.getParentItem());
        }
        return treeItem;
    }

    @Override
    public void refreshDocument() {
        if (this.simpleMode) {
            return;
        }
        IDocument document = this.expressionsEditor.getAdaptedSourceViewer().getDocument();
        if (document != null) {
            document.set(this.controller.getMasterDocument());
            this.controller.recalculateRegions(document);
        }
        MessageTransformationApplicationControlsManager.setVisibleRegion(this.expressionsEditor, this.controller.getExpressionRegion());
        this.targetMessageTreeViewer.refreshVisibleItems();
        this.sourceMessageTreeViewer.refreshVisibleItems();
    }

    private void createFilterComposites() {
        this.sourceFilterComposite = new Composite((Composite)this.sourceComposite, 0);
        GridLayout sourceFilterComposioteLayout = new GridLayout();
        sourceFilterComposioteLayout.marginWidth = 0;
        sourceFilterComposioteLayout.marginHeight = 0;
        sourceFilterComposioteLayout.numColumns = 2;
        GridData sourceFilterCompositeData = new GridData();
        sourceFilterCompositeData.grabExcessHorizontalSpace = true;
        sourceFilterCompositeData.horizontalAlignment = 4;
        sourceFilterCompositeData.horizontalSpan = 2;
        this.sourceFilterComposite.setLayout((Layout)sourceFilterComposioteLayout);
        this.sourceFilterComposite.setLayoutData((Object)sourceFilterCompositeData);
        this.targetFilterComposite = new Composite((Composite)this.targetComposite, 0);
        GridLayout targetFilterComposioteLayout = new GridLayout();
        targetFilterComposioteLayout.marginWidth = 0;
        targetFilterComposioteLayout.marginHeight = 0;
        targetFilterComposioteLayout.numColumns = 2;
        GridData targetFilterCompositeData = new GridData();
        targetFilterCompositeData.grabExcessHorizontalSpace = true;
        targetFilterCompositeData.horizontalAlignment = 4;
        targetFilterCompositeData.horizontalSpan = 2;
        this.targetFilterComposite.setLayout((Layout)targetFilterComposioteLayout);
        this.targetFilterComposite.setLayoutData((Object)targetFilterCompositeData);
        if (!this.simpleMode) {
            this.sourceFilterButtonComposite = new Composite(this.sourceFilterComposite, 0);
            RowLayout sourceFilterButtonCompositeLayout = new RowLayout();
            RowData rowData = new RowData();
            rowData.height = 21;
            rowData.width = 21;
            this.sourceFilterButtonComposite.setLayout((Layout)sourceFilterButtonCompositeLayout);
            this.sourceHighlightedFilter = new Button(this.sourceFilterButtonComposite, 2);
            this.sourceHighlightedFilter.setImage(MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/bulp_off.PNG").createImage());
            this.sourceHighlightedFilter.setToolTipText(Modeling_Messages.TXT__SH_HIGHLIGTED_FIELDS_ONLY);
            this.sourceHighlightedFilter.setLayoutData((Object)rowData);
            this.sourceHighlightedFilter.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MessageTransformationApplicationControlsManager.this.sourceHighlight = !MessageTransformationApplicationControlsManager.this.sourceHighlight;
                    MessageTransformationApplicationControlsManager.this.buttonEnablement();
                }
            });
            this.targetFilterButtonComposite = new Composite(this.targetFilterComposite, 0);
            RowLayout targetFilterButtonCompositeLayout = new RowLayout();
            this.targetFilterButtonComposite.setLayout((Layout)targetFilterButtonCompositeLayout);
            this.targetExpressionFilter = new Button(this.targetFilterButtonComposite, 2);
            this.targetExpressionFilter.setToolTipText(Modeling_Messages.TXT_SH_FIELD_MAPPING_EXP_ONLY);
            this.targetExpressionFilter.setImage(MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/mapping.JPG").createImage());
            this.targetExpressionFilter.setLayoutData((Object)rowData);
            this.targetExpressionFilter.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MessageTransformationApplicationControlsManager.this.targetExpression = !MessageTransformationApplicationControlsManager.this.targetExpression;
                    MessageTransformationApplicationControlsManager.this.targetNoExpression = false;
                    MessageTransformationApplicationControlsManager.this.buttonEnablement();
                }
            });
            this.targetNoExpressionFilter = new Button(this.targetFilterButtonComposite, 2);
            this.targetNoExpressionFilter.setLayoutData((Object)rowData);
            this.targetNoExpressionFilter.setToolTipText(Modeling_Messages.TXT_SH_FIELDS_NO_MAPPING_EXP_ONLY);
            this.targetNoExpressionFilter.setImage(MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/nomapping.JPG").createImage());
            this.targetNoExpressionFilter.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MessageTransformationApplicationControlsManager.this.targetNoExpression = !MessageTransformationApplicationControlsManager.this.targetNoExpression;
                    MessageTransformationApplicationControlsManager.this.targetExpression = false;
                    MessageTransformationApplicationControlsManager.this.buttonEnablement();
                }
            });
            this.targetHighlightedFilter = new Button(this.targetFilterButtonComposite, 2);
            this.targetHighlightedFilter.setLayoutData((Object)rowData);
            this.targetHighlightedFilter.setImage(MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/bulp_off.PNG").createImage());
            this.targetHighlightedFilter.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MessageTransformationApplicationControlsManager.this.targetHighlight = !MessageTransformationApplicationControlsManager.this.targetHighlight;
                    MessageTransformationApplicationControlsManager.this.buttonEnablement();
                }
            });
            this.targetHighlightedFilter.setToolTipText(Modeling_Messages.TXT__SH_HIGHLIGTED_FIELDS_ONLY);
            this.targetHighlightedFilter.setLayoutData((Object)rowData);
            Button targetErrorFilter = new Button(this.targetFilterButtonComposite, 2);
            targetErrorFilter.setLayoutData((Object)rowData);
            targetErrorFilter.setToolTipText(Modeling_Messages.TXT_SH_FIELDS_MAPPING_EXP_INVALID);
            targetErrorFilter.setImage(MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/error.gif").createImage());
            targetErrorFilter.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MessageTransformationApplicationControlsManager.this.targetError = !MessageTransformationApplicationControlsManager.this.targetError;
                    MessageTransformationApplicationControlsManager.this.buttonEnablement();
                }
            });
        }
        this.sourceFilterText = new Text(this.sourceFilterComposite, 2048);
        GridData textFilterData = new GridData();
        textFilterData.grabExcessHorizontalSpace = true;
        textFilterData.horizontalAlignment = 4;
        this.sourceFilterText.setLayoutData((Object)textFilterData);
        this.sourceFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = MessageTransformationApplicationControlsManager.this.sourceFilterText.getText();
                if (text != null && text != "" && !text.startsWith(" ")) {
                    MessageTransformationApplicationControlsManager.this.sourceTextViewerFilter.setActive(true);
                    MessageTransformationApplicationControlsManager.this.sourceTextViewerFilter.setText(text);
                } else {
                    MessageTransformationApplicationControlsManager.this.sourceTextViewerFilter.setActive(false);
                }
                MessageTransformationApplicationControlsManager.this.sourceMessageTreeViewer.refresh();
            }
        });
        this.targetFilterText = new Text(this.targetFilterComposite, 2048);
        this.targetFilterText.setLayoutData((Object)textFilterData);
        this.targetFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = MessageTransformationApplicationControlsManager.this.targetFilterText.getText();
                if (text != null && text != "" && !text.startsWith(" ")) {
                    MessageTransformationApplicationControlsManager.this.targetTextViewerFilter.setActive(true);
                    MessageTransformationApplicationControlsManager.this.targetTextViewerFilter.setText(text);
                } else {
                    MessageTransformationApplicationControlsManager.this.targetTextViewerFilter.setActive(false);
                }
                MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.refresh();
            }
        });
    }

    protected void updateMappingHeaderSection() {
        if (this.controller.isBasicTargetFieldMapping()) {
            this.lblExpressionPrefix.setVisible(true);
            this.btnToggleMappingStyle.setSelection(false);
            ((GridData)this.lblExpressionPrefix.getLayoutData()).heightHint = this.lblExpressionPrefix.computeSize((int)-1, (int)-1).y;
        } else {
            this.lblExpressionPrefix.setVisible(false);
            this.btnToggleMappingStyle.setSelection(true);
            ((GridData)this.lblExpressionPrefix.getLayoutData()).heightHint = 0;
        }
        ((GridData)this.btnToggleMappingStyle.getLayoutData()).widthHint = this.btnToggleMappingStyle.computeSize((int)-1, (int)-1).x;
        this.sashForm.layout(true, true);
    }

    private void createToolTipListener() {
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TreeItem)label.getData("_TABLEITEM");
                        MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.getTree().setSelection(new TreeItem[]{(TreeItem)e.item});
                        MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.getTree().notifyListeners(13, e);
                        shell.dispose();
                        MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.getTree().setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener treeListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                block0 : switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        Point coords = new Point(event.x, event.y);
                        TreeItem item = MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.getTree().getItem(coords);
                        if (item == null) break;
                        int columns = MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.getTree().getColumnCount();
                        int i = 0;
                        while (i < columns || i == 0) {
                            if (item.getBounds(i).contains(coords)) {
                                if (this.tip != null && !this.tip.isDisposed()) {
                                    this.tip.dispose();
                                }
                                this.tip = new Shell(MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.getTree().getShell(), 540676);
                                this.tip.setBackground(MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.getTree().getDisplay().getSystemColor(29));
                                FillLayout layout = new FillLayout();
                                layout.marginWidth = 2;
                                this.tip.setLayout((Layout)layout);
                                this.label = new Label((Composite)this.tip, 0);
                                this.label.setForeground(MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.getTree().getDisplay().getSystemColor(28));
                                this.label.setBackground(MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.getTree().getDisplay().getSystemColor(29));
                                this.label.setData(Modeling_Messages.LBL_TABLEITEM, (Object)item);
                                String text = MessageTransformationApplicationControlsManager.this.controller.getToolTip(item, i);
                                if (text == null) break block0;
                                this.label.setText(text);
                                this.label.addListener(7, labelListener);
                                this.label.addListener(3, labelListener);
                                Point size = this.tip.computeSize(-1, -1);
                                Rectangle rect = item.getBounds(i);
                                Point pt = MessageTransformationApplicationControlsManager.this.targetMessageTreeViewer.getTree().toDisplay(rect.x, rect.y);
                                this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                                this.tip.setVisible(true);
                                break block0;
                            }
                            ++i;
                        }
                        break;
                    }
                }
            }
        };
        this.targetMessageTreeViewer.getTree().addListener(12, treeListener);
        this.targetMessageTreeViewer.getTree().addListener(1, treeListener);
        this.targetMessageTreeViewer.getTree().addListener(5, treeListener);
        this.targetMessageTreeViewer.getTree().addListener(32, treeListener);
    }

    private static void setVisibleRegion(JSCompilationUnitEditor editor, JSCompilationUnitEditor.RegionWithLineOffset region) {
        if (region != null) {
            editor.getAdaptedSourceViewer().setVisibleRegion(region.getOffset(), region.getLength());
            editor.setLineOffset(region.getLineOffset());
        }
    }

    public void dispose() {
        if (!this.controller.isSimpleMode()) {
            EditorUtils.deleteFileStructure((IProject)this.project, (ModelType)this.model);
        }
    }

    public void modelChanged(IAnnotationModel model) {
        Iterator i = model.getAnnotationIterator();
        while (i.hasNext()) {
            try {
                Object type;
                Object message;
                Object problem;
                Object annotation = i.next();
                if (Reflect.getField(annotation.getClass(), (String)"fProblem") != null && (problem = Reflect.getFieldValue(annotation, (String)"fProblem")) != null && Reflect.getField(problem.getClass(), (String)"message") != null && (message = Reflect.getFieldValue((Object)problem, (String)"message")) != null && message.toString().indexOf("resolved") > 0) {
                    this.fixAnnotationImage(annotation);
                    break;
                }
                if (Reflect.getField(annotation.getClass(), (String)"fType") == null || (type = Reflect.getFieldValue(annotation, (String)"fType")) == null || type.toString().equalsIgnoreCase("org.eclipse.wst.jsdt.ui.warning")) continue;
                this.fixAnnotationImage(annotation);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void fixAnnotationImage(Object annotation) {
        if (Reflect.getField(annotation.getClass(), (String)"fImage") != null) {
            Reflect.setFieldValue((Object)annotation, (String)"fImage", (Object)errorImage);
        }
    }

    public void setExternalReference(boolean externalReference) {
        this.externalReference = externalReference;
    }
}

