/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.TypeSelectionComposite;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.filtering.XPathFilter;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.DelegatingIndexingLabelProvider;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MTATreeViewer;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MappingConfiguration;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MessageTypeComparer;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MultipleAccessPathBrowserContentProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class IndexConfigurationDialog
extends Dialog
implements ModifyListener {
    private static final int RESET_ID = 22;
    private Text messageNameText;
    private String tagName;
    private ComboViewer messageComboViewer;
    private MessageTransformationController controller;
    private AccessPointType messageType;
    private String messageName;
    private List messageTypes;
    private String preset;
    private List allMessageTypes = new ArrayList();
    private List typeFilters = new ArrayList();
    private List<AccessPointType> inputModel = new ArrayList<AccessPointType>();
    private List<AccessPointType> outputModel = new ArrayList<AccessPointType>();
    public static final String[] PROPS = new String[]{Modeling_Messages.COL_NAME, Modeling_Messages.COL_INDEX};
    private Combo messageCombo;
    private Label errorLabel;
    private WorkflowModelEditor wfme;
    private Composite mainComposite;
    private boolean isError = false;
    private Combo dataTypeCombo;
    private ComboViewer dataTypeComboViewer;
    private Label structLabel;
    private TypeSelectionComposite classBrowser;
    private StackLayout stack;
    private Composite structPrimComposite;
    private Composite classBrowseComposite;
    private Group messageComposite;
    protected ViewerFilter selectedFilter;
    private Group sourceComposite;
    private Group targetComposite;
    private Tree sourceMessageTree;
    private MTATreeViewer sourceMessageTreeViewer;
    private Tree targetMessageTree;
    private MTATreeViewer targetMessageTreeViewer;
    private Map<String, String> indexMap = new HashMap<String, String>();
    private XPathFilter sourceXPathViewerFilter;
    private XPathFilter targetXPathViewerFilter;
    private AccessPointType source;
    private AccessPointType target;
    private boolean showInvolvedOnly = true;
    private MappingConfiguration config;
    private Button appendButton;
    private Button overwriteButton;
    private boolean canceled;
    private MultipleAccessPathBrowserContentProvider sourceProvider;
    private MultipleAccessPathBrowserContentProvider targetProvider;

    protected void cancelPressed() {
        this.canceled = true;
        super.cancelPressed();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public IndexConfigurationDialog(Shell parentShell, MessageTransformationController controller, MappingConfiguration config) {
        super(parentShell);
        this.setShellStyle(67696);
        this.controller = controller;
        this.inputModel.addAll(controller.getSourceMessageTypes());
        this.outputModel.addAll(controller.getTargetMessageTypes());
        this.source = config.getSourceType();
        this.target = config.getTargetType();
        this.config = config;
    }

    public Map<String, String> getIndexMap() {
        return this.indexMap;
    }

    protected Control createDialogArea(Composite parent) {
        IEditorPart currentEditor;
        this.mainComposite = parent;
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (currentEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) instanceof WorkflowModelEditor) {
            this.wfme = (WorkflowModelEditor)currentEditor;
        }
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.numColumns = 3;
        Group tableComposite = new Group(comp, 0);
        tableComposite.setText(Modeling_Messages.TXT_INDEX_CFG);
        GridLayout tableCompLayout = new GridLayout();
        tableCompLayout.numColumns = 2;
        tableComposite.setLayout((Layout)tableCompLayout);
        GridData tableCompGridData = new GridData();
        tableCompGridData.grabExcessHorizontalSpace = true;
        tableCompGridData.grabExcessVerticalSpace = true;
        tableCompGridData.horizontalAlignment = 4;
        tableCompGridData.verticalAlignment = 4;
        tableCompGridData.horizontalSpan = 3;
        tableComposite.setLayoutData((Object)tableCompGridData);
        GridLayout fillLayout = new GridLayout();
        this.sourceComposite = new Group((Composite)tableComposite, 0);
        GridData messageData = new GridData();
        messageData.grabExcessHorizontalSpace = true;
        messageData.grabExcessVerticalSpace = true;
        messageData.horizontalAlignment = 4;
        messageData.verticalAlignment = 4;
        this.sourceComposite.setLayoutData((Object)messageData);
        this.sourceComposite.setText(MessageFormat.format(Modeling_Messages.TXT_SR, this.controller.getNameString()));
        this.sourceComposite.setLayout((Layout)fillLayout);
        this.targetComposite = new Group((Composite)tableComposite, 0);
        this.targetComposite.setLayout((Layout)fillLayout);
        this.targetComposite.setLayoutData((Object)messageData);
        this.targetComposite.setText(MessageFormat.format(Modeling_Messages.TXT_TARGET, this.controller.getNameString()));
        GridData treeData = new GridData();
        treeData.grabExcessHorizontalSpace = true;
        treeData.grabExcessVerticalSpace = true;
        treeData.horizontalAlignment = 4;
        treeData.verticalAlignment = 4;
        treeData.horizontalSpan = 2;
        Button showAllButton = new Button((Composite)tableComposite, 32);
        showAllButton.setText(Modeling_Messages.TXT_SH_AFFECTED_TREE_PATH_ONLY);
        showAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IndexConfigurationDialog.this.showInvolvedOnly = !IndexConfigurationDialog.this.showInvolvedOnly;
                IndexConfigurationDialog.this.sourceXPathViewerFilter.setActive(IndexConfigurationDialog.this.showInvolvedOnly);
                IndexConfigurationDialog.this.targetXPathViewerFilter.setActive(IndexConfigurationDialog.this.showInvolvedOnly);
                IndexConfigurationDialog.this.refreshModel();
            }
        });
        this.sourceMessageTree = new Tree((Composite)this.sourceComposite, 67586);
        GridData treeGridData = new GridData();
        treeGridData.grabExcessVerticalSpace = true;
        treeGridData.verticalAlignment = 4;
        this.sourceMessageTree.setLayoutData((Object)treeGridData);
        this.sourceMessageTree.setHeaderVisible(true);
        this.sourceMessageTreeViewer = new MTATreeViewer(this.sourceMessageTree);
        String[] sourceColumns = new String[]{Modeling_Messages.COL_NAME, Modeling_Messages.COL_INDEX};
        String[] targetColumns = new String[]{Modeling_Messages.COL_NAME, Modeling_Messages.COL_INDEX};
        int i = 0;
        while (i < sourceColumns.length) {
            TreeColumn column = new TreeColumn(this.sourceMessageTree, 16384);
            column.setText(sourceColumns[i]);
            if (i == 0) {
                column.setWidth(180);
            } else {
                column.setWidth(100);
            }
            ++i;
        }
        CellEditor[] editors = new CellEditor[]{null, new TextCellEditor((Composite)this.sourceMessageTreeViewer.getTree())};
        this.sourceMessageTreeViewer.setColumnProperties(PROPS);
        this.sourceMessageTreeViewer.setCellModifier(new IndexCellModifier((Viewer)this.sourceMessageTreeViewer));
        this.sourceMessageTreeViewer.setCellEditors(editors);
        this.sourceMessageTreeViewer.setUseHashlookup(true);
        this.sourceMessageTreeViewer.getTree().setLayoutData((Object)treeData);
        this.targetMessageTree = new Tree((Composite)this.targetComposite, 67584);
        this.targetMessageTree.setLayoutData((Object)treeGridData);
        this.targetMessageTree.setHeaderVisible(true);
        this.targetMessageTreeViewer = new MTATreeViewer(this.targetMessageTree);
        int i2 = 0;
        while (i2 < targetColumns.length) {
            TreeColumn column = new TreeColumn(this.targetMessageTree, 16384);
            column.setText(targetColumns[i2]);
            if (i2 == 0) {
                column.setWidth(180);
            } else {
                column.setWidth(100);
            }
            ++i2;
        }
        this.targetMessageTreeViewer.setUseHashlookup(true);
        this.targetMessageTreeViewer.setColumnProperties(targetColumns);
        this.targetMessageTreeViewer.getTree().setLayoutData((Object)treeData);
        editors = new CellEditor[]{null, new TextCellEditor((Composite)this.targetMessageTreeViewer.getTree())};
        this.targetMessageTreeViewer.setColumnProperties(PROPS);
        this.targetMessageTreeViewer.setCellModifier(new IndexCellModifier((Viewer)this.targetMessageTreeViewer));
        this.targetMessageTreeViewer.setCellEditors(editors);
        this.sourceXPathViewerFilter = new XPathFilter(this.controller, this.controller.getXPathFor(this.source));
        this.sourceMessageTreeViewer.addFilter(this.sourceXPathViewerFilter);
        this.sourceXPathViewerFilter.setActive(true);
        this.targetXPathViewerFilter = new XPathFilter(this.controller, this.controller.getXPathFor(this.target));
        this.targetMessageTreeViewer.addFilter(this.targetXPathViewerFilter);
        this.targetXPathViewerFilter.setActive(true);
        showAllButton.setSelection(true);
        Group radioComposite = new Group(comp, 0);
        radioComposite.setText(Modeling_Messages.TXT_MAPPING_STRATEGY);
        GridLayout radioCompLayout = new GridLayout();
        radioComposite.setLayout((Layout)radioCompLayout);
        GridData radioCompGridData = new GridData();
        radioCompGridData.grabExcessHorizontalSpace = true;
        radioCompGridData.grabExcessVerticalSpace = true;
        radioCompGridData.horizontalAlignment = 4;
        radioCompGridData.verticalAlignment = 4;
        radioComposite.setLayoutData((Object)radioCompGridData);
        this.appendButton = new Button((Composite)radioComposite, 16);
        this.appendButton.setText(Modeling_Messages.TXT_APPEND_ELE);
        this.appendButton.setEnabled(this.config.isAppend() && this.config.isOverwrite());
        this.appendButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IndexConfigurationDialog.this.config.setAppend(IndexConfigurationDialog.this.appendButton.getSelection());
                IndexConfigurationDialog.this.config.setOverwrite(IndexConfigurationDialog.this.overwriteButton.getSelection());
            }
        });
        this.overwriteButton = new Button((Composite)radioComposite, 16);
        this.overwriteButton.setText(Modeling_Messages.TXT_EXISTING_ELE);
        this.overwriteButton.setEnabled(this.config.isAppend() && this.config.isOverwrite());
        radioComposite.setEnabled(this.config.isAppend() && this.config.isOverwrite());
        this.overwriteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IndexConfigurationDialog.this.config.setAppend(IndexConfigurationDialog.this.appendButton.getSelection());
                IndexConfigurationDialog.this.config.setOverwrite(IndexConfigurationDialog.this.overwriteButton.getSelection());
            }
        });
        this.appendButton.setSelection(false);
        this.overwriteButton.setSelection(true);
        this.config.setAppend(false);
        this.config.setOverwrite(true);
        this.refreshModel();
        parent.getShell().setMinimumSize(600, 300);
        return comp;
    }

    protected void okPressed() {
        this.config.setAppend(this.appendButton.getSelection());
        this.config.setOverwrite(this.overwriteButton.getSelection());
        super.okPressed();
    }

    protected void buttonEnablement() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
    }

    public void modifyText(ModifyEvent arg0) {
        String text = this.messageNameText.getText();
        if (!this.controller.isSimpleMode()) {
            if (this.getMessageTypeByName(text) != null) {
                this.isError = true;
                this.errorLabel.setToolTipText(MessageFormat.format(Modeling_Messages.TXT_DOES_ALREADY_EXIST, text));
            } else if (!StringUtils.isValidIdentifier((String)text)) {
                this.isError = true;
                this.errorLabel.setToolTipText(MessageFormat.format(Modeling_Messages.TXT_NOT_VALID_NAME, text));
            } else {
                this.isError = false;
                this.errorLabel.setToolTipText(null);
            }
        } else if (!StringUtils.isValidIdentifier((String)text)) {
            this.isError = true;
            this.errorLabel.setToolTipText(MessageFormat.format(Modeling_Messages.TXT_NOT_VALID_NAME, text));
        } else {
            this.isError = false;
            this.errorLabel.setToolTipText(null);
        }
        this.buttonEnablement();
    }

    public AccessPointType getMessageType() {
        return this.messageType;
    }

    public String getMessageName() {
        return this.messageName;
    }

    private boolean isAccessPointIdDefined(String id) {
        for (AccessPointType messageType : this.allMessageTypes) {
            if (!messageType.getId().equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private AccessPointType getMessageTypeByName(String name) {
        for (AccessPointType messageType : this.allMessageTypes) {
            if (!messageType.getId().equalsIgnoreCase(name)) continue;
            return messageType;
        }
        return null;
    }

    public void refreshModel() {
        this.sourceProvider = new MultipleAccessPathBrowserContentProvider(DirectionType.INOUT_LITERAL, this.controller);
        this.sourceMessageTreeViewer.setContentProvider((IContentProvider)this.sourceProvider);
        this.sourceMessageTreeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingIndexingLabelProvider(this.controller, this.indexMap, this.controller.getXPathFor(this.source)));
        this.sourceMessageTreeViewer.setComparer(new MessageTypeComparer());
        this.sourceMessageTreeViewer.setInput(this.inputModel);
        this.controller.setSourceAPB(this.sourceProvider);
        this.targetProvider = new MultipleAccessPathBrowserContentProvider(DirectionType.INOUT_LITERAL, this.controller);
        this.targetMessageTreeViewer.setContentProvider((IContentProvider)this.targetProvider);
        this.targetMessageTreeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingIndexingLabelProvider(this.controller, this.indexMap, this.controller.getXPathFor(this.target)));
        this.targetMessageTreeViewer.setComparer(new MessageTypeComparer());
        this.targetMessageTreeViewer.setInput(this.outputModel);
        this.controller.setTargetAPB(this.targetProvider);
        this.sourceMessageTreeViewer.refreshVisibleItems();
        this.targetMessageTreeViewer.refreshVisibleItems();
    }

    class IndexCellModifier
    implements ICellModifier {
        private Viewer viewer;

        public IndexCellModifier(Viewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            AccessPointType apt = (AccessPointType)element;
            return IndexConfigurationDialog.this.controller.isList(apt);
        }

        public Object getValue(Object element, String property) {
            AccessPointType apt = (AccessPointType)element;
            String xPath = IndexConfigurationDialog.this.controller.getXPathFor(apt);
            String value = (String)IndexConfigurationDialog.this.indexMap.get(xPath);
            if (value == null) {
                value = "0";
                IndexConfigurationDialog.this.indexMap.put(xPath, value);
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            AccessPointType apt = (AccessPointType)((TreeItem)element).getData();
            String xPath = IndexConfigurationDialog.this.controller.getXPathFor(apt);
            IndexConfigurationDialog.this.indexMap.put(xPath, value.toString());
            this.viewer.refresh();
        }
    }
}

