/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.triggerTypes;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.JavaDataTypeUtils;

public class JMSTriggerValidator
implements IModelElementValidator {
    private static final String[] messages = new String[]{Validation_Messages.MSG_JMSTRIGGER_UnspecifiedMessageType, Validation_Messages.MSG_JMSTRIGGER_ParameterNoId, Validation_Messages.MSG_JMSTRIGGER_NoLocationSpecified, Validation_Messages.MSG_JMSTRIGGER_NoValidTypeForParameter};

    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        if (StringUtils.isEmpty((String)AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:messageType"))) {
            result.add(Issue.error((EObject)element, (String)messages[0], (Object)"carnot:engine:messageType"));
        }
        TriggerType trigger = (TriggerType)element;
        EList accessPointList = trigger.getAccessPoint();
        for (AccessPointType accessPoint : accessPointList) {
            if (StringUtils.isEmpty((String)accessPoint.getId())) {
                result.add(Issue.warning((EObject)accessPoint, (String)messages[1], (Object)ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
            } else if (!ModelUtils.isValidId((String)accessPoint.getId())) {
                result.add(Issue.warning((EObject)accessPoint, (String)MessageFormat.format(Validation_Messages.ERR_ELEMENT_InvalidId, accessPoint.getId()), (Object)ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
            }
            if (StringUtils.isEmpty((String)AttributeUtil.getAttributeValue((IExtensibleElement)accessPoint, (String)"carnot:engine:jms.location"))) {
                result.add(Issue.warning((EObject)accessPoint, (String)MessageFormat.format(messages[2], accessPoint.getId()), (Object)"carnot:engine:jms.location"));
            }
            String clazz = AttributeUtil.getAttributeValue((IExtensibleElement)accessPoint, (String)"carnot:engine:className");
            clazz = VariableContextHelper.getInstance().getContext((ModelType)element.eContainer().eContainer()).replaceAllVariablesByDefaultValue(clazz);
            if (JavaDataTypeUtils.getTypeFromCurrentProject(clazz) != null) continue;
            result.add(Issue.warning((EObject)accessPoint, (String)MessageFormat.format(messages[3], accessPoint.getName(), clazz), (Object)"carnot:engine:className"));
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

