/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.util;

import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.stardust.modeling.validation.util.TypeFinderListener;

public class TypeRequestor
extends TypeNameRequestor {
    private static final char SEPARATOR = '/';
    private static final char EXTENSION_SEPARATOR = '.';
    private boolean stopped;
    private char[] typeName;
    private char[][] enclosing;
    private IJavaSearchScope scope;
    private TypeFinderListener listener;
    private int pattern;

    public TypeRequestor(String typeName, IJavaSearchScope scope, int pattern, TypeFinderListener listener) {
        this.pattern = pattern;
        if (typeName.length() > 0) {
            StringTokenizer st = new StringTokenizer(typeName, "$");
            int c = st.countTokens();
            if (c > 1) {
                this.enclosing = new char[c - 1][];
                int i = 0;
                while (i < c - 1) {
                    this.enclosing[i] = st.nextToken().toCharArray();
                    ++i;
                }
            }
            this.typeName = st.nextToken().toCharArray();
        } else {
            this.typeName = typeName.toCharArray();
        }
        this.scope = scope;
        this.listener = listener;
    }

    public synchronized void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
        if (!this.stopped && this.matches(modifiers, simpleTypeName, enclosingTypeNames)) {
            StringBuffer qualifiedName = new StringBuffer();
            int i = 0;
            while (i < enclosingTypeNames.length) {
                qualifiedName.append(enclosingTypeNames[i]).append('.');
                ++i;
            }
            qualifiedName.append(simpleTypeName);
            IType result = null;
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            int index = path.indexOf("|");
            try {
                result = index != -1 ? this.getJarIType(model, packageName, qualifiedName.toString(), path, index) : this.getFileIType(model, packageName, qualifiedName.toString(), path);
            }
            catch (JavaModelException javaModelException) {}
            if (result != null) {
                this.listener.typeFound(result);
            }
        }
    }

    private boolean matches(int modifiers, char[] simpleTypeName, char[][] enclosingTypeNames) {
        switch (this.pattern) {
            case 0: {
                return Arrays.equals(this.typeName, simpleTypeName) && this.isPublic(modifiers) && this.isEnclosed(enclosingTypeNames);
            }
            case 1: {
                if (this.typeName.length == 0) {
                    return true;
                }
                if (simpleTypeName.length < this.typeName.length) {
                    return false;
                }
                int i = 0;
                while (i < this.typeName.length) {
                    if (this.typeName[i] != simpleTypeName[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    private IType getFileIType(IJavaModel model, char[] packageName, String qualifiedName, String path) throws JavaModelException {
        IJavaProject project = null;
        IJavaProject[] projects = model.getJavaProjects();
        int i = 0;
        while (i < projects.length) {
            if (path.startsWith(projects[i].getElementName(), 1) && (project == null || projects[i].getElementName().length() > project.getElementName().length())) {
                project = projects[i];
            }
            ++i;
        }
        if (project != null) {
            return project.findType(String.valueOf(packageName), qualifiedName);
        }
        return null;
    }

    private IType getJarIType(IJavaModel model, char[] packageName, String qualifiedName, String path, int index) throws JavaModelException {
        String jar = path.substring(0, index);
        String rest = path.substring(index + 1);
        if ((index = rest.lastIndexOf(47)) != -1) {
            rest = rest.substring(index + 1);
        }
        if ((index = rest.lastIndexOf(46)) != -1) {
            String file = rest.substring(0, index);
            String extension = rest.substring(index + 1);
            IPath[] enclosedPaths = this.scope.enclosingProjectsAndJars();
            int i = 0;
            while (i < enclosedPaths.length) {
                IJavaProject project;
                IPackageFragmentRoot root;
                IPath curr = enclosedPaths[i];
                if (curr.segmentCount() == 1 && (root = (project = model.getJavaProject(curr.segment(0))).getPackageFragmentRoot(jar)).exists()) {
                    IPackageFragment fragment = root.getPackageFragment(String.valueOf(packageName));
                    if (!fragment.exists()) break;
                    if ("class".equals(extension)) {
                        IClassFile classFile = fragment.getClassFile(String.valueOf(file) + ".class");
                        if (!classFile.exists()) break;
                        return classFile.getType();
                    }
                    if (!"java".equals(extension)) break;
                    ICompilationUnit unit = fragment.getCompilationUnit(String.valueOf(file) + ".java");
                    IType[] types = unit.getAllTypes();
                    int j = 0;
                    while (j < types.length) {
                        if (qualifiedName.equals(types[j].getTypeQualifiedName('.'))) {
                            return types[j];
                        }
                        ++j;
                    }
                    break;
                }
                ++i;
            }
        }
        return null;
    }

    private boolean isEnclosed(char[][] enclosingTypeNames) {
        if (this.enclosing == null) {
            return enclosingTypeNames.length == 0;
        }
        if (this.enclosing.length != enclosingTypeNames.length) {
            return false;
        }
        int i = 0;
        while (i < this.enclosing.length) {
            if (!Arrays.equals(this.enclosing[i], enclosingTypeNames[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isPublic(int modifiers) {
        return Flags.isInterface((int)modifiers) || Flags.isPublic((int)modifiers);
    }

    public synchronized void stop() {
        this.stopped = true;
    }

    public char[] getTypeName() {
        return this.typeName;
    }

    public TypeFinderListener getListener() {
        return this.listener;
    }

    public IJavaSearchScope getScope() {
        return this.scope;
    }

    public int getPattern() {
        return this.pattern;
    }
}

