/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.EndEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IFlowObjectSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TeamLeadConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class DiagramValidator
implements IModelElementValidator {
    private static final String[] messages = new String[]{Validation_Messages.MSG_DIAGRAM_DiagramNameIsEmpty, Validation_Messages.MSG_DIAGRAM_NoRequiredGatewaySymbols, Validation_Messages.MSG_DIAGRAM_MultipleOutgoingTransitions, Validation_Messages.MSG_DIAGRAM_InvalidConnectionTarget, Validation_Messages.MSG_DIAGRAM_NoJoinTypeNONE, Validation_Messages.MSG_DIAGRAM_MultipleIncomingTransitions, Validation_Messages.MSG_DIAGRAM_InvalidConnectionSource, Validation_Messages.MSG_DIAGRAM_NoSplitTypeNONE};

    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        DiagramType diagram = (DiagramType)element;
        if (StringUtils.isEmpty((String)diagram.getName())) {
            result.add(Issue.warning((EObject)diagram, this.getMessage(diagram, 0), ValidationService.PKG_CWM.getDiagramType_Name()));
        }
        if (this.needsUpdate(diagram)) {
            result.add(Issue.warning((EObject)diagram, this.getMessage(diagram, 1)));
        }
        this.checkStartEvents(result, diagram);
        this.checkEndEvents(result, diagram);
        this.checkConnectionSymbols(result, diagram);
        ValidationService vs = ValidationService.getInstance();
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)diagram.getPoolSymbols())));
        result.addAll(Arrays.asList(vs.validateModelElements(DiagramUtil.getSymbols((ISymbolContainer)diagram, (EStructuralFeature)ValidationService.PKG_CWM.getISymbolContainer_StartEventSymbols(), null))));
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private void checkConnectionSymbols(List<Issue> result, DiagramType diagram) {
        this.checkConnectionSymbols(result, diagram, (EStructuralFeature)ValidationService.PKG_CWM.getISymbolContainer_DataMappingConnection(), Validation_Messages.MSG_NoDataMappingSymbols);
        this.checkConnectionSymbols(result, diagram, (EStructuralFeature)ValidationService.PKG_CWM.getISymbolContainer_TransitionConnection(), Validation_Messages.MSG_NoTransitionSymbols);
        this.checkConnectionSymbols(result, diagram, (EStructuralFeature)ValidationService.PKG_CWM.getISymbolContainer_ExecutedByConnection(), Validation_Messages.MSG_NoExecutedBySymbols);
        this.checkConnectionSymbols(result, diagram, (EStructuralFeature)ValidationService.PKG_CWM.getISymbolContainer_PerformsConnection(), Validation_Messages.MSG_NoPerformsSymbols);
        this.checkConnectionSymbols(result, diagram, (EStructuralFeature)ValidationService.PKG_CWM.getISymbolContainer_WorksForConnection(), Validation_Messages.MSG_NoWorksForSymbols);
        this.checkConnectionSymbols(result, diagram, (EStructuralFeature)ValidationService.PKG_CWM.getISymbolContainer_RefersToConnection(), Validation_Messages.MSG_NoRefersToSymbols);
        this.checkConnectionSymbols(result, diagram, (EStructuralFeature)ValidationService.PKG_CWM.getISymbolContainer_TeamLeadConnection(), "fdfdsfsd");
    }

    private void checkConnectionSymbols(List<Issue> result, DiagramType diagram, EStructuralFeature feature, String msg) {
        ArrayList connections = new ArrayList();
        connections.addAll((Collection)diagram.eGet(feature));
        for (PoolSymbol poolSymbol : diagram.getPoolSymbols()) {
            connections.addAll((Collection)poolSymbol.eGet(feature));
            for (LaneSymbol laneSymbol : poolSymbol.getLanes()) {
                connections.addAll((Collection)laneSymbol.eGet(feature));
            }
        }
        for (IConnectionSymbol connection : connections) {
            OrganizationSymbolType target;
            OrganizationType organization;
            if (connection.getSourceNode() == null || connection.getTargetNode() == null) {
                result.add(Issue.warning((EObject)connection, msg, ValidationService.PKG_CWM.getIConnectionSymbol()));
            }
            if (!(connection instanceof TeamLeadConnectionType) || (organization = (target = (OrganizationSymbolType)((TeamLeadConnectionType)connection).getTargetNode()).getOrganization()).getTeamLead() != null) continue;
            result.add(Issue.error((EObject)organization, Validation_Messages.ERR_Invalid_TeamLeadConnection, ValidationService.PKG_CWM.getTeamLeadConnectionType_TeamLeadSymbol()));
        }
    }

    private void checkStartEvents(List result, DiagramType diagram) {
        List startEvents = DiagramUtil.getSymbols((ISymbolContainer)diagram, (EStructuralFeature)ValidationService.PKG_CWM.getISymbolContainer_StartEventSymbols(), null);
        int i = 0;
        while (i < startEvents.size()) {
            StartEventSymbol eventSymbol = (StartEventSymbol)startEvents.get(i);
            EList transitions = eventSymbol.getOutTransitions();
            if (transitions.size() > 1) {
                result.add(Issue.warning((EObject)eventSymbol, this.getMessage(eventSymbol, 2)));
            }
            int j = 0;
            while (j < transitions.size()) {
                TransitionConnectionType connection = (TransitionConnectionType)transitions.get(j);
                ActivityType activity = this.getActivity(connection.getTargetActivitySymbol());
                if (activity == null) {
                    result.add(Issue.warning((EObject)connection, this.getMessage(eventSymbol, 3)));
                }
                ++j;
            }
            ++i;
        }
    }

    private void checkEndEvents(List result, DiagramType diagram) {
        List endEvents = DiagramUtil.getSymbols((ISymbolContainer)diagram, (EStructuralFeature)ValidationService.PKG_CWM.getISymbolContainer_EndEventSymbols(), null);
        int i = 0;
        while (i < endEvents.size()) {
            EndEventSymbol eventSymbol = (EndEventSymbol)endEvents.get(i);
            EList transitions = eventSymbol.getInTransitions();
            if (transitions.size() > 1) {
                result.add(Issue.warning((EObject)eventSymbol, this.getMessage(eventSymbol, 5)));
            }
            int j = 0;
            while (j < transitions.size()) {
                TransitionConnectionType connection = (TransitionConnectionType)transitions.get(j);
                ActivityType activity = this.getActivity(connection.getSourceActivitySymbol());
                if (activity == null) {
                    result.add(Issue.warning((EObject)connection, this.getMessage(eventSymbol, 6)));
                }
                ++j;
            }
            ++i;
        }
    }

    private ActivityType getActivity(IFlowObjectSymbol symbol) {
        if (symbol instanceof GatewaySymbol) {
            symbol = ((GatewaySymbol)symbol).getActivitySymbol();
        }
        if (symbol instanceof ActivitySymbolType) {
            return ((ActivitySymbolType)symbol).getActivity();
        }
        return null;
    }

    private boolean needsUpdate(DiagramType diagram) {
        List activitySymbols = DiagramUtil.getSymbols((ISymbolContainer)diagram, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_ActivitySymbol(), null);
        int i = 0;
        while (i < activitySymbols.size()) {
            String activityId;
            ActivitySymbolType symbol = (ActivitySymbolType)activitySymbols.get(i);
            ActivityType activity = symbol.getActivity();
            if (activity != null && !StringUtils.isEmpty((String)(activityId = activity.getId())) && !activityId.matches("^(?i)gateway.*")) {
                if (activity.getJoin() != JoinSplitType.NONE_LITERAL && !this.hasGateway(symbol, FlowControlType.JOIN_LITERAL)) {
                    return true;
                }
                if (activity.getSplit() != JoinSplitType.NONE_LITERAL && !this.hasGateway(symbol, FlowControlType.SPLIT_LITERAL)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean hasGateway(ActivitySymbolType target, FlowControlType flow) {
        EList gateways = target.getGatewaySymbols();
        int i = 0;
        while (i < gateways.size()) {
            GatewaySymbol gateway = (GatewaySymbol)gateways.get(i);
            if (flow.equals((Object)gateway.getFlowKind())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getMessage(Object source, int i) {
        String msg = messages[i];
        Object[] args = this.getArguments(source);
        return MessageFormat.format(msg, args);
    }

    private Object[] getArguments(Object source) {
        if (source instanceof DiagramType) {
            DiagramType diagram = (DiagramType)source;
            return new Object[]{Long.toString(diagram.getElementOid()), diagram.getName()};
        }
        if (source instanceof AbstractEventSymbol) {
            AbstractEventSymbol event = (AbstractEventSymbol)source;
            Object[] objectArray = new Object[2];
            objectArray[0] = Long.toString(event.getElementOid());
            objectArray[1] = event instanceof StartEventSymbol ? (((StartEventSymbol)event).getTrigger() == null ? "StartEvent" : ((StartEventSymbol)event).getTrigger().getName()) : "EndEvent";
            return objectArray;
        }
        return new Object[0];
    }
}

