/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.project.effort;

import java.util.List;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.modeling.project.effort.EffortEntry;
import org.eclipse.stardust.modeling.project.effort.EffortParameterScope;
import org.eclipse.stardust.modeling.project.effort.EffortParameters;

public class EffortCalculator {
    public List<EffortEntry> calculateEfforts(EffortParameters parameters) {
        List entryList = CollectionUtils.newList();
        int i = 0;
        while (i < parameters.SCOPE_LIST.size()) {
            EffortParameterScope scope = parameters.SCOPE_LIST.get(i);
            List<IExtensibleElement> extensibles = parameters.getExtensibles(scope);
            for (IExtensibleElement extensible : extensibles) {
                this.calculateEffortsForModelElement(extensible, scope, entryList);
            }
            ++i;
        }
        return entryList;
    }

    public void calculateEffortsForModelElement(IExtensibleElement element, EffortParameterScope elementType, List<EffortEntry> entryList) {
        int n = 0;
        while (n < element.getAttribute().size()) {
            AttributeType attribute = (AttributeType)element.getAttribute().get(n);
            String name = attribute.getName();
            if (!name.equals("project-planning:notifier") && name.startsWith("project-planning") && !name.startsWith("project-planning:effortParameter")) {
                EffortEntry entry = new EffortEntry(elementType, ((IIdentifiableElement)element).getName(), name.substring("project-planning".length() + 1), attribute.getValue());
                entryList.add(entry);
            }
            ++n;
        }
    }
}

