/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.IFlowObjectSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class StartEventValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        TransitionConnectionType transition;
        IFlowObjectSymbol symbol;
        EList outTransitions;
        ArrayList<Issue> result = new ArrayList<Issue>();
        StartEventSymbol startEvent = (StartEventSymbol)element;
        ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)element);
        ActivityType startActivity = null;
        List activitySymbols = null;
        boolean otherStartActivities = false;
        for (ActivityType activity : process.getActivity()) {
            if (!activity.getInTransitions().isEmpty()) continue;
            if (startActivity == null) {
                startActivity = activity;
                continue;
            }
            if (otherStartActivities) continue;
            otherStartActivities = true;
        }
        if (startActivity != null && !otherStartActivities) {
            activitySymbols = startActivity.getActivitySymbols();
        }
        if (activitySymbols != null && !activitySymbols.isEmpty() && !(outTransitions = startEvent.getOutTransitions()).isEmpty() && (symbol = (transition = (TransitionConnectionType)outTransitions.get(0)).getTargetActivitySymbol()) instanceof ActivitySymbolType) {
            ActivityType activity = ((ActivitySymbolType)symbol).getActivity();
            if (!activitySymbols.contains(symbol)) {
                result.add(Issue.warning((EObject)startEvent, MessageFormat.format(Validation_Messages.MSG_StartEventSymbolWrongConnected, activity.getId(), startActivity.getId())));
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

