/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.data;

import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DynamicData;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;

public class DiscreteIntegral
implements DataProvider,
DynamicData {
    public static double EPS = 1.0E-4;
    boolean rectangular;
    DataProvider curve;

    public DiscreteIntegral(boolean rectangular) {
        this.rectangular = rectangular;
    }

    public void setCurve(DataProvider curve) {
        this.curve = curve;
    }

    @Override
    public Coord2D[] getPoints() {
        return this.curve.getPoints();
    }

    public double getIntegral() {
        Coord2D[] points = this.getPoints();
        double ff = 0.0;
        if (points.length > 0) {
            Coord2D prev = points[0];
            int i = 1;
            while (i < points.length) {
                double average = (prev.getY() + points[i].getY()) / 2.0;
                double f = average * (points[i].getX() - prev.getX());
                ff += f;
                prev = points[i];
                ++i;
            }
        }
        return ff;
    }

    public double getIntegral(int index1, int index2) {
        Coord2D[] points = this.getPoints();
        index1 = Math.max(index1, 1);
        index2 = Math.min(index2, points.length - 1);
        double ff = 0.0;
        if (points.length > 0) {
            Coord2D prev = points[index1 - 1];
            int i = index1;
            while (i <= index2) {
                double average = (prev.getY() + points[i].getY()) / 2.0;
                double f = average * (points[i].getX() - prev.getX());
                ff += f;
                prev = points[i];
                ++i;
            }
        }
        return ff;
    }

    public double getIntegralAt(double x) {
        Coord2D[] points = this.getPoints();
        if (points.length == 0 || x < points[0].getX()) {
            return 0.0;
        }
        int i = 1;
        while (i < points.length) {
            if (x <= points[i].getX()) {
                return this.getIntegral(i, i);
            }
            ++i;
        }
        return this.getIntegral();
    }

    public double getWidthAt(double x) {
        Coord2D[] points = this.getPoints();
        if (points.length == 0 || x < points[0].getX()) {
            return 0.0;
        }
        int i = 1;
        while (i < points.length) {
            if (x <= points[i].getX()) {
                return points[i].minus(points[i - 1]).getX();
            }
            ++i;
        }
        return this.getRange();
    }

    public double getRange() {
        return this.getPoints().length < 2 ? 0.0 : this.getLast().minus(this.getFirst()).getX();
    }

    public double getMaxY() {
        double max = 0.0;
        int i = 0;
        while (i < this.getPoints().length) {
            max = Math.max(max, this.getPoints()[i].getY());
            ++i;
        }
        return max;
    }

    public double getAverageY() {
        return this.getPoints().length == 0 ? 0.0 : (this.getRange() > EPS ? this.getIntegral() / this.getRange() : this.getPoints()[0].getY());
    }

    private Coord2D getFirst() {
        return this.getPoints()[0];
    }

    private Coord2D getLast() {
        return this.getPoints()[this.getPoints().length];
    }
}

