/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.editor;

import org.eclipse.draw2d.Graphics;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Drawing;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Metrics;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.EditableDataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.Editor;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.EditorController;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.SelectionLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Rectangle2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DottedCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.StrokedCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.WrapperLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.XAxisLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.YAxisLayer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class FreestyleEditor
extends Canvas
implements Editor {
    WrapperLayer curveSlot;
    WrapperLayer selectionSlot;
    WrapperLayer previewSlot;
    EditableDataProvider curve;
    Drawing drawing;
    EditorController controller;
    Rectangle2D sensivity;
    Rectangle2D constraints;

    public FreestyleEditor(Composite parent, int style, Configuration configuration) {
        super(parent, style);
        this.drawing = new Drawing(configuration);
        this.addPaintListener(this.drawing);
        this.controller = new EditorController(this);
        this.addMouseListener(this.controller);
        this.addMouseMoveListener(this.controller);
        this.curveSlot = new WrapperLayer();
        this.selectionSlot = new WrapperLayer();
        this.previewSlot = new WrapperLayer();
        this.drawing.addLayer(this.curveSlot);
        this.drawing.addLayer(new XAxisLayer("x", null, 1.0, 0.0, 1.0, "####", true));
        this.drawing.addLayer(new YAxisLayer("y", null, 1.0, 0.0, 1.0, "####", true));
        this.drawing.addLayer(this.selectionSlot);
        this.drawing.addLayer(this.previewSlot);
    }

    @Override
    public Metrics getMetrics() {
        return this.drawing.getMetrics();
    }

    public Coord2D[] getCurveData() {
        return this.curve.getPoints();
    }

    public void setCurveData(Coord2D[] points) {
        this.curve = new EditableDataProvider(points);
        this.curveSlot.setDelegate(new DottedCurveLayer(new StrokedCurveLayer((DataProvider)this.curve, 0)));
        this.selectionSlot.setDelegate(new DottedCurveLayer(new StrokedCurveLayer(new SelectionLayer(this.curve, this.drawing.getConfiguration().getCurveColors()[1]))));
        this.redraw();
    }

    public void setCurveData(DataProvider provider) {
        this.setCurveData(provider.getPoints());
    }

    public void setConstraints(Rectangle2D constraints) {
        this.constraints = constraints;
    }

    public Rectangle2D getConstraints() {
        return this.constraints;
    }

    @Override
    public void actionExecute(Coord2D point, boolean appendMode) {
        Coord2D found = this.curve.findNearestPoint(point, false);
        if (found != null && this.near(point, found)) {
            this.curve.clearSelection();
            this.curve.deletePoint(found);
        } else {
            this.curve.clearSelection();
            Coord2D[] neighbours = this.curve.findNeighbourhood(point.getX());
            if (neighbours[0] == null) {
                this.curve.insertPointAfter(null, new Coord2D(point));
            } else if (neighbours[1] == null) {
                this.curve.insertPointAfter(neighbours[0], new Coord2D(point));
            } else {
                double d;
                Coord2D v = neighbours[1].minus(neighbours[0]);
                found = v.multiply(d = (point.getX() - neighbours[0].getX()) / v.getX()).plus(neighbours[0]);
                if (this.near(point, found)) {
                    this.curve.insertPointAfter(neighbours[0], found);
                    this.curve.setSelection(found);
                }
            }
        }
        this.redraw();
    }

    @Override
    public void actionSelect(Coord2D point, boolean appendMode) {
        Coord2D found = this.curve.findNearestPoint(point, true);
        if (found == null || !this.near(point, found)) {
            found = this.curve.findNearestPoint(point, false);
        }
        if (found == null || !this.near(point, found)) {
            this.curve.clearSelection();
        } else if (appendMode) {
            this.curve.addSelection(found);
        } else {
            this.curve.setSelection(found);
        }
        this.redraw();
    }

    @Override
    public void actionPopup(Coord2D point, boolean appendMode) {
    }

    @Override
    public void actionDragCommit(Coord2D source, Coord2D distance, Coord2D target) {
        this.previewSlot.setDelegate(null);
        Coord2D[] selected = this.curve.getSelection();
        Coord2D[] changed = this.calculateDrag(selected, distance);
        this.curve.replacePoints(selected, changed);
        this.curve.clearSelection();
        int i = 0;
        while (i < changed.length) {
            this.curve.addSelection(changed[i]);
            ++i;
        }
        this.redraw();
    }

    @Override
    public void actionDragAbort() {
        this.previewSlot.setDelegate(null);
        this.redraw();
    }

    @Override
    public void actionDragPreview(Coord2D source, Coord2D distance, Coord2D target) {
        Coord2D[] selected = this.curve.getSelection();
        Coord2D[] changed = this.calculateDrag(selected, distance);
        EditableDataProvider preview = new EditableDataProvider(this.curve.getPoints());
        preview.replacePoints(selected, changed);
        this.previewSlot.setDelegate(new StrokedCurveLayer(preview, this.drawing.getConfiguration().getCurveColors()[2]){

            @Override
            protected void drawLine(Graphics gc, int index0, Point point0, int index1, Point point1) {
                gc.setLineStyle(3);
                super.drawLine(gc, index0, point0, index1, point1);
            }
        });
        this.redraw();
    }

    @Override
    public void actionMovePreview(Coord2D position) {
        if (this.curve.isNear(position, false, this.sensivity) != null) {
            this.setCursor(this.getDisplay().getSystemCursor(21));
        } else {
            this.setCursor(this.getDisplay().getSystemCursor(0));
        }
    }

    private Coord2D[] calculateDrag(Coord2D[] selected, Coord2D distance) {
        distance = this.curve.adjustSelectionConstraints(distance);
        Coord2D[] changed = new Coord2D[selected.length];
        int i = 0;
        while (i < selected.length) {
            changed[i] = selected[i].plus(distance);
            changed[i] = this.adjustDrawingConstraints(changed[i]);
            ++i;
        }
        return changed;
    }

    private Coord2D adjustDrawingConstraints(Coord2D c) {
        return this.constraints == null ? c : this.constraints.adjust(c);
    }

    @Override
    public void updateSensivity(Rectangle2D sensivity) {
        this.sensivity = sensivity.transform(sensivity.getMinCorner().plus(sensivity.getSize().multiply(0.5)).minus());
    }

    private boolean near(Coord2D c1, Coord2D c2) {
        return this.sensivity.inside(c1.minus(c2));
    }
}

