/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.OpenLaunchDialogAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.transformation.messaging.format.FormatManager;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.TypesLabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;

public abstract class AbstractMessageProcessingPropertyPage
extends AbstractModelElementPropertyPage {
    protected ComboViewer formatComboViewer;
    protected ComboViewer formatModelComboViewer;
    protected ComboViewer messageTypeComboViewer;
    protected ComboViewer testConfigurationsComboViewer;
    protected String xmlString;
    protected Link manageConfigurationsLink;
    protected Link createConfigurationLink;
    private Button runTestButton;

    protected void initializeTypeComboViewer(ApplicationType application) {
        ModelType modelType = ModelUtils.findContainingModel((EObject)application);
        TypesLabelProvider lp = (TypesLabelProvider)this.messageTypeComboViewer.getLabelProvider();
        lp.setModel(modelType);
        List dataTypes = ModelUtils.getAllTypeDeclarations((ModelType)modelType);
        if (dataTypes.isEmpty()) {
            this.setErrorMessage(Modeling_Messages.MSG_MD_NOT_CONTAIN_ANY_STR_DATA_TYPES);
        }
        this.messageTypeComboViewer.setInput((Object)dataTypes.toArray());
        DataTypeType structuredDataType = ModelUtils.getDataType((IModelElement)application, (String)"struct");
        int i = 0;
        while (i < application.getAccessPoint().size()) {
            AccessPointType accessPoint = (AccessPointType)application.getAccessPoint().get(i);
            if (accessPoint.getType() != null && accessPoint.getType().equals(structuredDataType)) {
                TypeDeclarationType declaration = (TypeDeclarationType)AttributeUtil.getIdentifiable((IExtensibleElement)accessPoint, (String)"carnot:engine:dataType");
                this.messageTypeComboViewer.setSelection((ISelection)(declaration == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)declaration)));
                return;
            }
            ++i;
        }
    }

    protected void initializeMessageFormatComboViewer(IModelElement element) {
        this.formatComboViewer.setInput(FormatManager.getMessageFormats());
        String messageFormat = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"messageTransformation:MessageFormat");
        if (messageFormat != null) {
            this.formatComboViewer.setSelection((ISelection)new StructuredSelection((Object)messageFormat));
        }
    }

    protected void initializeTestConfigurationComboViewer(IModelElement element) {
        this.refreshTestConfigurationComboViewer();
        String testConfigurationName = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"messageTransformation:TestConfiguration");
        ILaunchConfiguration lc = this.getConfigurationByName(testConfigurationName);
        if (lc != null) {
            this.testConfigurationsComboViewer.setSelection((ISelection)new StructuredSelection((Object)lc));
        }
    }

    protected ILaunchConfiguration getConfigurationByName(String testConfigurationName) {
        if (testConfigurationName == null) {
            return null;
        }
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType ct = lm.getLaunchConfigurationType("org.eclipse.stardust.modeling.transformation.messaging.modeling.application.launch.testType");
        try {
            ILaunchConfiguration[] cfgs = lm.getLaunchConfigurations(ct);
            if (cfgs.length > 0) {
                int i = 0;
                while (i < cfgs.length) {
                    if (cfgs[i].getName().equalsIgnoreCase(testConfigurationName)) {
                        return cfgs[i];
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(Modeling_Messages.EXC_CANNOT_RETRIEVE_LAUNCH_CFG, e);
        }
        return null;
    }

    protected void refreshTestConfigurationComboViewer() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType ct = lm.getLaunchConfigurationType("org.eclipse.stardust.modeling.transformation.application.launch.testType");
        try {
            ILaunchConfiguration[] cfgs = lm.getLaunchConfigurations(ct);
            this.testConfigurationsComboViewer.setInput((Object)cfgs);
            int selectionIndex = this.findConfigurationIndex(cfgs);
            this.testConfigurationsComboViewer.getCombo().select(selectionIndex);
        }
        catch (CoreException e) {
            throw new RuntimeException(Modeling_Messages.EXC_CANNOT_RETRIEVE_LAUNCH_CFG, e);
        }
    }

    private int findConfigurationIndex(ILaunchConfiguration[] cfgs) {
        String configValue = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)this.getModelElement()), (String)"messageTransformation:TestConfiguration");
        if (configValue != null) {
            int i = 0;
            while (i < cfgs.length) {
                ILaunchConfiguration cfg = cfgs[i];
                if (cfg.getName().startsWith(configValue)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected void loadMessageFormat(IModelElement element) {
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"messageTransformation:MessageFormat", (String)this.getMessageFormat());
    }

    protected void loadTestConfiguration(IModelElement element) {
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"messageTransformation:TestConfiguration", (String)this.getTestConfiguration());
    }

    protected String getMessageFormat() {
        if (this.formatComboViewer.getSelection() != null) {
            return (String)((IStructuredSelection)this.formatComboViewer.getSelection()).getFirstElement();
        }
        return null;
    }

    protected String getTestConfiguration() {
        ILaunchConfiguration lc;
        if (this.testConfigurationsComboViewer.getSelection() != null && (lc = (ILaunchConfiguration)((IStructuredSelection)this.testConfigurationsComboViewer.getSelection()).getFirstElement()) != null) {
            return lc.getName();
        }
        return null;
    }

    protected File getFormatModelFile() {
        if (this.formatModelComboViewer.getSelection() != null) {
            return (File)((IStructuredSelection)this.formatModelComboViewer.getSelection()).getFirstElement();
        }
        return null;
    }

    protected void createTestGroup(Composite composite) {
        Group testGroup = new Group(composite, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        testGroup.setLayout((Layout)layout);
        testGroup.setText(Modeling_Messages.TXT_TESTING_DEB);
        Label testConfigurationsLabel = new Label((Composite)testGroup, 0);
        testConfigurationsLabel.setText(Modeling_Messages.TXT_TEST_CFG);
        this.testConfigurationsComboViewer = new ComboViewer((Composite)testGroup);
        this.testConfigurationsComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractMessageProcessingPropertyPage.this.enableRunButton();
            }
        });
        this.testConfigurationsComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.testConfigurationsComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ILaunchConfiguration) {
                    ILaunchConfiguration configuration = (ILaunchConfiguration)element;
                    String filePath = null;
                    try {
                        filePath = configuration.getAttribute("sourceFilePath", "");
                    }
                    catch (CoreException e) {
                        throw new RuntimeException(Modeling_Messages.EXC_COULD_NOT_RETRIEVE_SR_FILE_PATH, e);
                    }
                    if (filePath != null && filePath.length() != 0) {
                        return String.valueOf(((ILaunchConfiguration)element).getName()) + " (" + filePath + ")";
                    }
                    return ((ILaunchConfiguration)element).getName();
                }
                return null;
            }
        });
        this.runTestButton = new Button((Composite)testGroup, 8);
        this.runTestButton.setText(Modeling_Messages.TXT_RUN);
        this.enableRunButton();
        this.runTestButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractMessageProcessingPropertyPage.this.testConfigurationsComboViewer.getSelection() != null) {
                    ILaunchConfiguration cfg = (ILaunchConfiguration)((IStructuredSelection)AbstractMessageProcessingPropertyPage.this.testConfigurationsComboViewer.getSelection()).getFirstElement();
                    boolean tf = false;
                    boolean tfp = false;
                    boolean sf = false;
                    boolean sfp = false;
                    boolean ld = false;
                    boolean mu = false;
                    boolean mn = false;
                    boolean pr = false;
                    tf = true;
                    tfp = true;
                    try {
                        pr = !StringUtils.isEmpty((String)cfg.getAttribute("ippProject", ""));
                        mn = !StringUtils.isEmpty((String)cfg.getAttribute("modelName", ""));
                        mu = !StringUtils.isEmpty((String)cfg.getAttribute("modelUri", ""));
                        ld = !StringUtils.isEmpty((String)cfg.getAttribute("legoData", ""));
                        sfp = !StringUtils.isEmpty((String)cfg.getAttribute("sourceFilePath", ""));
                        boolean bl = sf = !StringUtils.isEmpty((String)cfg.getAttribute("sourceFormat", ""));
                        if (cfg.getAttribute("testSerialization", true) && !cfg.getAttribute("screenOnly", false)) {
                            tfp = !StringUtils.isEmpty((String)cfg.getAttribute("targetFilePath", ""));
                            tf = !StringUtils.isEmpty((String)cfg.getAttribute("targetFormat", ""));
                        }
                    }
                    catch (Throwable throwable) {}
                    if (pr && mn && mu && ld && sfp && sf && tfp && tf) {
                        DebugUITools.launch((ILaunchConfiguration)cfg, (String)"run");
                    } else {
                        MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 264);
                        messageBox.setText(Modeling_Messages.TXT_WR_LEER);
                        messageBox.setMessage(Modeling_Messages.MSG_SEL_RUN_CFG_NOT_CONSISTE_PLEASE_CHECK_THIS);
                        messageBox.open();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.manageConfigurationsLink = new Link((Composite)testGroup, 0);
        this.manageConfigurationsLink.setText(Modeling_Messages.HTML_TEST_CONFIGURATION);
        this.manageConfigurationsLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.createConfigurationLink = new Link((Composite)testGroup, 0);
        this.createConfigurationLink.setText(Modeling_Messages.HTML_NEW_TEST_CFG_MATCHING_SETTINGS_PR_CFG);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(this.testConfigurationsComboViewer.getControl(), 0, 0x1000000);
        testConfigurationsLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)testConfigurationsLabel, 5, 131072);
        formData.top = new FormAttachment((Control)this.runTestButton, 0, 0x1000000);
        formData.width = 300;
        this.testConfigurationsComboViewer.getControl().setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(this.testConfigurationsComboViewer.getControl(), 5, 131072);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.runTestButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)this.runTestButton, 5, 1024);
        formData.right = new FormAttachment(100, 0);
        this.manageConfigurationsLink.setLayoutData((Object)formData);
        this.manageConfigurationsLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OpenLaunchDialogAction launchDialogAction = new OpenLaunchDialogAction("org.eclipse.debug.ui.launchGroup.run");
                launchDialogAction.run();
            }
        });
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)this.manageConfigurationsLink, 5, 1024);
        formData.right = new FormAttachment(100, 0);
        this.createConfigurationLink.setLayoutData((Object)formData);
    }

    protected void enableRunButton() {
        this.runTestButton.setEnabled(true);
        this.setErrorMessage(null);
        if (StringUtils.isEmpty((String)this.messageTypeComboViewer.getCombo().getText())) {
            this.runTestButton.setEnabled(false);
            this.setErrorMessage(Modeling_Messages.MSG_NO_MSG_TYPE_SET);
        }
        if (StringUtils.isEmpty((String)this.formatComboViewer.getCombo().getText())) {
            this.runTestButton.setEnabled(false);
            this.setErrorMessage(Modeling_Messages.MSG_NO_MSG_FORMAT_SET);
        }
    }
}

