/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.launch;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.ui.StringUtils;
import org.eclipse.stardust.modeling.debug.CwmFileSelectionDialog;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabelProvider;

public class TransformationConfigurationTab
extends AbstractLaunchConfigurationTab
implements Listener {
    private static final String MESSAGE_ID = "MessageId";
    private static final String MESSAGE_TYPE = "MessageType";
    private static final String CONFIGURATION_ID = "ConfigurationID";
    private static final String[] COLUMN_PROPERTIES = new String[]{"MessageId", "MessageType", "ConfigurationID"};
    private Text projectNameText;
    private Text processModelText;
    private ComboViewer transformationApplicationViewer;
    private Button browseProjectsButton;
    private Button browseProcessModelsButton;
    private TableViewer tableViewer;
    private ModelType model;
    private String[] configurationIds;
    private List configurationList;
    private List launcherIDList = new ArrayList();
    private String modelUri;

    public TransformationConfigurationTab() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType ct = lm.getLaunchConfigurationType("org.eclipse.stardust.modeling.transformation.application.launch.testType");
        try {
            ILaunchConfiguration[] cfgs = lm.getLaunchConfigurations(ct);
            this.configurationIds = new String[cfgs.length + 1];
            this.configurationIds[0] = "";
            int n = 0;
            while (n < cfgs.length) {
                this.configurationIds[n + 1] = cfgs[n].getName();
                ++n;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(Modeling_Messages.EXC_CANNOT_RETRIEVE_LAUNCH_CFG, e);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.setControl((Control)composite);
        Group group = new Group(composite, 0);
        group.setText(Modeling_Messages.TXT_TRANSF_SEL);
        Label projectNameLabel = new Label((Composite)group, 0);
        projectNameLabel.setText(Modeling_Messages.TXT_PROJECT_NAME);
        this.projectNameText = new Text((Composite)group, 2060);
        this.browseProjectsButton = new Button((Composite)group, 0);
        this.browseProjectsButton.setText(Modeling_Messages.TXT_BW_DREI_PUNKT);
        this.browseProjectsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransformationConfigurationTab.this.browseProjects();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label processModelLabel = new Label((Composite)group, 0);
        processModelLabel.setText(Modeling_Messages.TXT_PRC_MD);
        this.processModelText = new Text((Composite)group, 2060);
        this.browseProcessModelsButton = new Button((Composite)group, 0);
        this.browseProcessModelsButton.setText(Modeling_Messages.TXT_BW_DREI_PUNKT);
        this.browseProcessModelsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransformationConfigurationTab.this.browseModelFiles();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label messageTransformationApplicationLabel = new Label((Composite)group, 0);
        messageTransformationApplicationLabel.setText(Modeling_Messages.TXT_MSG_TRANSF_APP);
        this.transformationApplicationViewer = new ComboViewer((Composite)group);
        this.transformationApplicationViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.transformationApplicationViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ApplicationType) {
                    return ((ApplicationType)element).getName();
                }
                return null;
            }
        });
        this.transformationApplicationViewer.getCombo().addListener(13, (Listener)this);
        Group inputMessagesGroup = new Group(composite, 0);
        inputMessagesGroup.setText(Modeling_Messages.TXT_IP_MSG);
        Table table = new Table((Composite)inputMessagesGroup, 101124);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384, 0);
        column.setText(Modeling_Messages.TXT_IP_MSG_ID);
        column.setWidth(150);
        column = new TableColumn(table, 16384, 1);
        column.setText(Modeling_Messages.TXT_IP_MSG_TYPE);
        column.setWidth(150);
        column = new TableColumn(table, 16384, 2);
        column.setText(Modeling_Messages.TXT_LAUNCH_CFG_ID);
        column.setWidth(200);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(COLUMN_PROPERTIES);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new InputMessageConfigurationLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new ComboBoxCellEditor((Composite)table, this.configurationIds, 8)};
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier((ICellModifier)new InputMessageConfigurationCellModifier());
        FormLayout layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        projectNameLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)messageTransformationApplicationLabel, 5, 131072);
        formData.top = new FormAttachment((Control)projectNameLabel, 0, 128);
        formData.width = 300;
        this.projectNameText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.projectNameText, 5, 131072);
        formData.top = new FormAttachment((Control)this.projectNameText, 0, 128);
        this.browseProjectsButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)this.projectNameText, 5, 1024);
        processModelLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)messageTransformationApplicationLabel, 5, 131072);
        formData.top = new FormAttachment((Control)processModelLabel, 0, 128);
        formData.width = 300;
        this.processModelText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.processModelText, 5, 131072);
        formData.top = new FormAttachment((Control)this.processModelText, 0, 128);
        this.browseProcessModelsButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)this.processModelText, 5, 1024);
        messageTransformationApplicationLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)messageTransformationApplicationLabel, 5, 131072);
        formData.top = new FormAttachment((Control)messageTransformationApplicationLabel, 0, 128);
        formData.width = 300;
        this.transformationApplicationViewer.getControl().setLayoutData((Object)formData);
        layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        inputMessagesGroup.setLayout((Layout)layout);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        this.tableViewer.getControl().setLayoutData((Object)formData);
    }

    public String getName() {
        return Modeling_Messages.LBL_MESSAGE_TRANSFORMATION_TEST_CONFIGURATION;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.launcherIDList = configuration.getAttribute("inputMessageConfiguration", new ArrayList());
            ArrayList<String> toBeRemoved = new ArrayList<String>();
            for (String launcherID : this.launcherIDList) {
                boolean exists = false;
                int j = 0;
                while (j < this.configurationIds.length) {
                    String id = this.configurationIds[j];
                    String launcherString = launcherID.substring(launcherID.indexOf(",") + 1);
                    if (id.equalsIgnoreCase(launcherString)) {
                        exists = true;
                    }
                    ++j;
                }
                if (exists) continue;
                toBeRemoved.add(launcherID);
            }
            this.launcherIDList.removeAll(toBeRemoved);
            String projectName = configuration.getAttribute("projectName", "");
            this.projectNameText.setText(projectName);
            URI uri = URI.createURI((String)configuration.getAttribute("processModelFilePath", ""));
            this.modelUri = uri.toString();
            String modelPathRelativeToProject = uri.path();
            int idx = modelPathRelativeToProject.lastIndexOf(projectName);
            if (idx != -1 && idx + projectName.length() + 1 < modelPathRelativeToProject.length()) {
                modelPathRelativeToProject = modelPathRelativeToProject.substring(idx + projectName.length() + 1);
            }
            if (this.projectNameText.getText().length() != 0 && modelPathRelativeToProject.indexOf("xpdl") > 0) {
                ApplicationType application;
                this.processModelText.setText(modelPathRelativeToProject);
                this.updateProcessModel();
                String applicationId = configuration.getAttribute("applicationId", "");
                if (applicationId != null && applicationId.length() != 0 && (application = (ApplicationType)ModelUtils.findElementById((List)this.model.getApplication(), (String)applicationId)) != null) {
                    this.transformationApplicationViewer.setSelection((ISelection)new StructuredSelection((Object)application));
                    this.updateInputMessagesTable();
                }
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(Modeling_Messages.EXC_CANNOT_RD_MSG_TRANSF_LAUNCHER_CFG, e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("projectName", this.projectNameText.getText());
        String modelUri = URI.createPlatformResourceURI((String)(String.valueOf(this.projectNameText.getText()) + "/" + this.processModelText.getText()), (boolean)false).toString();
        configuration.setAttribute("processModelFilePath", modelUri);
        configuration.setAttribute("inputMessageConfiguration", this.launcherIDList);
        if (this.transformationApplicationViewer.getSelection() != null && ((IStructuredSelection)this.transformationApplicationViewer.getSelection()).getFirstElement() != null) {
            configuration.setAttribute("applicationId", ((ApplicationType)((IStructuredSelection)this.transformationApplicationViewer.getSelection()).getFirstElement()).getId());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (StringUtils.isEmpty((String)this.projectNameText.getText())) {
            this.setErrorMessage(Modeling_Messages.MSG_NO_PROJECT_SEL);
            return false;
        }
        if (StringUtils.isEmpty((String)this.processModelText.getText())) {
            this.setErrorMessage(Modeling_Messages.MSG_NO_PROJECT_MD_SEL);
            return false;
        }
        if (StringUtils.isEmpty((String)this.transformationApplicationViewer.getCombo().getText())) {
            this.setErrorMessage(Modeling_Messages.MSG_TRANSF_APP_SEL_MISSING);
            return false;
        }
        if (this.configurationList.isEmpty()) {
            this.setErrorMessage(Modeling_Messages.MSG_PRC_LAUNCHER_SEL_MISSING);
            return false;
        }
        for (InputMessageConfiguration conf : this.configurationList) {
            if (!StringUtils.isEmpty((String)conf.getConfigurationId())) continue;
            this.setErrorMessage(Modeling_Messages.MSG_PRC_LAUNCHER_SEL_MISSING);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.transformationApplicationViewer.getCombo()) {
            this.updateInputMessagesTable();
            this.updateLaunchConfigurationDialog();
        }
    }

    private void browseProjects() {
        IJavaProject javaProject;
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            projects = new IJavaProject[]{};
        }
        JavaScriptElementLabelProvider labelProvider = new JavaScriptElementLabelProvider(18);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(Modeling_Messages.DIA_MSG_TRANS_RUN_CFG);
        dialog.setElements(projects);
        String projectName = this.projectNameText.getText();
        if (!StringUtils.isEmpty((String)projectName) && (javaProject = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName))) != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            javaProject = (IJavaProject)dialog.getFirstResult();
            if (javaProject != null) {
                this.updateLaunchConfigurationDialog();
                this.projectNameText.setText(javaProject.getElementName());
                this.processModelText.setText("");
                this.transformationApplicationViewer.setInput(null);
                this.tableViewer.setInput(null);
            } else {
                this.projectNameText.setText("");
            }
        }
        this.updateLaunchConfigurationDialog();
    }

    private void browseModelFiles() {
        String projectName = this.projectNameText.getText();
        if (StringUtils.isEmpty((String)projectName)) {
            MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 264);
            messageBox.setText(Modeling_Messages.TXT_WR_LEER);
            messageBox.setMessage(Modeling_Messages.MSG_FIRST_NEED_SELECT_PROJECT);
            messageBox.open();
        } else {
            CwmFileSelectionDialog dialog = new CwmFileSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName), 1);
            if (dialog.open() == 0) {
                Object[] modelFiles = dialog.getResult();
                IFile modelFile = (IFile)modelFiles[0];
                this.modelUri = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true).toString();
                String fullPath = modelFile.getFullPath().toString();
                this.processModelText.setText(fullPath.substring(projectName.length() + 2));
                this.updateLaunchConfigurationDialog();
                this.updateProcessModel();
            }
        }
    }

    private void updateProcessModel() {
        String projectName = this.projectNameText.getText().trim();
        String modelFile = this.processModelText.getText().trim();
        if (projectName.length() != 0 && modelFile.length() != 0) {
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project == null) {
                    throw new RuntimeException(Modeling_Messages.EXC_PROJECT_NOT_SET);
                }
                IFile file = project.getFile((IPath)new Path(modelFile));
                if (!file.exists()) {
                    throw new RuntimeException(Modeling_Messages.EXC_FILE_DOES_NOT_EXIST);
                }
                this.model = this.loadModel(this.modelUri);
                this.updateMessageTransformationApplications();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void updateMessageTransformationApplications() {
        ArrayList<ApplicationType> list = new ArrayList<ApplicationType>();
        int i = 0;
        while (i < this.model.getApplication().size()) {
            String appType;
            ApplicationType application = (ApplicationType)this.model.getApplication().get(i);
            if (!application.isInteractive() && (appType = application.getType().getId()).equalsIgnoreCase("messageTransformationBean")) {
                list.add(application);
            }
            ++i;
        }
        this.transformationApplicationViewer.setInput(list);
    }

    private void updateInputMessagesTable() {
        ApplicationType application;
        if (this.transformationApplicationViewer.getSelection() != null && (application = (ApplicationType)((IStructuredSelection)this.transformationApplicationViewer.getSelection()).getFirstElement()) != null) {
            this.configurationList = new ArrayList();
            for (AccessPointType accessPoint : application.getAccessPoint()) {
                if (!accessPoint.getDirection().getName().equals(DirectionType.IN_LITERAL.getName())) continue;
                String declaredTypeId = AttributeUtil.getAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:dataType").getValue();
                String configName = "";
                Iterator l = this.launcherIDList.iterator();
                while (l.hasNext()) {
                    String[] tuple = l.next().toString().split(",");
                    if (!accessPoint.getId().equalsIgnoreCase(tuple[0]) || tuple.length <= 1) continue;
                    configName = tuple[1];
                }
                this.configurationList.add(new InputMessageConfiguration(declaredTypeId, accessPoint.getId(), configName));
            }
            this.tableViewer.setInput((Object)this.configurationList);
        }
    }

    private int getConfigurationIndex(String value) {
        if (value == null || value.length() == 0) {
            return 0;
        }
        int n = 0;
        while (n < this.configurationIds.length) {
            if (this.configurationIds[n].equals(value)) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException(MessageFormat.format(Modeling_Messages.EXC_CFG_DOES_NOT_EXIST, value));
    }

    public ModelType loadModel(String modelUri) throws Exception {
        WorkflowModelManager modelManager = new WorkflowModelManager();
        modelManager.load(URI.createURI((String)modelUri));
        ModelType model = modelManager.getModel();
        return model;
    }

    class InputMessageConfiguration {
        private String inputMessageId;
        private String inputMessageType;
        private String configurationId;

        public InputMessageConfiguration(String inputMessageID, String inputMessageType, String configurationID) {
            this.inputMessageId = inputMessageID;
            this.inputMessageType = inputMessageType;
            this.configurationId = configurationID;
        }

        public String getInputMessageId() {
            return this.inputMessageId;
        }

        public String getInputMessageType() {
            return this.inputMessageType;
        }

        public String getConfigurationId() {
            return this.configurationId;
        }

        public void setInputMessageId(String inputMessageID) {
            this.inputMessageId = inputMessageID;
        }

        public void setInputMessageType(String inputMessageType) {
            this.inputMessageType = inputMessageType;
        }

        public void setConfigurationId(String configurationID) {
            this.configurationId = configurationID;
        }

        public String toString() {
            return String.valueOf(this.inputMessageType) + "," + this.configurationId;
        }
    }

    class InputMessageConfigurationCellModifier
    implements ICellModifier {
        InputMessageConfigurationCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals(TransformationConfigurationTab.CONFIGURATION_ID);
        }

        public Object getValue(Object element, String property) {
            InputMessageConfiguration configuration = (InputMessageConfiguration)element;
            if (property.equals(TransformationConfigurationTab.MESSAGE_ID)) {
                return configuration.getInputMessageId();
            }
            if (property.equals(TransformationConfigurationTab.MESSAGE_TYPE)) {
                return configuration.getInputMessageType();
            }
            return new Integer(TransformationConfigurationTab.this.getConfigurationIndex(configuration.getConfigurationId()));
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            InputMessageConfiguration configuration = (InputMessageConfiguration)item.getData();
            if (property.equals(TransformationConfigurationTab.CONFIGURATION_ID)) {
                configuration.setConfigurationId(TransformationConfigurationTab.this.configurationIds[(Integer)value]);
            }
            TransformationConfigurationTab.this.launcherIDList = new ArrayList();
            Iterator i = TransformationConfigurationTab.this.configurationList.iterator();
            while (i.hasNext()) {
                TransformationConfigurationTab.this.launcherIDList.add(i.next().toString());
            }
            TransformationConfigurationTab.this.tableViewer.refresh(true);
            TransformationConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    }

    private static class InputMessageConfigurationLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private InputMessageConfigurationLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            InputMessageConfiguration dataMapping = (InputMessageConfiguration)element;
            if (columnIndex == 0) {
                return dataMapping.getInputMessageId();
            }
            if (columnIndex == 1) {
                return dataMapping.getInputMessageType();
            }
            if (columnIndex == 2) {
                return dataMapping.getConfigurationId();
            }
            throw new IllegalArgumentException(Modeling_Messages.EXC_COLUM_INDEX_EXCEEDS);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }
    }
}

