/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.merge.LinkAttribute;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeAction;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.IconFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.ImportCancelledException;
import org.eclipse.stardust.modeling.repository.common.ImportStrategy;
import org.eclipse.stardust.modeling.repository.common.Repository_Messages;
import org.eclipse.stardust.modeling.repository.common.descriptors.CategoryDescriptor;
import org.eclipse.stardust.modeling.repository.common.descriptors.EObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.descriptors.ModelElementDescriptor;

public final class ImportUtils {
    private static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;

    private ImportUtils() {
    }

    public static Map<EObject, MergeAction> reuseReplaceMap(Map<EObject, EObject> map, ImportStrategy strategy) {
        HashMap<EObject, MergeAction> reuseReplace = new HashMap<EObject, MergeAction>();
        for (Map.Entry<EObject, EObject> entry : map.entrySet()) {
            EObject element = entry.getKey();
            EObject original = entry.getValue();
            if (original == null) continue;
            MergeAction action = strategy.decideMergeOrReplace(element, original);
            if (action != null) {
                reuseReplace.put(original, action);
                continue;
            }
            throw new ImportCancelledException();
        }
        return reuseReplace;
    }

    public static Map<EObject, MergeAction> reuseReplaceMap(Map<EObject, EObject> map) {
        HashMap<EObject, MergeAction> reuseReplace = new HashMap<EObject, MergeAction>();
        for (Map.Entry<EObject, EObject> entry : map.entrySet()) {
            EObject original = entry.getValue();
            if (original == null) continue;
            MergeAction action = MergeAction.REPLACE;
            reuseReplace.put(original, action);
        }
        return reuseReplace;
    }

    public static String getLabel(EObject eObject) {
        String name = MergeUtils.getName((EObject)eObject);
        return name == null ? MergeUtils.getId((EObject)eObject) : name;
    }

    public static List<IObjectDescriptor> createObjectDescriptors(IconFactory iconFactory, ModelType model, URI uri) {
        ArrayList<IObjectDescriptor> types = new ArrayList<IObjectDescriptor>();
        TypeDeclarationsType typeDeclarations = model.getTypeDeclarations();
        EList elements = Collections.emptyList();
        if (typeDeclarations != null) {
            elements = typeDeclarations.getTypeDeclaration();
        }
        ImportUtils.addElements(iconFactory, types, (List<? extends EObject>)elements, uri);
        ArrayList<IObjectDescriptor> applications = new ArrayList<IObjectDescriptor>();
        ImportUtils.addElements(iconFactory, applications, (List<? extends EObject>)model.getApplication(), uri);
        ArrayList<IObjectDescriptor> data = new ArrayList<IObjectDescriptor>();
        ImportUtils.addElements(iconFactory, data, (List<? extends EObject>)model.getData(), uri);
        ArrayList<IObjectDescriptor> participants = new ArrayList<IObjectDescriptor>();
        ImportUtils.addElements(iconFactory, participants, (List<? extends EObject>)model.getRole(), uri);
        ImportUtils.addElements(iconFactory, participants, (List<? extends EObject>)model.getOrganization(), uri);
        ImportUtils.addElements(iconFactory, participants, (List<? extends EObject>)model.getConditionalPerformer(), uri);
        ArrayList<IObjectDescriptor> result = new ArrayList<IObjectDescriptor>();
        String bundleId = "org.eclipse.stardust.modeling.core";
        if (!types.isEmpty()) {
            result.add(new CategoryDescriptor(uri.appendSegment("typeDeclaration"), "typeDeclarations", Repository_Messages.LBL_STRUCTURED_TYPES, types.toArray(new IObjectDescriptor[types.size()]), bundleId, iconFactory.getIconFor((EObject)typeDeclarations)));
        }
        if (!applications.isEmpty()) {
            result.add(new CategoryDescriptor(uri.appendSegment("applications"), "applications", Repository_Messages.LBL_APPLICATIONS, applications.toArray(new IObjectDescriptor[applications.size()]), bundleId, iconFactory.getIconFor((EObject)PKG_CWM.getApplicationType())));
        }
        if (!data.isEmpty()) {
            result.add(new CategoryDescriptor(uri.appendSegment("data"), "data", Repository_Messages.LBL_DATA, data.toArray(new IObjectDescriptor[data.size()]), bundleId, iconFactory.getIconFor((EObject)PKG_CWM.getDataType())));
        }
        if (!participants.isEmpty()) {
            result.add(new CategoryDescriptor(uri.appendSegment("participants"), "participants", Repository_Messages.LBL_PARTICIPANTS, participants.toArray(new IObjectDescriptor[participants.size()]), bundleId, iconFactory.getIconFor((EObject)PKG_CWM.getIModelParticipant())));
        }
        ImportUtils.addElements(iconFactory, result, (List<? extends EObject>)model.getProcessDefinition(), uri);
        return result;
    }

    private static void addElements(IconFactory iconFactory, List<IObjectDescriptor> descriptors, List<? extends EObject> elements, URI uri) {
        for (EObject eObject : elements) {
            String icon = iconFactory.getIconFor(eObject);
            String bundleId = "org.eclipse.stardust.modeling.core";
            if (icon != null && icon.length() > 0 && icon.charAt(0) == '{') {
                int ix = icon.indexOf(125, 1);
                bundleId = icon.substring(1, ix);
                icon = icon.substring(ix + 1);
            }
            EObjectDescriptor descriptor = null;
            if (eObject instanceof IIdentifiableModelElement) {
                IIdentifiableModelElement identifiable = (IIdentifiableModelElement)eObject;
                if (identifiable instanceof DataType && ((DataType)identifiable).isPredefined() || identifiable instanceof RoleType && "Administrator".equals(((RoleType)identifiable).getId())) continue;
                descriptor = new ModelElementDescriptor(uri, identifiable, bundleId, icon, true);
            } else if (eObject instanceof TypeDeclarationType) {
                TypeDeclarationType decl = (TypeDeclarationType)eObject;
                descriptor = new EObjectDescriptor(MergeUtils.createQualifiedUri((URI)uri, (EObject)decl, (boolean)true), (EObject)decl, decl.getId(), decl.getName(), decl.getDescription(), bundleId, icon);
            }
            if (descriptor == null) continue;
            descriptors.add(descriptor);
        }
    }

    public static ExternalPackage getPackageRef(IObjectDescriptor descriptor, ModelType targetModel, ModelType sourceModel) {
        ExternalPackage pkg;
        XpdlFactory xFactory = XpdlFactory.eINSTANCE;
        String packageRef = sourceModel.getId();
        ExternalPackages packages = targetModel.getExternalPackages();
        if (packages == null) {
            packages = xFactory.createExternalPackages();
            targetModel.setExternalPackages(packages);
        }
        if ((pkg = packages.getExternalPackage(packageRef)) == null) {
            pkg = xFactory.createExternalPackage();
            pkg.setId(packageRef);
            pkg.setName(sourceModel.getName());
            pkg.setHref(packageRef);
            if (descriptor != null) {
                LinkAttribute linkAttribute = new LinkAttribute(descriptor.getURI().trimSegments(2), false, false, "carnot:connection:uri");
                linkAttribute.setLinkInfo((EObject)pkg, false);
            }
            packages.getExternalPackage().add((Object)pkg);
        }
        return pkg;
    }
}

