/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.authorization;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.authorization.ParticipantReference;

public class Permission {
    public static final String SCOPE = "authorization:";
    private String id;
    private String name;
    private boolean isALL = false;
    private boolean isOWNER = false;
    private ArrayList<ParticipantReference> participants = new ArrayList();
    private boolean defaultALL = false;
    private boolean defaultOWNER = false;
    private ArrayList<IModelParticipant> defaultParticipants = new ArrayList();
    private boolean fixedALL = false;
    private boolean fixedOWNER = false;
    private ArrayList<IModelParticipant> fixedParticipants = new ArrayList();

    public Permission(IConfigurationElement config, IExtensibleElement element) {
        String fixedParticipantName;
        this.id = String.valueOf(config.getAttribute("scope")) + "." + config.getAttribute("id");
        this.name = config.getAttribute("name");
        String baseName = SCOPE + this.getId();
        EList attributes = element.getAttribute();
        boolean isSet = false;
        int i = 0;
        while (i < attributes.size()) {
            AttributeType attribute = (AttributeType)attributes.get(i);
            if (attribute.getName().startsWith(baseName)) {
                isSet = true;
                if ("__carnot_internal_all_permissions__".equals(attribute.getValue())) {
                    this.isALL = true;
                } else if ("__carnot_internal_owner_permission__".equals(attribute.getValue())) {
                    this.isOWNER = true;
                } else {
                    EObject referenceElement = AttributeUtil.getReferenceElement((AttributeType)attribute);
                    if (referenceElement instanceof IModelParticipant) {
                        this.participants.add(new ParticipantReference(this, (IModelParticipant)referenceElement));
                    }
                }
            }
            ++i;
        }
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        String defaultParticipantName = config.getAttribute("defaultParticipant");
        if (defaultParticipantName != null) {
            if ("All".equals(defaultParticipantName)) {
                this.defaultALL = true;
            } else if ("Owner".equals(defaultParticipantName)) {
                this.defaultOWNER = true;
            } else {
                IModelParticipant participant = (IModelParticipant)ModelUtils.findIdentifiableElement((List)model.getRole(), (String)defaultParticipantName);
                if (participant == null) {
                    participant = (IModelParticipant)ModelUtils.findIdentifiableElement((List)model.getOrganization(), (String)defaultParticipantName);
                }
                if (participant != null) {
                    this.defaultParticipants.add(participant);
                }
            }
        }
        if ((fixedParticipantName = config.getAttribute("fixed")) != null) {
            if ("All".equals(fixedParticipantName)) {
                this.fixedALL = true;
            } else if ("Owner".equals(fixedParticipantName)) {
                this.fixedOWNER = true;
            } else {
                IModelParticipant participant = (IModelParticipant)ModelUtils.findIdentifiableElement((List)model.getRole(), (String)fixedParticipantName);
                if (participant == null) {
                    participant = (IModelParticipant)ModelUtils.findIdentifiableElement((List)model.getOrganization(), (String)fixedParticipantName);
                }
                if (participant != null) {
                    this.fixedParticipants.add(participant);
                }
            }
        }
        if (!isSet) {
            this.restoreDefaults();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " (" + this.getId() + ')';
    }

    public boolean contains(IModelParticipant participant) {
        for (IModelParticipant reference : this.fixedParticipants) {
            if (participant != reference) continue;
            return true;
        }
        return this.find(participant) != null;
    }

    public void removeParticipant(IModelParticipant participant) {
        ParticipantReference reference = this.find(participant);
        if (reference != null) {
            this.participants.remove(reference);
        }
    }

    private ParticipantReference find(IModelParticipant participant) {
        for (ParticipantReference reference : this.participants) {
            if (participant != reference.getParticipant()) continue;
            return reference;
        }
        return null;
    }

    public void setALL() {
        this.isALL = true;
        this.participants.clear();
    }

    public void setOWNER() {
        this.isALL = false;
        this.isOWNER = true;
    }

    public void unsetALL() {
        this.isALL = false;
    }

    public void unsetOWNER() {
        this.isOWNER = false;
    }

    public boolean isALL() {
        return this.isALL || this.fixedALL;
    }

    public boolean isOWNER() {
        return this.isOWNER || this.fixedOWNER;
    }

    public boolean isFixedOWNER() {
        return this.fixedOWNER;
    }

    public void save(IExtensibleElement element) {
        String baseName = SCOPE + this.getId();
        if (this.isALL) {
            this.createAttribute(element, baseName, "__carnot_internal_all_permissions__");
        } else {
            if (this.isOWNER) {
                this.createAttribute(element, baseName, "__carnot_internal_owner_permission__");
            }
            int i = 0;
            while (i < this.participants.size()) {
                String attrName = String.valueOf(baseName) + '[' + i + ']';
                ParticipantReference reference = this.participants.get(i);
                if (reference.getParticipant() != null) {
                    this.createAttribute(element, attrName, reference.getParticipant());
                }
                ++i;
            }
        }
    }

    private void createAttribute(IExtensibleElement element, String attrName, String value) {
        AttributeType attribute = CarnotWorkflowModelFactory.eINSTANCE.createAttributeType();
        attribute.setName(attrName);
        attribute.setValue(value);
        element.getAttribute().add((Object)attribute);
    }

    private void createAttribute(IExtensibleElement element, String attrName, IModelParticipant participant) {
        AttributeType attribute = CarnotWorkflowModelFactory.eINSTANCE.createAttributeType();
        attribute.setName(attrName);
        element.getAttribute().add((Object)attribute);
        AttributeUtil.setReference((AttributeType)attribute, (EObject)participant);
    }

    public void restoreDefaults() {
        this.isALL = this.defaultALL;
        this.isOWNER = this.defaultOWNER;
        this.participants.clear();
        for (IModelParticipant participant : this.defaultParticipants) {
            this.participants.add(new ParticipantReference(this, participant));
        }
    }

    public boolean isEmpty() {
        return this.participants.isEmpty() && !this.isOWNER;
    }

    public void addParticipant(IModelParticipant participant) {
        this.isALL = false;
        this.participants.add(new ParticipantReference(this, participant));
    }

    public boolean isDefaultAll() {
        return this.defaultALL || this.fixedALL;
    }

    public boolean isDefaultOwner() {
        return this.defaultOWNER || this.fixedOWNER;
    }

    public boolean isDefault(IModelParticipant participant) {
        for (IModelParticipant reference : this.fixedParticipants) {
            if (participant != reference) continue;
            return true;
        }
        return this.defaultParticipants.contains(participant);
    }

    public void setDefault(IModelParticipant participant) {
        this.defaultALL = false;
        this.defaultOWNER = false;
        this.defaultParticipants.clear();
        this.defaultParticipants.add(participant);
    }

    public List<IModelParticipant> getDefaultParticipants() {
        return this.defaultParticipants;
    }

    public List<IModelParticipant> getFixedParticipants() {
        return this.fixedParticipants;
    }

    public List<IModelParticipant> getParticipants() {
        ArrayList<IModelParticipant> result = new ArrayList<IModelParticipant>();
        for (ParticipantReference reference : this.participants) {
            if (reference.getParticipant() == null) continue;
            result.add(reference.getParticipant());
        }
        return result;
    }
}

