/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.swt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.swt.MetadataManager;
import org.eclipse.stardust.modeling.common.ui.swt.ObjectTable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ComplexAttributeUtils {
    public static void selectValuesInTable(IExtensibleElement element, String property, Table table, String identificationMethodName) {
        String value;
        int n = 0;
        ArrayList<String> list = new ArrayList<String>();
        while ((value = AttributeUtil.getAttributeValue((IExtensibleElement)element, (String)(String.valueOf(property) + "[" + n + "]"))) != null) {
            list.add(value);
            ++n;
        }
        TableItem[] items = table.getItems();
        TableItem[] selectedItems = new TableItem[list.size()];
        Method identificationMethod = null;
        n = 0;
        int m = 0;
        while (m < items.length) {
            if (identificationMethod == null) {
                try {
                    identificationMethod = items[m].getData().getClass().getMethod(identificationMethodName, null);
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
            Object object = items[m].getData();
            int l = 0;
            while (l < list.size()) {
                String applicationID = (String)list.get(l);
                try {
                    if (applicationID.equals(identificationMethod.invoke(object, null))) {
                        selectedItems[n] = items[m];
                        ++n;
                        break;
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                ++l;
            }
            ++m;
        }
        table.setSelection(selectedItems);
    }

    public static void getSelectedValuesFromTable(IExtensibleElement element, String property, Table table, String identificationMethodName) {
        TableItem[] selectedItems = table.getSelection();
        Method identificationMethod = null;
        int n = 0;
        while (n < selectedItems.length) {
            if (identificationMethod == null) {
                try {
                    identificationMethod = selectedItems[n].getData().getClass().getMethod(identificationMethodName, null);
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
            Object object = selectedItems[n].getData();
            try {
                AttributeUtil.setAttribute((IExtensibleElement)element, (String)(String.valueOf(property) + "[" + n + "]"), (String)identificationMethod.invoke(object, null).toString());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            ++n;
        }
    }

    public static void setValuesInObjectTable(IExtensibleElement element, String property, ObjectTable objectTable) {
        int n = 0;
        ArrayList<Object> list = new ArrayList<Object>();
        while (true) {
            Object object = null;
            int m = 0;
            while (m < objectTable.getPropertyNames().length) {
                String value = AttributeUtil.getAttributeValue((IExtensibleElement)element, (String)(String.valueOf(property) + "[" + n + "]." + objectTable.getPropertyNames()[m]));
                if (value != null) {
                    if (object == null) {
                        object = objectTable.createObject();
                        list.add(object);
                    }
                    objectTable.setValueFromString(object, m + 1, value);
                }
                ++m;
            }
            if (object == null) {
                objectTable.setObjects(list);
                return;
            }
            ++n;
        }
    }

    public static void getValuesFromObjectTable(IExtensibleElement element, String property, ObjectTable table) {
        int k = 0;
        while (true) {
            String value = null;
            int m = 0;
            while (m < table.getPropertyNames().length) {
                value = AttributeUtil.getAttributeValue((IExtensibleElement)element, (String)(String.valueOf(property) + "[" + k + "]." + table.getPropertyNames()[m]));
                if (value == null) break;
                AttributeUtil.setAttribute((IExtensibleElement)element, (String)(String.valueOf(property) + "[" + k + "]." + table.getPropertyNames()[m]), null);
                ++m;
            }
            if (value == null) break;
            ++k;
        }
        int n = 0;
        while (n < table.getObjects().size()) {
            Object object = table.getObjects().get(n);
            int m = 0;
            while (m < table.getPropertyNames().length) {
                String value = table.getStringifiedValue(object, m + 1);
                if (value != null) {
                    AttributeUtil.setAttribute((IExtensibleElement)element, (String)(String.valueOf(property) + "[" + n + "]." + table.getPropertyNames()[m]), (String)value);
                }
                ++m;
            }
            ++n;
        }
    }

    public static List getListValues(IExtensibleElement element, String property, MetadataManager metadataManager) {
        int n = 0;
        ArrayList<Object> list = new ArrayList<Object>();
        while (true) {
            Object object = null;
            int m = 0;
            while (m < metadataManager.getPropertyNames().length) {
                String value = AttributeUtil.getAttributeValue((IExtensibleElement)element, (String)(String.valueOf(property) + "[" + n + "]." + metadataManager.getPropertyNames()[m]));
                if (value != null) {
                    if (object == null) {
                        object = metadataManager.createObject();
                        list.add(object);
                    }
                    metadataManager.setPropertyFromString(object, m, value);
                }
                ++m;
            }
            if (object == null) {
                return list;
            }
            ++n;
        }
    }
}

