/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.swt;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.stardust.model.xpdl.carnot.Model_Messages;
import org.eclipse.stardust.modeling.common.ui.swt.DateCellEditor;
import org.eclipse.stardust.modeling.common.ui.swt.IObjectTableChangeListener;
import org.eclipse.stardust.modeling.common.ui.swt.MetadataManager;
import org.eclipse.stardust.modeling.common.ui.swt.MultiLineTableCellListener;
import org.eclipse.stardust.modeling.common.ui.swt.TableRowToolTipListener;
import org.eclipse.stardust.modeling.common.ui.swt.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ObjectTable
extends Composite {
    public static final int NULL = 0;
    public static final int ADD_ROW = 1;
    public static final int DELETE_BUTTON = 4;
    public static final int NUMBER_COLUMN = 8;
    public static final int SHOW_HEADERS = 16;
    public static final int EDITABLE = 32;
    public static final int MULTI_LINE_EDITOR = 64;
    private int style;
    private int tableStyle;
    private Table table;
    private List objects;
    private Class type;
    private Image[] defaultIcons;
    private Button deleteButton;
    private MetadataManager metadataManager;
    private List changeListeners;

    public ObjectTable(Composite parent, int style, int tableStyle, Class type, String[] columnProperties, String[] columnNames, int[] alignments, int[] widths, Image[] defaultIcons) {
        super(parent, 0);
        this.style = style;
        this.tableStyle = tableStyle;
        this.objects = new ArrayList();
        this.changeListeners = new ArrayList();
        if ((style & 8) == 8 && defaultIcons != null) {
            this.defaultIcons = new Image[defaultIcons.length + 1];
            this.defaultIcons[0] = null;
            int n = 0;
            while (n < defaultIcons.length) {
                this.defaultIcons[n + 1] = defaultIcons[n];
                ++n;
            }
        } else {
            this.defaultIcons = defaultIcons;
        }
        this.metadataManager = new MetadataManager(type, columnProperties);
        this.type = type;
        this.createContent(columnNames, alignments, widths);
        if ((style & 1) == 1) {
            this.createAddEntryRow();
        }
    }

    public void addChangeListeners(IObjectTableChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListeners(IObjectTableChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private void createContent(String[] columnNames, int[] alignments, int[] widths) {
        FormLayout layout = new FormLayout();
        this.setLayout((Layout)layout);
        this.table = new Table((Composite)this, this.tableStyle);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = (this.style & 4) == 4 ? new FormAttachment(95, 0) : new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible((this.style & 0x10) == 16);
        if ((this.style & 0x40) == 64) {
            new MultiLineTableCellListener(this.table);
        }
        if ((this.style & 8) == 8) {
            TableColumn number = new TableColumn(this.table, 131072);
            number.setText("");
            number.setWidth(25);
        }
        int n = 0;
        while (n < columnNames.length) {
            TableColumn column = new TableColumn(this.table, alignments[n]);
            column.setText(columnNames[n]);
            column.setWidth(widths[n]);
            if ((this.style & 0x20) == 32) {
                this.addEditor(n);
            }
            ++n;
        }
        if ((this.style & 4) == 4) {
            Composite buttonComposite = new Composite((Composite)this, 0);
            data = new FormData();
            data.left = new FormAttachment((Control)this.table, 10, 131072);
            data.right = new FormAttachment(100, -5);
            data.top = new FormAttachment((Control)this.table, 0, 128);
            buttonComposite.setLayoutData((Object)data);
            FillLayout buttonLayout = new FillLayout(512);
            buttonLayout.spacing = 5;
            buttonComposite.setLayout((Layout)buttonLayout);
            this.deleteButton = new Button(buttonComposite, 0);
            this.deleteButton.setText("X");
            this.deleteButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ObjectTable.this.removeSelected();
                }
            });
        }
    }

    public Table getTable() {
        return this.table;
    }

    public Class getType() {
        return this.type;
    }

    public List getObjects() {
        return this.objects;
    }

    public String[] getPropertyNames() {
        return this.metadataManager.getPropertyNames();
    }

    public void setObjects(List objects) {
        this.objects = objects;
        this.table.removeAll();
        int n = 0;
        while (n < objects.size()) {
            this.populateTableItem(new TableItem(this.table, 0), objects.get(n));
            ++n;
        }
        if ((this.style & 1) == 1) {
            this.createAddEntryRow();
        }
    }

    public void populateTableItem(TableItem item, Object object) {
        item.setData(object);
        item.setImage(this.defaultIcons);
        String[] values = null;
        int start = 0;
        if ((this.style & 8) == 8) {
            values = new String[this.metadataManager.getPropertyNames().length + 1];
            values[0] = "" + this.table.getItemCount();
            ++start;
        } else {
            values = new String[this.metadataManager.getPropertyNames().length];
        }
        int m = 0;
        while (m < this.metadataManager.getPropertyNames().length) {
            String value = this.metadataManager.getStringifiedValue(object, m);
            values[start] = value != null ? value : "";
            ++start;
            ++m;
        }
        item.setText(values);
    }

    public void createAddEntryRow() {
        TableItem item = new TableItem(this.table, 0);
        String[] values = new String[this.table.getColumnCount()];
        int n = 0;
        while (n < this.table.getColumnCount()) {
            if (n == 0) {
                values[n] = "" + this.table.getItemCount();
            }
            values[n] = n == 1 ? Model_Messages.NEW_ENTRY : "";
            ++n;
        }
        item.setText(values);
    }

    public void setTooltipProperty(String name) {
        new TableRowToolTipListener(this.table, this.type, name);
    }

    public Object createObject() {
        return this.metadataManager.createObject();
    }

    public void addObject(Object object) {
        this.getObjects().add(object);
        this.setObjects(this.objects);
    }

    protected void addObjectViaEditing(Object object) {
        this.objects.add(object);
        TableItem item = this.table.getItem(this.table.getItemCount() - 1);
        this.populateTableItem(item, object);
        this.createAddEntryRow();
        for (IObjectTableChangeListener changeListener : this.changeListeners) {
            changeListener.objectAdded(object);
        }
    }

    public void setValueFromString(Object object, int columnIndex, String value) {
        if ((this.style & 8) == 8) {
            --columnIndex;
        }
        this.metadataManager.setPropertyFromString(object, columnIndex, value);
        for (IObjectTableChangeListener changeListener : this.changeListeners) {
            changeListener.objectChanged(object);
        }
    }

    public String getStringifiedValue(Object object, int columnIndex) {
        if ((this.style & 8) == 8) {
            --columnIndex;
        }
        return this.metadataManager.getStringifiedValue(object, columnIndex);
    }

    private void addEditor(int index) {
        int offset = 0;
        if ((this.style & 8) == 8) {
            offset = 1;
        }
        if (this.metadataManager.getType(index) == Date.class) {
            new DateCellEditor(this, index + offset);
        } else {
            new TextCellEditor(this, index + offset);
        }
    }

    public void removeSelected() {
        boolean addEntryRowSelected = false;
        int n = 0;
        while (n < this.table.getSelectionCount()) {
            Object object = this.table.getSelection()[n].getData();
            if (object != null) {
                this.objects.remove(object);
                for (IObjectTableChangeListener changeListener : this.changeListeners) {
                    changeListener.objectRemoved(object);
                }
            } else {
                addEntryRowSelected = true;
            }
            ++n;
        }
        this.table.remove(this.table.getSelectionIndices());
        if (addEntryRowSelected) {
            this.createAddEntryRow();
        }
    }
}

