/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ActivityImplementationType implements Enumerator
{
    ROUTE_LITERAL(0, "Route", "Route"),
    MANUAL_LITERAL(1, "Manual", "Manual"),
    APPLICATION_LITERAL(2, "Application", "Application"),
    SUBPROCESS_LITERAL(3, "Subprocess", "Subprocess");

    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    public static final int ROUTE = 0;
    public static final int MANUAL = 1;
    public static final int APPLICATION = 2;
    public static final int SUBPROCESS = 3;
    private static final ActivityImplementationType[] VALUES_ARRAY;
    public static final List<ActivityImplementationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ActivityImplementationType[]{ROUTE_LITERAL, MANUAL_LITERAL, APPLICATION_LITERAL, SUBPROCESS_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ActivityImplementationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActivityImplementationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActivityImplementationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActivityImplementationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActivityImplementationType get(int value) {
        switch (value) {
            case 0: {
                return ROUTE_LITERAL;
            }
            case 1: {
                return MANUAL_LITERAL;
            }
            case 2: {
                return APPLICATION_LITERAL;
            }
            case 3: {
                return SUBPROCESS_LITERAL;
            }
        }
        return null;
    }

    private ActivityImplementationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

