/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;

public class ModelVariable
implements Cloneable {
    private String id;
    private String name;
    private String defaultValue;
    private String description;
    private boolean removed;

    public ModelVariable(String name, String defaultValue, String description) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.description = description;
        this.id = null;
    }

    public ModelVariable() {
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getStrippedName() {
        String strippedName = this.getName();
        strippedName = strippedName.replace("${", "");
        strippedName = strippedName.replace("}", "");
        return strippedName;
    }

    public String getType() {
        if (this.name.startsWith("${")) {
            this.name = this.name.substring(2, this.name.length() - 1);
        }
        return VariableContextHelper.getType(this.name);
    }

    public void setName(String name) {
        this.name = name;
        if (this.id == null) {
            this.id = name;
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public ModelVariable clone() {
        return new ModelVariable(new String(this.name), new String(this.defaultValue), new String(this.description));
    }
}

