/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.annotations;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stardust.modeling.data.structured.annotations.ConfigurationItem;
import org.eclipse.stardust.modeling.data.structured.annotations.ElementAnnotation;
import org.eclipse.stardust.modeling.data.structured.annotations.GenericElementAdapter;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotation;
import org.eclipse.xsd.XSDFeature;
import org.w3c.dom.Attr;

public class AttributeAnnotation
extends ConfigurationItem
implements IAnnotation {
    private ElementAnnotation parentElement;

    public AttributeAnnotation(ElementAnnotation parentElement, IConfigurationElement config) {
        super(config);
        this.parentElement = parentElement;
    }

    public boolean canModify() {
        return true;
    }

    @Override
    public boolean exists() {
        XSDFeature element = this.getElement();
        return this.getAttribute(element, false, false) != null || this.getAttribute(element, false, true) != null;
    }

    @Override
    public List<IAnnotation> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public IAnnotation getParent() {
        return this.parentElement;
    }

    private Attr getAttribute(XSDFeature element, boolean create, boolean forceInternal) {
        String name;
        if (create && forceInternal) {
            return null;
        }
        Attr attribute = null;
        GenericElementAdapter parentAdapter = this.parentElement.getElementAdapter(element, create, forceInternal);
        if (parentAdapter != null && (attribute = parentAdapter.getAttribute(name = this.getConfigurationAttribute("name"))) == null && create) {
            attribute = parentAdapter.createAttribute(name);
        }
        return attribute;
    }

    @Override
    public String getRawValue() {
        return this.getRawValue(this.getElement());
    }

    @Override
    public String getRawValue(XSDFeature element) {
        Attr attribute = this.getAttribute(element, false, false);
        if (attribute == null) {
            attribute = this.getAttribute(element, false, true);
        }
        return attribute == null ? null : attribute.getValue();
    }

    @Override
    public void setRawValue(String value) {
        XSDFeature element = this.getElement();
        this.setRawValue(element, value);
    }

    @Override
    public void setRawValue(XSDFeature element, String value) {
        if (value == null) {
            GenericElementAdapter parentAdapter = this.parentElement.getElementAdapter(element, false, false);
            if (parentAdapter != null) {
                parentAdapter.removeAttribute(this.getConfigurationAttribute("name"), this.parentElement.getNamespace());
            }
        } else {
            Attr attribute = this.getAttribute(element, true, false);
            attribute.setValue(value);
        }
        if (element == this.getElement()) {
            this.validate();
        }
    }

    public boolean delete() {
        String name;
        Attr attribute;
        XSDFeature element = this.getElement();
        GenericElementAdapter parentAdapter = this.parentElement.getElementAdapter(element, false, false);
        if (parentAdapter != null && (attribute = parentAdapter.getAttribute(name = this.getConfigurationAttribute("name"))) != null) {
            parentAdapter.removeAttribute(name, this.parentElement.getNamespace());
            return true;
        }
        return false;
    }

    @Override
    public XSDFeature getElement() {
        IAnnotation parent = this.getParent();
        return parent == null ? null : parent.getElement();
    }
}

