/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.projectnature.classpath;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.modeling.common.projectnature.Modeling_Core_Messages;
import org.osgi.framework.Bundle;

public class BpmCoreLibrariesClasspathContainer
implements IClasspathContainer {
    public static final Path PATH_BPM_CORE_LIBS_CP = new Path("org.eclipse.stardust.modeling.common.projectnature.carnotBpmCoreLibraries");
    public static final IClasspathEntry[] NO_CLASSPATH_ENTRIES = new IClasspathEntry[0];

    public IClasspathEntry[] getClasspathEntries() {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        this.addLibraryEntry(entries, "org.eclipse.stardust.ide.engine.base", "lib/carnot-base.jar");
        this.addLibraryEntry(entries, "org.eclipse.stardust.ide.engine.core", "lib/carnot-engine.jar");
        this.addLibraryEntry(entries, "org.eclipse.stardust.modeling.integration.webservices", "lib/stardust-engine-ws-cxf.jar");
        this.addLibraryEntry(entries, "org.eclipse.stardust.ide.thirdparty.runtime.j2ee", "lib/geronimo-jms_1.1_spec.jar");
        this.addLibraryEntry(entries, "org.eclipse.stardust.ide.thirdparty.runtime.j2ee", "lib/geronimo-ejb_2.1_spec.jar");
        this.addLibraryEntry(entries, "org.eclipse.stardust.ide.thirdparty.runtime.xml", "xml-apis.jar");
        this.addLibraryEntry(entries, "org.eclipse.stardust.ide.thirdparty.runtime.xml", "lib/commons-jxpath.jar");
        this.addLibraryEntry(entries, "org.eclipse.stardust.ide.thirdparty.runtime.xml", "lib/xercesImpl.jar");
        this.addLibraryEntry(entries, "org.eclipse.stardust.ide.thirdparty.javax.activation", "lib/activation.jar");
        this.addLibraryEntry(entries, "org.eclipse.stardust.ide.thirdparty.javax.mail", "lib/mail.jar");
        this.addLibraryEntry(entries, "org.eclipse.stardust.ide.thirdparty.cxf", "lib/cxf-api.jar");
        this.addLibraryEntry(entries, "org.eclipse.stardust.ide.thirdparty.javax.jcr", "lib/jcr.jar");
        return entries.toArray(NO_CLASSPATH_ENTRIES);
    }

    public int getKind() {
        return 1;
    }

    public String getDescription() {
        return "Infinity BPM Core Libraries";
    }

    public IPath getPath() {
        return PATH_BPM_CORE_LIBS_CP;
    }

    private void addLibraryEntry(List<IClasspathEntry> entries, String bundleId, String element) {
        try {
            IPath libraryLocation = this.getLibraryLocation(bundleId, element);
            if (libraryLocation != null) {
                entries.add(JavaCore.newLibraryEntry((IPath)libraryLocation, null, null));
            }
        }
        catch (InternalException internalException) {}
    }

    private IPath getLibraryLocation(String bundleId, String element) {
        return BpmCoreLibrariesClasspathContainer.getLibraryLocation(bundleId, new String[]{element});
    }

    public static IPath getLibraryLocation(String bundleId, String[] elements) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            throw new InternalException(MessageFormat.format(Modeling_Core_Messages.MSG_BundleNotLoaded, bundleId));
        }
        String systemPath = "";
        boolean found = false;
        int idx = 0;
        while (idx < elements.length) {
            URL entryUrl = bundle.getEntry(elements[idx]);
            if (entryUrl != null) {
                try {
                    systemPath = Platform.asLocalURL((URL)entryUrl).getPath();
                    found = true;
                    break;
                }
                catch (IOException e) {
                    System.out.println(String.valueOf(Modeling_Core_Messages.MSG_FailedResolvingBundle) + e.getMessage());
                }
            }
            ++idx;
        }
        if (!found) {
            throw new InternalException(MessageFormat.format(Modeling_Core_Messages.MSG_BundleNotContain, bundleId, StringUtils.join(Arrays.asList(elements).iterator(), (String)", ")));
        }
        return new Path(systemPath);
    }
}

