/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug.views;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.InstructionPointerManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IInstructionPointerPresentation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.spi.dataTypes.struct.StructAccessPointType;
import org.eclipse.stardust.modeling.javascript.editor.JSCompilationUnitEditor;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationApplicationControlsManager;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MultipleAccessPathBrowserContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class TransformationMappingDebugView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.stardust.modeling.transformation.debug.views.TransformationMappingDebugView";
    private final MessageTransformationApplicationControlsManager controlsManager = new MessageTransformationApplicationControlsManager();
    private Composite parent;
    private Composite baseComposite;
    private TableViewer viewer;
    private Action action1;
    private Action action2;
    private Action doubleClickAction;
    private IModelElement modelElement;

    public TransformationMappingDebugView() {
        this.registerLaunchListener();
    }

    public void initWithModelElemet(IModelElement modelElement) {
        if (this.modelElement == modelElement) {
            return;
        }
        this.modelElement = modelElement;
        if (this.baseComposite != null) {
            this.baseComposite.dispose();
            this.baseComposite = null;
        }
        this.baseComposite = FormBuilder.createComposite((Composite)this.parent, (int)1);
        if (modelElement == null) {
            Text text = FormBuilder.createText((Composite)this.baseComposite);
            text.setText("Works only in message transformation debug context.");
        } else {
            this.controlsManager.create(this.baseComposite, modelElement, false);
            this.controlsManager.getController().intializeModel(ModelUtils.findContainingModel((EObject)modelElement), null, modelElement);
            this.controlsManager.refreshModel();
            this.controlsManager.getController().initializeMappings(modelElement);
            this.controlsManager.getSourceMessageTreeViewer().refresh(true);
            this.controlsManager.getTargetMessageTreeViewer().refresh(true);
            this.controlsManager.refreshDocument();
        }
        this.parent.layout();
    }

    public void highlightLine(IStackFrame stackFrame) {
        JSCompilationUnitEditor expressionsEditor = this.controlsManager.getExpressionsEditor();
        LineCorrectionStackFrame delegatingStackFrame = new LineCorrectionStackFrame(stackFrame, expressionsEditor.getLineOffset());
        try {
            int lineNumber = delegatingStackFrame.getLineNumber();
            IRegion region = TransformationMappingDebugView.getLineInformation((ITextEditor)expressionsEditor, --lineNumber);
            if (region != null) {
                expressionsEditor.selectAndReveal(region.getOffset(), 0);
                IInstructionPointerPresentation fPresentation = (IInstructionPointerPresentation)DebugUITools.newDebugModelPresentation();
                Annotation annotation = fPresentation.getInstructionPointerAnnotation((IEditorPart)expressionsEditor, (IStackFrame)delegatingStackFrame);
                InstructionPointerManager.getDefault().addAnnotation((ITextEditor)expressionsEditor, (IStackFrame)delegatingStackFrame, annotation);
            }
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    private static IRegion getLineInformation(ITextEditor editor, int lineNumber) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        try {
            provider.connect((Object)input);
        }
        catch (CoreException coreException) {
            return null;
        }
        try {
            IDocument document = provider.getDocument((Object)input);
            if (document != null) {
                IRegion iRegion = document.getLineInformation(lineNumber);
                return iRegion;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            provider.disconnect((Object)input);
        }
        return null;
    }

    public void highlightOutMessageNode(String fieldPath) {
        int usedFieldPathSegmentCounter = 0;
        Iterator iter = StringUtils.split((String)fieldPath, (String)"/");
        if (!iter.hasNext()) {
            return;
        }
        TreeViewer target = this.controlsManager.getTargetMessageTreeViewer();
        MultipleAccessPathBrowserContentProvider contentProvider = (MultipleAccessPathBrowserContentProvider)target.getContentProvider();
        TreeItem[] items = target.getTree().getItems();
        String rootItemName = (String)iter.next();
        ++usedFieldPathSegmentCounter;
        TreeItem rootItem = null;
        int idx = 0;
        while (idx < items.length) {
            rootItem = items[idx];
            if (rootItemName.equals(rootItem.getText())) break;
            ++idx;
        }
        if (rootItem == null) {
            return;
        }
        ArrayList itemData = CollectionUtils.newArrayList();
        StructAccessPointType sap = (StructAccessPointType)rootItem.getData();
        itemData.add(sap);
        boolean hasChildren = contentProvider.hasChildren((Object)sap);
        block1: while (hasChildren && iter.hasNext()) {
            hasChildren = false;
            String nextItemName = (String)iter.next();
            ++usedFieldPathSegmentCounter;
            Object[] children = contentProvider.getChildren((Object)sap);
            int idx2 = 0;
            while (idx2 < children.length) {
                sap = (StructAccessPointType)children[idx2];
                if (sap.getId().equals(nextItemName)) {
                    itemData.add(sap);
                    hasChildren = contentProvider.hasChildren((Object)sap);
                    continue block1;
                }
                ++idx2;
            }
        }
        if (usedFieldPathSegmentCounter != itemData.size()) {
            return;
        }
        TreeSelection selection = (TreeSelection)target.getSelection();
        TreePath[] selectedPath = selection.getPathsFor(itemData.get(itemData.size() - 1));
        if (selectedPath.length == 0) {
            target.setSelection((ISelection)new TreeSelection(new TreePath(itemData.toArray())), true);
        }
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.initWithModelElemet(null);
    }

    public void setFocus() {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TransformationMappingDebugView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.action2);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                TransformationMappingDebugView.this.showMessage("Action 1 executed");
            }
        };
        this.action1.setText("Action 1");
        this.action1.setToolTipText("Action 1 tooltip");
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.action2 = new Action(){

            public void run() {
                TransformationMappingDebugView.this.showMessage("Action 2 executed");
            }
        };
        this.action2.setText("Action 2");
        this.action2.setToolTipText("Action 2 tooltip");
        this.action2.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = TransformationMappingDebugView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                TransformationMappingDebugView.this.showMessage("Double-click detected on " + obj.toString());
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TransformationMappingDebugView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Sample View", (String)message);
    }

    private void registerLaunchListener() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        if (launchManager != null) {
            launchManager.addLaunchListener(new ILaunchListener(){

                public void launchAdded(ILaunch launch) {
                }

                public void launchChanged(ILaunch launch) {
                }

                public void launchRemoved(ILaunch launch) {
                    TransformationMappingDebugView.this.initWithModelElemet(null);
                }
            });
        }
    }

    private static class LineCorrectionStackFrame
    implements IStackFrame {
        private final IStackFrame stackFrame;
        private final int lineOffset;

        public LineCorrectionStackFrame(IStackFrame stackFrame, int lineOffset) {
            this.stackFrame = stackFrame;
            this.lineOffset = lineOffset;
        }

        public boolean canResume() {
            return this.stackFrame.canResume();
        }

        public boolean canStepInto() {
            return this.stackFrame.canStepInto();
        }

        public boolean canStepOver() {
            return this.stackFrame.canStepOver();
        }

        public boolean canStepReturn() {
            return this.stackFrame.canStepReturn();
        }

        public boolean canSuspend() {
            return this.stackFrame.canSuspend();
        }

        public boolean canTerminate() {
            return this.stackFrame.canTerminate();
        }

        public Object getAdapter(Class adapter) {
            return this.stackFrame.getAdapter(adapter);
        }

        public int getCharEnd() throws DebugException {
            return this.stackFrame.getCharEnd();
        }

        public int getCharStart() throws DebugException {
            return this.stackFrame.getCharStart();
        }

        public IDebugTarget getDebugTarget() {
            return this.stackFrame.getDebugTarget();
        }

        public ILaunch getLaunch() {
            return this.stackFrame.getLaunch();
        }

        public int getLineNumber() throws DebugException {
            return this.stackFrame.getLineNumber() + this.lineOffset;
        }

        public String getModelIdentifier() {
            return this.stackFrame.getModelIdentifier();
        }

        public String getName() throws DebugException {
            return this.stackFrame.getName();
        }

        public IRegisterGroup[] getRegisterGroups() throws DebugException {
            return this.stackFrame.getRegisterGroups();
        }

        public IThread getThread() {
            return this.stackFrame.getThread();
        }

        public IVariable[] getVariables() throws DebugException {
            return this.stackFrame.getVariables();
        }

        public boolean hasRegisterGroups() throws DebugException {
            return this.stackFrame.hasRegisterGroups();
        }

        public boolean hasVariables() throws DebugException {
            return this.stackFrame.hasVariables();
        }

        public boolean isStepping() {
            return this.stackFrame.isStepping();
        }

        public boolean isSuspended() {
            return this.stackFrame.isSuspended();
        }

        public boolean isTerminated() {
            return this.stackFrame.isTerminated();
        }

        public void resume() throws DebugException {
            this.stackFrame.resume();
        }

        public void stepInto() throws DebugException {
            this.stackFrame.stepInto();
        }

        public void stepOver() throws DebugException {
            this.stackFrame.stepOver();
        }

        public void stepReturn() throws DebugException {
            this.stackFrame.stepReturn();
        }

        public void suspend() throws DebugException {
            this.stackFrame.suspend();
        }

        public void terminate() throws DebugException {
            this.stackFrame.terminate();
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return new String[]{"One", "Two", "Three"};
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

