/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LoopType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.MIOrderingType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractLabeledIconFigure;
import org.eclipse.stardust.modeling.core.editors.figures.ActivitySymbolFigure;
import org.eclipse.stardust.modeling.core.editors.figures.EventFigure;
import org.eclipse.stardust.modeling.core.editors.figures.IIconFigure;
import org.eclipse.stardust.modeling.core.editors.figures.ILabeledFigure;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdapter;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;

public class AbstractModelElementNodeSymbolEditPart
extends AbstractNodeSymbolEditPart {
    private NotificationAdapter modelElementNotificationAdapter;
    private Class figureClass;
    private EStructuralFeature[] sourceConnectionFeatures;
    private EStructuralFeature[] targetConnectionFeatures;

    public Command getCommand(Request request) {
        return super.getCommand(request);
    }

    public AbstractModelElementNodeSymbolEditPart(WorkflowModelEditor editor, IModelElementNodeSymbol model) {
        super(editor, (INodeSymbol)model);
    }

    public AbstractModelElementNodeSymbolEditPart(WorkflowModelEditor editor, IModelElementNodeSymbol model, Class figureClass, EStructuralFeature[] sourceConnectionFeatures, EStructuralFeature[] targetConnectionFeatures) {
        super(editor, (INodeSymbol)model);
        this.setFigureClass(figureClass);
        this.setSourceConnectionFeatures(sourceConnectionFeatures);
        this.setTargetConnectionFeatures(targetConnectionFeatures);
    }

    @Override
    protected void refreshFigure(IFigure figure) {
        super.refreshFigure(figure);
        if (figure instanceof ILabeledFigure) {
            TriggerType trigger;
            ActivityType activity;
            IModelElementNodeSymbol symbol = (IModelElementNodeSymbol)this.getModel();
            String name = null;
            IIdentifiableModelElement element = symbol.getModelElement();
            if (element != null) {
                name = element.getName();
                if (StringUtils.isEmpty((String)name)) {
                    name = element.getId();
                }
            } else {
                String string = name = symbol.getModelElement() != null ? symbol.getModelElement().getId() : null;
            }
            if (StringUtils.isEmpty((String)name) && element instanceof EObjectImpl && element.eIsProxy()) {
                name = ((EObjectImpl)element).eProxyURI().toString();
            }
            if (StringUtils.isEmpty((String)name)) {
                name = Diagram_Messages.MSG_EDITOR_unidentifiedModelElement;
            }
            ((ILabeledFigure)figure).setName(name);
            if (element instanceof ActivityType && this.getFigure() instanceof ActivitySymbolFigure && (activity = (ActivityType)element) != null) {
                ActivitySymbolFigure activityFigure = (ActivitySymbolFigure)figure;
                activityFigure.setLoopActivity(this.getLoopType(activity), this.isSequential(activity));
                activityFigure.setSubProcActivity(ActivityImplementationType.SUBPROCESS_LITERAL.equals((Object)activity.getImplementation()));
                activityFigure.setEventHandlerType(!activity.getEventHandler().isEmpty(), activity);
            }
            if (element instanceof TriggerType && this.getFigure() instanceof EventFigure && (trigger = (TriggerType)element) != null) {
                EventFigure eventFigure = (EventFigure)figure;
                eventFigure.setText(trigger.getName() == null ? trigger.getId() : trigger.getName());
            }
        }
        if (figure instanceof IIconFigure) {
            ((IIconFigure)figure).setIconPath(this.getIconFactory().getIconFor((EObject)this.getModelElement()));
        }
    }

    private boolean isSequential(ActivityType activity) {
        org.eclipse.stardust.model.xpdl.xpdl2.LoopType loop = activity.getLoop();
        return loop == null || loop.getLoopType() != LoopTypeType.MULTI_INSTANCE || loop.getLoopMultiInstance() != null && loop.getLoopMultiInstance().getMIOrdering() != MIOrderingType.PARALLEL;
    }

    private LoopTypeType getLoopType(ActivityType activity) {
        org.eclipse.stardust.model.xpdl.xpdl2.LoopType loop = activity.getLoop();
        if (loop == null) {
            LoopType loopType = activity.getLoopType();
            if (loopType != null && (loopType == LoopType.REPEAT_LITERAL || loopType == LoopType.WHILE_LITERAL)) {
                return LoopTypeType.STANDARD;
            }
        } else {
            return loop.getLoopType();
        }
        return null;
    }

    @Override
    protected EStructuralFeature getDirectEditFeature() {
        if (this.getModelElement() instanceof IIdentifiableModelElement) {
            if (this.getModel() instanceof IModelElementNodeSymbol && ((IModelElementNodeSymbol)this.getModel()).getModelElement() != null && ((IModelElementNodeSymbol)this.getModel()).getModelElement() instanceof DataType && ((DataType)((IModelElementNodeSymbol)this.getModel()).getModelElement()).isPredefined()) {
                return null;
            }
            return CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Name();
        }
        return super.getDirectEditFeature();
    }

    @Override
    public Object getAdapter(Class key) {
        Object result = null;
        result = IModelElementNodeSymbol.class.equals((Object)key) || IModelElement.class.equals((Object)key) ? this.getModel() : super.getAdapter(key);
        return result;
    }

    @Override
    public void activate() {
        if (!this.isActive()) {
            super.activate();
            IModelElement model = this.getModelElement();
            if (model != null) {
                model.eAdapters().add((Object)this.getModelElementNotificationAdapter());
            }
        }
    }

    @Override
    public void deactivate() {
        if (this.isActive()) {
            IModelElement model = this.getModelElement();
            if (model != null) {
                model.eAdapters().remove((Object)this.getModelElementNotificationAdapter());
            } else if (this.getModelElementNotificationAdapter().getTarget() != null) {
                this.getModelElementNotificationAdapter().getTarget().eAdapters().remove((Object)this.getModelElementNotificationAdapter());
            }
            super.deactivate();
        }
    }

    protected NotificationAdapter getModelElementNotificationAdapter() {
        if (this.modelElementNotificationAdapter == null) {
            this.modelElementNotificationAdapter = new NotificationAdapter(this);
        }
        return this.modelElementNotificationAdapter;
    }

    private IModelElement getModelElement() {
        IModelElementNodeSymbol symbol = (IModelElementNodeSymbol)this.getModel();
        return symbol == null ? null : symbol.getModelElement();
    }

    protected IFigure createFigure() {
        if (this.figureClass != null) {
            IModelElementNodeSymbol symbolModel = (IModelElementNodeSymbol)this.getModel();
            try {
                Figure f = (Figure)this.figureClass.newInstance();
                f.setLocation(new Point((double)symbolModel.getXPos(), (double)symbolModel.getYPos()));
                if (f instanceof ILabeledFigure) {
                    ((ILabeledFigure)f).setName(symbolModel.getModelElement() != null ? symbolModel.getModelElement().getId() : null);
                }
                if (f instanceof AbstractLabeledIconFigure) {
                    ((AbstractLabeledIconFigure)f).setIconPath(this.getIconFactory().getIconFor((EObject)this.getModel()));
                }
                return f;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Override
    public void handleNotification(Notification notification) {
        int i;
        EStructuralFeature eFtr = (EStructuralFeature)notification.getFeature();
        if (this.sourceConnectionFeatures != null) {
            i = 0;
            while (i < this.sourceConnectionFeatures.length) {
                if (eFtr == this.sourceConnectionFeatures[i]) {
                    this.refreshSourceConnections();
                    return;
                }
                ++i;
            }
        }
        if (this.targetConnectionFeatures != null) {
            i = 0;
            while (i < this.targetConnectionFeatures.length) {
                if (eFtr == this.targetConnectionFeatures[i]) {
                    this.refreshTargetConnections();
                    return;
                }
                ++i;
            }
        }
        super.handleNotification(notification);
    }

    public void setFigureClass(Class figureClass) {
        this.figureClass = figureClass;
    }

    @Override
    protected List getModelSourceConnections() {
        return this.isShowingConnections() ? this.getConnections(this.sourceConnectionFeatures, super.getModelSourceConnections()) : Collections.EMPTY_LIST;
    }

    @Override
    protected List getModelTargetConnections() {
        return this.isShowingConnections() ? this.getConnections(this.targetConnectionFeatures, super.getModelTargetConnections()) : Collections.EMPTY_LIST;
    }

    private List getConnections(EStructuralFeature[] connectionFeatures, List superConnections) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (connectionFeatures != null) {
            IModelElementNodeSymbol symbol = (IModelElementNodeSymbol)this.getModel();
            int i = 0;
            while (i < connectionFeatures.length) {
                Object connection = symbol.eGet(connectionFeatures[i]);
                if (connection instanceof Collection) {
                    result.addAll((Collection)connection);
                } else if (connection != null) {
                    result.add(connection);
                }
                ++i;
            }
        }
        result.addAll(superConnections);
        return result;
    }

    public void setSourceConnectionFeatures(EStructuralFeature[] sourceConnectionFeatures) {
        this.sourceConnectionFeatures = sourceConnectionFeatures;
    }

    public void setTargetConnectionFeatures(EStructuralFeature[] targetConnectionFeatures) {
        this.targetConnectionFeatures = targetConnectionFeatures;
    }
}

