/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.IdentifiableReference;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CommandUtils;
import org.eclipse.stardust.modeling.core.editors.parts.properties.LaneParticipantCommandFactory;
import org.eclipse.ui.PlatformUI;

public class SetSymbolContainerCommand
extends Command {
    private ISymbolContainer symbolContainer;
    private IGraphicalObject symbol;
    private EStructuralFeature symbolContainmentFeature;
    private Long symbolElementOidBackup;
    private CommandUtils.ContainmentState containmentBackup;
    private Command dependentCmd;
    private EditPart targetEditPart;

    public ISymbolContainer getContainer() {
        return this.symbolContainer;
    }

    public void setContainer(ISymbolContainer container, EditPart targetEditPart) {
        this.symbolContainer = container;
        this.targetEditPart = targetEditPart;
    }

    public IGraphicalObject getSymbol() {
        return this.symbol;
    }

    public void setSymbol(IGraphicalObject symbol) {
        this.symbol = symbol;
    }

    public void execute() {
        if (this.symbol != null) {
            if (this.symbol instanceof INodeSymbol) {
                this.symbolContainmentFeature = CommandUtils.findContainmentFeature(this.symbolContainer.getNodeContainingFeatures(), this.symbol);
            } else if (this.symbol instanceof IConnectionSymbol) {
                this.symbolContainmentFeature = CommandUtils.findContainmentFeature(this.symbolContainer.getConnectionContainingFeatures(), this.symbol);
            } else {
                throw new RuntimeException(this.symbol + Diagram_Messages.EX_isNeitherNodeNorConnectionSymbol);
            }
            this.symbolElementOidBackup = this.symbol.isSetElementOid() ? new Long(this.symbol.getElementOid()) : null;
            this.containmentBackup = CommandUtils.backupContainment((EObject)this.symbol);
            this.redo();
        }
    }

    public void redo() {
        if (this.symbol != null) {
            if (this.symbolContainer == null || this.symbolContainmentFeature == null) {
                throw new RuntimeException(String.valueOf(Diagram_Messages.EX_MissingNodeSymbolContainer) + this.symbol);
            }
            EList symbolContainment = (EList)this.symbolContainer.eGet(this.symbolContainmentFeature);
            if (this.dependentCmd == null) {
                this.dependentCmd = this.checkActivityPerformer((EObject)this.symbolContainer);
                this.dependentCmd = this.dependentCmd.canExecute() ? this.dependentCmd : this.checkManualTriggerPerformer((EObject)this.symbolContainer);
                this.dependentCmd.execute();
            } else {
                this.dependentCmd.redo();
            }
            symbolContainment.add((Object)this.symbol);
        }
    }

    public void undo() {
        if (this.symbol != null) {
            if (this.symbolContainer == null || this.symbolContainmentFeature == null) {
                throw new RuntimeException(String.valueOf(Diagram_Messages.EX_MissingSymbolContainer) + this.symbol);
            }
            this.dependentCmd.undo();
            EList symbolContainment = (EList)this.symbolContainer.eGet(this.symbolContainmentFeature);
            symbolContainment.remove((Object)this.symbol);
            CommandUtils.redoContainment(this.containmentBackup);
        }
    }

    private Command checkActivityPerformer(EObject newContainer) {
        CompoundCommand command = new CompoundCommand();
        if (this.symbol instanceof ActivitySymbolType) {
            ActivitySymbolType activitySymbol = (ActivitySymbolType)this.symbol;
            ActivityType activity = (ActivityType)activitySymbol.getModelElement();
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (activity != null && ActivityUtil.isInteractive((ActivityType)activity)) {
                IModelParticipant newPerformer;
                IModelParticipant originalPerformer = activity.getPerformer();
                EObject originalContainer = activitySymbol.eContainer();
                IModelParticipant iModelParticipant = newPerformer = originalContainer instanceof ISwimlaneSymbol ? null : originalPerformer;
                if (newContainer instanceof ISwimlaneSymbol && !DiagramUtil.isDefaultPool((ISwimlaneSymbol)((ISwimlaneSymbol)newContainer)) && this.changePerformer()) {
                    ISwimlaneSymbol swimlane = (ISwimlaneSymbol)newContainer;
                    while (swimlane.getParticipantReference() == null && swimlane.eContainer() instanceof ISwimlaneSymbol) {
                        swimlane = (ISwimlaneSymbol)swimlane.eContainer();
                    }
                    newPerformer = swimlane.getParticipantReference();
                    LaneParticipantCommandFactory.addSetPerformerCommands(command, activity, newPerformer, originalPerformer, false, this.targetEditPart);
                }
            }
        }
        return command;
    }

    public boolean changePerformer() {
        return true;
    }

    private Command checkManualTriggerPerformer(EObject newContainer) {
        StartEventSymbol startEventSymbol;
        TriggerType trigger;
        CompoundCommand command = new CompoundCommand();
        if (this.symbol instanceof StartEventSymbol && (trigger = (TriggerType)(startEventSymbol = (StartEventSymbol)this.symbol).getModelElement()) != null && ("scan".equals(trigger.getType().getId()) || "manual".equals(trigger.getType().getId()))) {
            EObject originalContainer;
            IModelParticipant newPerformer;
            IdentifiableReference reference;
            IModelParticipant originalPerformer = null;
            AttributeType performerAtt = AttributeUtil.getAttribute((IExtensibleElement)trigger, (String)"carnot:engine:participant");
            if (performerAtt != null && (reference = performerAtt.getReference()) != null) {
                originalPerformer = (IModelParticipant)reference.getIdentifiable();
            }
            IModelParticipant iModelParticipant = newPerformer = (originalContainer = startEventSymbol.eContainer()) instanceof ISwimlaneSymbol ? null : originalPerformer;
            if (newContainer instanceof ISwimlaneSymbol && this.changePerformer()) {
                ISwimlaneSymbol swimlane = (ISwimlaneSymbol)newContainer;
                while (swimlane.getParticipantReference() == null && swimlane.eContainer() instanceof ISwimlaneSymbol) {
                    swimlane = (ISwimlaneSymbol)swimlane.eContainer();
                }
                newPerformer = swimlane.getParticipantReference() != null ? swimlane.getParticipantReference() : newPerformer;
                LaneParticipantCommandFactory.addSetPerformerCommands(command, trigger, newPerformer, originalPerformer, performerAtt, false, this.targetEditPart);
            }
        }
        return command;
    }
}

