/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.model.xpdl.carnot.BindActionType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.UnbindActionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActionTypeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.NameIdUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateMetaTypeCommand;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.stardust.modeling.core.spi.IModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.spi.SpiPropertyPage;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.MetaTypeModelingUtils;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ActionTypePropertyPage
extends AbstractModelElementPropertyPage {
    protected LabeledText txtId;
    protected LabeledText txtName;
    private ComboViewer eventActionTypeCombo;
    private Composite spiArea;
    private StackLayout spiLayout;
    private Map spiPages = new HashMap();
    private Map spiControls = new HashMap();
    private IIdentifiableModelElement eventActionType;
    private Button[] buttons;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            String name = text.getText();
            if (GenericUtils.getAutoIdValue()) {
                String computedId = NameIdUtils.createIdFromName(null, (EObject)ActionTypePropertyPage.this.getModelElement(), (String)name);
                ActionTypePropertyPage.this.txtId.getText().setText(computedId);
            }
        }
    };

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.eventActionType = (IIdentifiableModelElement)element;
        this.txtName.getText().removeModifyListener(this.listener);
        WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        wBndMgr.bind(this.txtId, (EObject)element, (EStructuralFeature)PKG_CWM.getIIdentifiableElement_Id());
        wBndMgr.bind(this.txtName, (EObject)element, (EStructuralFeature)PKG_CWM.getIIdentifiableElement_Name());
        ((Combo)this.eventActionTypeCombo.getControl()).removeAll();
        IConfigurationElement type = this.addValidProcessActionsToCombo();
        this.eventActionTypeCombo.setSelection((ISelection)(type == null ? null : new StructuredSelection((Object)type)));
        wBndMgr.getModelBindingManager().updateWidgets((Object)element);
        this.txtName.getText().addModifyListener(this.listener);
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        SpiPropertyPage page = (SpiPropertyPage)this.spiPages.get(ActionTypeUtil.getActionTypeConfigurationElement((IIdentifiableModelElement)this.eventActionType));
        if (page != null) {
            page.loadElementFromFields(symbol, element);
        }
    }

    @Override
    public Control createBody(Composite content) {
        Composite composite = FormBuilder.createComposite((Composite)content, (int)2);
        this.txtName = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_Name);
        this.txtId = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_ID);
        boolean autoIdButtonValue = GenericUtils.getAutoIdValue();
        if (autoIdButtonValue) {
            this.txtId.getText().setEditable(false);
        }
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_FORMBUILDER_ActionType);
        Combo combo = FormBuilder.createCombo((Composite)composite);
        this.eventActionTypeCombo = new ComboViewer(combo);
        this.eventActionTypeCombo.setSorter(new ViewerSorter());
        this.eventActionTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IConfigurationElement type = (IConfigurationElement)element;
                return type.getAttribute("name");
            }
        });
        this.eventActionTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ActionTypePropertyPage.this.changeActionType(event.getSelection());
            }
        });
        this.spiArea = FormBuilder.createComposite((Composite)composite, (int)1, (int)2);
        this.spiLayout = new StackLayout();
        this.spiArea.setLayout((Layout)this.spiLayout);
        return composite;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
            manager.updateButtons(this.getModelElement(), this.buttons);
        }
        super.setVisible(visible);
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
        this.buttons = manager.createButtons(parent);
    }

    private IConfigurationElement addValidProcessActionsToCombo() {
        IConfigurationElement match = null;
        List supportedActions = ActionTypeUtil.getSupportedActionTypes((EventHandlerType)((EventHandlerType)this.eventActionType.eContainer()), (String)ActionTypeUtil.getContext((IModelElement)this.eventActionType));
        int i = 0;
        while (i < supportedActions.size()) {
            IConfigurationElement type = (IConfigurationElement)supportedActions.get(i);
            this.eventActionTypeCombo.add((Object)type);
            if (type.getAttribute("id").equals(ActionTypeUtil.getActionType((IModelElement)this.eventActionType).getId())) {
                match = type;
            }
            ++i;
        }
        return match;
    }

    protected void changeActionType(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IConfigurationElement type = (IConfigurationElement)((IStructuredSelection)selection).getFirstElement();
            ActionTypePropertyPage.setActionType(ModelUtils.findContainingModel((EObject)this.eventActionType), this.eventActionType, type);
            try {
                SpiPropertyPage page = (SpiPropertyPage)this.spiPages.get(type);
                if (page == null) {
                    page = type.getAttribute("propertyPageClass") == null ? this.getEmptyPage() : new SpiPropertyPage(new ConfigurationElement(type));
                    page.noDefaultAndApplyButton();
                    page.setContainer(this.getContainer());
                    page.setElement(this.getElement());
                    Composite composite = FormBuilder.createComposite((Composite)this.spiArea, (int)1);
                    composite.setLayout((Layout)new FillLayout());
                    page.createControl(composite);
                    this.registerValidation(page);
                    this.spiPages.put(type, page);
                    this.spiControls.put(type, composite);
                }
                page.elementChanged();
                this.spiLayout.topControl = (Control)this.spiControls.get(type);
                this.spiArea.layout();
            }
            catch (Exception ex) {
                DiagramPlugin.warn(ex.getMessage());
            }
        }
    }

    public static void setActionType(ModelType model, IIdentifiableModelElement element, IConfigurationElement config) {
        EventActionTypeType type = (EventActionTypeType)ModelUtils.findIdentifiableElement((List)model.getEventActionType(), (String)config.getAttribute("id"));
        if (type == null) {
            CreateMetaTypeCommand cmdAddConditionType = MetaTypeModelingUtils.getCreateEventActionTypeCmd(config);
            cmdAddConditionType.setParent((EObject)model);
            cmdAddConditionType.execute();
            type = (EventActionTypeType)cmdAddConditionType.getModelElement();
        }
        if (element instanceof EventActionType) {
            ((EventActionType)element).setType(type);
        } else if (element instanceof BindActionType) {
            ((BindActionType)element).setType(type);
        } else if (element instanceof UnbindActionType) {
            ((UnbindActionType)element).setType(type);
        }
    }

    private SpiPropertyPage getEmptyPage() {
        return new SpiPropertyPage(new IModelElementPropertyPage(){
            IAdaptable element;

            @Override
            public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
            }

            @Override
            public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
            }

            @Override
            public Control createBody(Composite parent) {
                return FormBuilder.createComposite((Composite)parent, (int)1);
            }

            @Override
            public void contributeButtons(Composite parent) {
            }

            @Override
            public void contributeVerticalButtons(Composite parent) {
            }

            @Override
            public IAdaptable getElement() {
                return this.element;
            }

            @Override
            public void setElement(IAdaptable element) {
                this.element = element;
            }

            @Override
            public void setContainer(IPreferencePageContainer container) {
            }

            @Override
            public void dispose() {
            }

            @Override
            public void setDelegateContainer(AbstractModelElementPropertyPage page) {
            }
        });
    }
}

