/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.PerformsConnectionType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteConnectionSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.properties.LaneParticipantCommandFactory;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.utils.IdentifiableViewerSorter;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class ActivityParticipantPropertyPage
extends AbstractModelElementPropertyPage {
    public static final String PARTICIPANT_ID = "_cwm_participant_";
    public static final String PARTICIPANT_LABEL = Diagram_Messages.PARTICIPANT_LABEL;
    private LabeledViewer labeledWidget;
    private IModelParticipant originalPerformer;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        ActivityType activity = (ActivityType)element;
        ModelType model = (ModelType)activity.eContainer().eContainer();
        TableViewer viewer = (TableViewer)this.labeledWidget.getViewer();
        viewer.getTable().removeAll();
        ArrayList participants = new ArrayList();
        participants.addAll(model.getRole());
        participants.addAll(model.getOrganization());
        participants.addAll(model.getConditionalPerformer());
        viewer.add(participants.toArray());
        WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        wBndMgr.bind(this.labeledWidget, (EObject)element, (EStructuralFeature)PKG_CWM.getActivityType_Performer());
        wBndMgr.getModelBindingManager().updateWidgets((Object)element);
        this.originalPerformer = activity.getPerformer();
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        ActivityType activity = (ActivityType)element;
        IModelParticipant newPerformer = activity.getPerformer();
        CompoundCommand command = new CompoundCommand();
        LaneParticipantCommandFactory.addSetPerformerCommands(command, activity, newPerformer, this.originalPerformer, true, null);
        if (newPerformer != null && newPerformer != this.originalPerformer && symbol != null) {
            ActivitySymbolType activitySymbol = (ActivitySymbolType)symbol;
            for (PerformsConnectionType performsConnection : activitySymbol.getPerformsConnections()) {
                if (!performsConnection.getParticipantSymbol().getModelElement().equals(this.originalPerformer)) continue;
                command.add((Command)new DeleteConnectionSymbolCmd((IConnectionSymbol)performsConnection));
            }
        }
        command.execute();
        this.originalPerformer = activity.getPerformer();
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        LabelWithStatus label = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.FORMBUILDER_LB_Participants);
        Table table = new Table(composite, 2048);
        table.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        tableViewer.setSorter((ViewerSorter)new IdentifiableViewerSorter());
        this.labeledWidget = new LabeledViewer((StructuredViewer)tableViewer, label);
        return composite;
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.UncheckButton, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IModelElement modelElement = (IModelElement)ActivityParticipantPropertyPage.this.getModelElement();
                if (modelElement instanceof ActivityType) {
                    ActivityType activity = (ActivityType)modelElement;
                    activity.setPerformer(null);
                    ActivityParticipantPropertyPage.this.originalPerformer = null;
                }
            }
        });
    }
}

