/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.ui.AccessPathBrowserContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class AccessPathBrowser
extends Dialog {
    private String selectedMethod = "";
    private String title;
    private ITypedElement accessPoint;
    private DirectionType direction;
    private boolean updateSelection;
    private AccessPathBrowserContentProvider provider;
    private WorkflowModelEditor editor;

    public AccessPathBrowser(WorkflowModelEditor editor, String title, ITypedElement accessPoint, DirectionType direction) {
        super(editor.getSite().getShell());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.editor = editor;
        this.title = title;
        this.accessPoint = accessPoint;
        this.direction = direction;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = 300;
        gd.minimumWidth = 320;
        gd.heightHint = 300;
        gd.widthHint = 320;
        Tree tree = FormBuilder.createTree((Composite)composite, (int)2816);
        final TreeViewer viewer = new TreeViewer(tree);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (AccessPathBrowser.this.updateSelection) {
                    AccessPathBrowser.this.updateSelection = false;
                    ISelection selection = AccessPathBrowser.this.provider.parseSelection(AccessPathBrowser.this.selectedMethod);
                    viewer.setSelection(selection, true);
                } else {
                    TreeItem[] selection = ((TreeViewer)event.getSource()).getTree().getSelection();
                    TreeItem methodItem = selection == null || selection.length == 0 ? null : selection[0];
                    AccessPathBrowser.this.checkCanClose(methodItem);
                    AccessPathBrowser.this.selectedMethod = AccessPathBrowser.this.getMethodPath(methodItem);
                }
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeItem methodItem = viewer.getTree().getSelection()[0];
                if (methodItem.getItems().length < 1) {
                    AccessPathBrowser.this.checkCanClose(methodItem);
                    AccessPathBrowser.this.selectedMethod = AccessPathBrowser.this.getMethodPath(methodItem);
                    if (AccessPathBrowser.this.getButton(0).isEnabled()) {
                        AccessPathBrowser.this.close();
                    }
                } else {
                    Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (viewer.getExpandedState(obj)) {
                        viewer.collapseToLevel(obj, 1);
                    } else {
                        viewer.expandToLevel(obj, 1);
                    }
                }
            }
        });
        this.provider = new AccessPathBrowserContentProvider(this.direction);
        viewer.setContentProvider((IContentProvider)this.provider);
        viewer.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.editor));
        viewer.setSorter(new ViewerSorter());
        viewer.setInput((Object)this.accessPoint);
        this.updateSelection = true;
        return composite;
    }

    private void checkCanClose(TreeItem methodItem) {
        Button okButton;
        Object data;
        boolean canClose = false;
        if (methodItem != null && (data = methodItem.getData()) instanceof AccessPointType) {
            canClose = this.direction.equals((Object)((AccessPointType)data).getDirection());
        }
        if ((okButton = this.getButton(0)) != null) {
            okButton.setEnabled(canClose);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return buttonBar;
    }

    private String getMethodPath(TreeItem methodItem) {
        String methodPath = null;
        if (methodItem != null) {
            if (methodItem.getParentItem() != null) {
                methodPath = this.getMethodPath(methodItem.getParentItem());
            }
            IIdentifiableElement info = (IIdentifiableElement)methodItem.getData();
            String methodName = info.getId();
            String separator = null;
            if (info instanceof IExtensibleElement) {
                separator = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)info), (String)"carnot:engine:path:separator");
            }
            methodPath = methodPath == null ? methodName : String.valueOf(methodPath) + (separator == null ? "." : separator) + methodName;
        }
        return methodPath;
    }

    public String getSelectedMethod() {
        return this.selectedMethod;
    }

    public void setMethod(String method) {
        this.selectedMethod = method;
    }
}

