/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.views.bookmark;

import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.ViewType;
import org.eclipse.stardust.model.xpdl.carnot.ViewableType;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateViewableTypeCommand;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;

public class BookmarkDropTargetListener
implements DropTargetListener {
    private TreeViewer viewer;
    private EditDomain domain;
    private ViewType view;

    public BookmarkDropTargetListener(TreeViewer viewer, EditDomain domain) {
        this.viewer = viewer;
        this.domain = domain;
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        IModelElement element = (IModelElement)event.data;
        if (this.isViewableElement(element) && event.item != null) {
            Object treeElement = event.item.getData();
            if (treeElement instanceof ViewType) {
                this.view = (ViewType)treeElement;
            } else if (treeElement instanceof ViewableType) {
                this.view = (ViewType)((ViewableType)treeElement).eContainer();
            }
            if (this.view != null) {
                this.domain.getCommandStack().execute((Command)new CreateViewableTypeCommand(this.view, element, this.viewer));
                this.viewer.refresh();
                this.viewer.expandToLevel((Object)this.view, -1);
                this.view = null;
            }
        }
    }

    private boolean isViewableElement(IModelElement element) {
        return element instanceof ActivityType || element instanceof ApplicationType || element instanceof DataType || element instanceof ParticipantType || element instanceof IModelParticipant || element instanceof ProcessDefinitionType || element instanceof TriggerType;
    }
}

