/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.views.repository;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.core.model.xpdl.XpdlUtils;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.DocumentRoot;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.CarnotWorkflowModelResourceImpl;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.views.repository.RepositoryAction;
import org.eclipse.stardust.modeling.core.views.repository.ResourceInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.w3c.dom.Document;

public class CreateVersionAction
extends RepositoryAction {
    public static final int CREATE_INITIAL_VERSION = 0;
    public static final int CREATE_SUCCESOR_VERSION = 1;
    private int type;
    protected String basicFileName;

    public CreateVersionAction(IWorkbenchPart part, int type) {
        super(part);
        this.type = type;
        switch (type) {
            case 0: {
                this.setText(Diagram_Messages.LB_Versionize);
                break;
            }
            case 1: {
                this.setText(Diagram_Messages.LB_CreateSuccesorVersion);
            }
        }
    }

    @Override
    protected boolean calculateEnabled(ResourceInfo info, IFile file) {
        int[] copy = this.copyVersion(info);
        int n = copy.length - 1;
        copy[n] = copy[n] + 1;
        ResourceInfo version = info.getParent().findChild(copy);
        switch (this.type) {
            case 0: {
                return version == null;
            }
            case 1: {
                return version != null;
            }
        }
        return false;
    }

    private int[] copyVersion(ResourceInfo info) {
        int[] vs = info.getVersionNumbers();
        int[] newVs = new int[vs.length];
        System.arraycopy(vs, 0, newVs, 0, vs.length);
        return newVs;
    }

    @Override
    protected boolean supportsMultiSelection() {
        return false;
    }

    @Override
    protected boolean run(IFile file) {
        ModelType model = null;
        try {
            model = this.create(file);
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)Diagram_Messages.MSG_Error, (String)e.getStatus().toString());
            return false;
        }
        if (model == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Diagram_Messages.MSG_Error, (String)MessageFormat.format(Diagram_Messages.MSG_RESOURCE_CONTAINS_NO_MODEL, file));
            return false;
        }
        if (!this.updateModel(file, model)) {
            return false;
        }
        this.basicFileName = this.basicFileName == null ? this.findResource(file).getBasicFileName() : this.basicFileName;
        file = this.getNewFile(this.basicFileName.substring(this.basicFileName.lastIndexOf("/") + 1), file.getParent(), AttributeUtil.getAttributeValue((IExtensibleElement)model, (String)"carnot:engine:version"), file.getFileExtension());
        this.basicFileName = null;
        Resource resource = this.createResource(file);
        CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
        DocumentRoot root = factory.createDocumentRoot();
        root.setModel(model);
        resource.getContents().add((Object)root);
        try {
            this.saveResource(resource);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)Diagram_Messages.MSG_Error, (String)e.getMessage());
            return false;
        }
        if (!this.supportsMultiSelection()) {
            this.openEditor(file);
        }
        return true;
    }

    protected boolean updateModel(IFile file, ModelType model) {
        ResourceInfo info = this.findResource(file);
        int[] newVersion = this.bumpVersion(info);
        String version = this.toString(newVersion);
        AttributeUtil.setAttribute((IExtensibleElement)model, (String)"carnot:engine:version", (String)version);
        return true;
    }

    private void saveResource(Resource emfResource) throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        URI uri = emfResource.getURI();
        options.put("ENCODING", "ISO-8859-1");
        if (emfResource != null && uri.fileExtension() != null && uri.fileExtension().endsWith("xpdl") && emfResource instanceof CarnotWorkflowModelResourceImpl) {
            Document domCwm = ((XMLResource)emfResource).save(null, options, null);
            if (domCwm != null) {
                StreamSource xsltSource;
                try {
                    URL xsltURL = XpdlUtils.getCarnot2XpdlStylesheet();
                    if (xsltURL == null) {
                        throw new InternalException(Diagram_Messages.MSG_UNABLE_TO_FIND_XPDL_EXPORT_STYLESHEET);
                    }
                    xsltSource = new StreamSource(xsltURL.openStream());
                }
                catch (IOException e) {
                    throw new PublicException(Diagram_Messages.MSG_INVALID_JAXP_SETUP, (Throwable)e);
                }
                ClassLoader cclBackup = Thread.currentThread().getContextClassLoader();
                try {
                    try {
                        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                        StreamResult target = new StreamResult(((CarnotWorkflowModelResourceImpl)emfResource).getNewOutputStream());
                        TransformerFactory transformerFactory = XmlUtils.newTransformerFactory();
                        Transformer xpdlTrans = transformerFactory.newTransformer(xsltSource);
                        XmlUtils.transform((Source)new DOMSource(domCwm), (Transformer)xpdlTrans, (Result)target, null, (int)3, (String)"UTF-8");
                    }
                    catch (TransformerConfigurationException e) {
                        throw new PublicException(Diagram_Messages.MSG_INVALID_JAXP_SETUP, (Throwable)e);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cclBackup);
                }
            }
        } else {
            emfResource.save(options);
        }
    }

    private IFile getNewFile(String id, IContainer parent, String version, String extension) {
        IFile newFile;
        int ix = 0;
        while (true) {
            StringBuffer sb = new StringBuffer();
            sb.append(id);
            if (ix > 0) {
                sb.append(ix);
            }
            sb.append('_').append(version).append("." + extension);
            newFile = parent.getFile((IPath)new Path(sb.toString()));
            if (!newFile.exists()) break;
            ++ix;
        }
        return newFile;
    }

    private Resource createResource(IFile file) {
        if (file.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)file.getName(), (String)Diagram_Messages.MSG_AnotherFileAlreadyExists)) {
            return null;
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toOSString());
        return resourceSet.createResource(fileURI);
    }

    private String toString(int[] newVersion) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < newVersion.length) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(newVersion[i]);
            ++i;
        }
        String version = sb.toString();
        return version;
    }

    private int[] bumpVersion(ResourceInfo info) {
        switch (this.type) {
            case 0: {
                int[] copy = this.copyVersion(info);
                int n = copy.length - 1;
                copy[n] = copy[n] + 1;
                return copy;
            }
            case 1: {
                int count = info.countPseudoNodes(info.getId());
                int[] vs = info.getVersionNumbers();
                int[] newVersion = new int[vs.length + count + 1];
                System.arraycopy(vs, 0, newVersion, 0, vs.length);
                Arrays.fill(newVersion, vs.length, newVersion.length, 0);
                int n = newVersion.length - 1;
                newVersion[n] = newVersion[n] + 1;
                return newVersion;
            }
        }
        return null;
    }
}

