/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ModelElementSelectionDialog
extends ElementListSelectionDialog {
    private final IFile modelFile;
    private final Class[] elementTypeFilter;
    private final WorkflowModelManager modelManager;
    private ModelType model;

    public ModelElementSelectionDialog(Shell parentShell, IFile modelFile, Class[] elementTypeFilter) {
        super(parentShell, (ILabelProvider)new EObjectLabelProvider(null));
        this.modelFile = modelFile;
        this.elementTypeFilter = elementTypeFilter;
        this.modelManager = new WorkflowModelManager();
        try {
            this.init();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void init() throws PartInitException, CoreException {
        this.loadModel();
        EList processDefinitions = this.model.getProcessDefinition();
        this.setElements(processDefinitions.toArray());
    }

    private void loadModel() throws PartInitException, CoreException {
        if (this.modelFile.exists()) {
            try {
                this.modelManager.load(URI.createPlatformResourceURI((String)this.modelFile.getFullPath().toString()));
            }
            catch (Exception e) {
                throw new PartInitException(Debug_Messages.EXP_FailedLoadingModel, (Throwable)e);
            }
            this.model = this.modelManager.getModel();
            if (this.model == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.core", 0, Debug_Messages.EXP_ErrorLoadingNetwork, null));
            }
        }
    }
}

