/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.debugger.types;

import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.stardust.common.Assert;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.debugger.types.ActivityInstanceDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.ApplicationDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.DataField;
import org.eclipse.stardust.modeling.debug.debugger.types.DataMappingDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.DataValueDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.NamedValue;
import org.eclipse.stardust.modeling.debug.debugger.types.ProcessInstanceDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.TransitionTokenDigest;

public class JavaTypeValueFactory {
    public static <T> T createInstance(IVariable variable) {
        block12: {
            try {
                IJavaValue value = (IJavaValue)variable.getValue();
                if (value.getJavaType() == null) break block12;
                String varTypeName = variable.getReferenceTypeName();
                if (ActivityInstanceDigest.class.getName().equals(varTypeName)) {
                    return (T)new ActivityInstanceDigest(variable);
                }
                if (ProcessInstanceDigest.class.getName().equals(varTypeName)) {
                    return (T)new ProcessInstanceDigest(variable);
                }
                if (TransitionTokenDigest.class.getName().equals(varTypeName)) {
                    return (T)new TransitionTokenDigest(variable);
                }
                if (ApplicationDigest.class.getName().equals(varTypeName)) {
                    return (T)new ApplicationDigest(variable);
                }
                if (DataValueDigest.class.getName().equals(varTypeName)) {
                    return (T)new DataValueDigest(variable);
                }
                if (DataMappingDigest.class.getName().equals(varTypeName)) {
                    return (T)new DataMappingDigest(variable);
                }
                if (NamedValue.class.getName().equals(varTypeName)) {
                    return (T)new NamedValue(variable);
                }
                if (DataField.class.getName().equals(varTypeName)) {
                    return (T)new DataField(variable);
                }
                if (String.class.getName().equals(varTypeName)) {
                    return (T)value.getValueString();
                }
                if (Boolean.class.getName().equals(varTypeName)) {
                    IVariable[] subVars = value.getVariables();
                    return JavaTypeValueFactory.createInstance("value", subVars);
                }
                if (!Boolean.TYPE.equals(varTypeName)) break block12;
                return (T)Boolean.valueOf(value.getValueString());
            }
            catch (DebugException e) {
                throw new InternalException("", (Throwable)e);
            }
        }
        return null;
    }

    public static <T> T createInstance(String name, IVariable[] variables) {
        try {
            int idx = 0;
            while (idx < variables.length) {
                if (name.equals(variables[idx].getName())) {
                    return JavaTypeValueFactory.createInstance(variables[idx]);
                }
                ++idx;
            }
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
        return null;
    }

    public static Object[] createArrayInstance(IVariable variable) {
        try {
            Object[] result = null;
            IJavaValue value = (IJavaValue)variable.getValue();
            if (value.getJavaType() != null) {
                String arrayTypeName = variable.getReferenceTypeName();
                Assert.condition((boolean)arrayTypeName.endsWith("[]"), (String)MessageFormat.format(Debug_Messages.MSG_COND_isNoArrayType, arrayTypeName));
                IVariable[] arrayVariables = value.getVariables();
                int arraySize = arrayVariables.length;
                result = new Object[arraySize];
                int idx = 0;
                while (idx < arraySize) {
                    result[idx] = JavaTypeValueFactory.createInstance(arrayVariables[idx]);
                    ++idx;
                }
            }
            return result;
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }

    public static Object[] createArrayInstance(String name, IVariable[] variables) {
        try {
            Object[] result = null;
            int idx = 0;
            while (idx < variables.length) {
                if (name.equals(variables[idx].getName())) {
                    result = JavaTypeValueFactory.createArrayInstance(variables[idx]);
                    break;
                }
                ++idx;
            }
            return result;
        }
        catch (DebugException e) {
            throw new InternalException("", (Throwable)e);
        }
    }
}

