/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.interpreter;

import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.modeling.debug.interpreter.Column;
import org.eclipse.stardust.modeling.debug.interpreter.Data;
import org.eclipse.stardust.modeling.debug.interpreter.DataGroup;
import org.eclipse.stardust.modeling.debug.interpreter.TableData;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataParser
extends HandlerBase {
    private static final Logger trace = LogManager.getLogger(MetadataParser.class);
    private SAXParser parser;
    private Stack dataGroupStack;
    private DataGroup topGroup;
    private TableData currentTable;

    public MetadataParser() {
        try {
            this.parser = XmlUtils.newSaxParserFactory((boolean)false).newSAXParser();
            this.parser.getParser().setDocumentHandler(this);
            this.parser.getParser().setErrorHandler(this);
            this.topGroup = null;
            this.dataGroupStack = new Stack();
        }
        catch (ParserConfigurationException e) {
            throw new InternalException("Invalid JAXP setup.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new InternalException("SAX error.", (Throwable)e);
        }
    }

    @Override
    public void startElement(String tag, AttributeList atts) throws SAXException {
        String id = null;
        String label = null;
        String type = null;
        String rowString = null;
        byte row = 0;
        byte column = 0;
        String columnString = null;
        String mandatoryString = null;
        String readonlyString = null;
        Hashtable<String, String> properties = null;
        if (tag.compareTo("DATA_GROUP") == 0) {
            DataGroup dataGroup;
            trace.debug((Object)"Processing data group ...");
            int i = 0;
            while (i < atts.getLength()) {
                if (atts.getName(i).compareTo("id") == 0) {
                    id = atts.getValue(i);
                } else if (atts.getName(i).compareTo("label") == 0) {
                    label = atts.getValue(i);
                } else if (atts.getName(i).compareTo("type") == 0) {
                    type = atts.getValue(i);
                } else if (atts.getName(i).compareTo("row") == 0) {
                    rowString = atts.getValue(i);
                } else if (atts.getName(i).compareTo("column") == 0) {
                    columnString = atts.getValue(i);
                } else {
                    if (properties == null) {
                        properties = new Hashtable<String, String>();
                    }
                    properties.put(atts.getName(i), atts.getName(i));
                    trace.debug((Object)("Property " + atts.getName(i) + " set to " + atts.getValue(i)));
                }
                ++i;
            }
            try {
                row = Byte.parseByte(rowString);
                column = Byte.parseByte(columnString);
                trace.debug((Object)("R/C: " + row + " " + column));
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.topGroup == null) {
                this.topGroup = dataGroup = new DataGroup(label);
            } else {
                dataGroup = ((DataGroup)this.dataGroupStack.peek()).createSubGroup(label);
            }
            this.dataGroupStack.push(dataGroup);
            dataGroup.setID(id);
            dataGroup.setLabel(label);
            dataGroup.setType(type);
            dataGroup.setRow(row);
            dataGroup.setColumn(column);
            dataGroup.setProperties(properties);
            return;
        }
        if (tag.compareTo("DATA") == 0) {
            trace.debug((Object)"Processing data definition ...");
            int i = 0;
            while (i < atts.getLength()) {
                if (atts.getName(i).compareTo("id") == 0) {
                    id = atts.getValue(i);
                } else if (atts.getName(i).compareTo("label") == 0) {
                    label = atts.getValue(i);
                } else if (atts.getName(i).compareTo("type") == 0) {
                    type = atts.getValue(i);
                } else if (atts.getName(i).compareTo("mandatory") == 0) {
                    mandatoryString = atts.getValue(i);
                } else if (atts.getName(i).compareTo("readonly") == 0) {
                    readonlyString = atts.getValue(i);
                } else if (atts.getName(i).compareTo("length") == 0) {
                    atts.getValue(i);
                } else if (atts.getName(i).compareTo("default") == 0) {
                    atts.getValue(i);
                } else if (atts.getName(i).compareTo("row") == 0) {
                    rowString = atts.getValue(i);
                } else if (atts.getName(i).compareTo("column") == 0) {
                    columnString = atts.getValue(i);
                } else if (atts.getName(i).compareTo("tooltip") == 0) {
                    atts.getValue(i);
                } else {
                    if (properties == null) {
                        properties = new Hashtable();
                    }
                    properties.put(atts.getName(i), atts.getName(i));
                }
                ++i;
            }
            try {
                row = Byte.parseByte(rowString);
                column = Byte.parseByte(columnString);
            }
            catch (NumberFormatException numberFormatException) {}
            Data data = ((DataGroup)this.dataGroupStack.peek()).createData(Integer.TYPE, label, true, true);
            data.setID(id);
            if (label.equals("null")) {
                label = null;
            }
            data.setLabel(label);
            data.setRow(row);
            data.setColumn(column);
            if (readonlyString.equals("true")) {
                data.setReadonly(true);
            } else {
                data.setReadonly(false);
            }
            if (mandatoryString.equals("true")) {
                data.setMandatory(true);
            } else {
                data.setMandatory(false);
            }
            data.setProperties(properties);
            return;
        }
        if (tag.compareTo("TABLE_DATA") == 0) {
            trace.debug((Object)"Processing table data ...");
            int i = 0;
            while (i < atts.getLength()) {
                if (atts.getName(i).compareTo("id") == 0) {
                    id = atts.getValue(i);
                } else if (atts.getName(i).compareTo("label") == 0) {
                    label = atts.getValue(i);
                } else if (atts.getName(i).compareTo("readonly") == 0) {
                    readonlyString = atts.getValue(i);
                } else if (atts.getName(i).compareTo("row") == 0) {
                    rowString = atts.getValue(i);
                } else if (atts.getName(i).compareTo("column") == 0) {
                    columnString = atts.getValue(i);
                } else if (atts.getName(i).compareTo("tooltip") == 0) {
                    atts.getValue(i);
                } else {
                    if (properties == null) {
                        properties = new Hashtable();
                    }
                    properties.put(atts.getName(i), atts.getName(i));
                }
                ++i;
            }
            this.currentTable = ((DataGroup)this.dataGroupStack.peek()).createTableData(label, true, true);
            this.currentTable.setProperties(properties);
            return;
        }
        if (tag.compareTo("COLUMN") == 0) {
            trace.debug((Object)"Processing column ...");
            int i = 0;
            while (i < atts.getLength()) {
                if (atts.getName(i).compareTo("id") == 0) {
                    id = atts.getValue(i);
                } else if (atts.getName(i).compareTo("label") == 0) {
                    label = atts.getValue(i);
                } else if (atts.getName(i).compareTo("type") == 0) {
                    type = atts.getValue(i);
                } else if (atts.getName(i).compareTo("mandatory") == 0) {
                    mandatoryString = atts.getValue(i);
                } else if (atts.getName(i).compareTo("readonly") == 0) {
                    readonlyString = atts.getValue(i);
                } else if (atts.getName(i).compareTo("length") == 0) {
                    atts.getValue(i);
                } else if (atts.getName(i).compareTo("row") == 0) {
                    rowString = atts.getValue(i);
                } else if (atts.getName(i).compareTo("column") == 0) {
                    columnString = atts.getValue(i);
                } else if (atts.getName(i).compareTo("tooltip") == 0) {
                    atts.getValue(i);
                } else {
                    if (properties == null) {
                        properties = new Hashtable();
                    }
                    properties.put(atts.getName(i), atts.getName(i));
                }
                ++i;
            }
            if (this.currentTable == null) {
                throw new SAXException("No current table defined.");
            }
            Column tableColumn = this.currentTable.createColumn(Integer.TYPE, label, true, true);
            tableColumn.setProperties(properties);
            return;
        }
    }

    @Override
    public void endElement(String tag) throws SAXException {
        if (tag.compareTo("DATA_GROUP") == 0) {
            this.dataGroupStack.pop();
        } else if (tag.compareTo("TABLE") == 0) {
            this.currentTable = null;
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        System.err.println("Warning at (file " + e.getSystemId() + ", line " + e.getLineNumber() + ", char " + e.getColumnNumber() + "): " + e.getMessage());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw new SAXException("Error at (file " + e.getSystemId() + ", line " + e.getLineNumber() + ", char " + e.getColumnNumber() + "): " + e.getMessage());
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException("Fatal Error at (file " + e.getSystemId() + ", line " + e.getLineNumber() + ", char " + e.getColumnNumber() + "): " + e.getMessage());
    }

    public DataGroup parse(String filePath) {
        try {
            this.parser.parse(filePath, new DefaultHandler());
            return this.topGroup;
        }
        catch (Exception x) {
            throw new PublicException(x.getMessage());
        }
    }
}

